/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.TryFindLand;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.primal.entity.ai.behavior.crocodile.CrocodileBasking;
import org.primal.entity.ai.behavior.crocodile.CrocodileExploding;
import org.primal.entity.ai.behavior.crocodile.CrocodileGoesToCompass;
import org.primal.entity.ai.behavior.crocodile.CrocodileGoesToEgg;
import org.primal.entity.ai.behavior.crocodile.CrocodileGoesToReed;
import org.primal.entity.ai.behavior.crocodile.CrocodileStartAttack;
import org.primal.entity.ai.behavior.crocodile.CrocodileThrash;
import org.primal.entity.ai.behavior.generic.TryFindWaterSurface;
import org.primal.entity.ai.behavior.generic.TryLayEggOnLandOrNest;
import org.primal.entity.animal.CrocodileEntity;
import org.primal.registry.Primal_Activities;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sensors;
import org.primal.util.MiscUtil;

public class CrocodileAi {
    private static final ImmutableList<SensorType<? extends Sensor<? super CrocodileEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, (Object)((SensorType)Primal_Sensors.NEAREST_BABY.get()), (Object)SensorType.f_26812_, (Object)SensorType.f_26822_, (Object)((SensorType)Primal_Sensors.CROCODILE_ATTACK_SENSOR.get()), (Object)((SensorType)Primal_Sensors.CROCODILE_TEMPTATIONS_SENSOR.get()), (Object)((SensorType)Primal_Sensors.CROCODILE_NEAREST_EGG.get()), (Object)((SensorType)Primal_Sensors.CROCODILE_NEAREST_REED.get()));
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_148194_, (Object)MemoryModuleType.f_217782_, (Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26382_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26375_, MemoryModuleType.f_217768_, MemoryModuleType.f_148197_, MemoryModuleType.f_148198_, MemoryModuleType.f_148196_, MemoryModuleType.f_26383_, MemoryModuleType.f_148201_, MemoryModuleType.f_26356_, MemoryModuleType.f_217767_, MemoryModuleType.f_26357_, (MemoryModuleType)Primal_MemoryModuleTypes.WAS_BASKING.get(), (MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_VISIBLE_BABY.get(), (MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get(), MemoryModuleType.f_26336_, (MemoryModuleType)Primal_MemoryModuleTypes.IS_THRASHING.get(), (MemoryModuleType)Primal_MemoryModuleTypes.IS_EXPLODING.get(), (MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get()});
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.m_146622_((int)5, (int)16);
    private static final UniformInt RETREAT_DURATION = TimeUtil.m_145020_((int)5, (int)20);

    public static Ingredient getTemptations() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42581_});
    }

    public static void initMemories(CrocodileEntity CrocodileEntity2, RandomSource random) {
    }

    public static Brain.Provider<CrocodileEntity> brainProvider() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<CrocodileEntity> brain) {
        CrocodileAi.initCoreActivity(brain);
        CrocodileAi.initIdleActivity(brain);
        CrocodileAi.initFightActivity(brain);
        CrocodileAi.initThrashActivity(brain);
        CrocodileAi.initExplosionActivity(brain);
        CrocodileAi.initRetreatActivity(brain);
        CrocodileAi.initLayEggActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<CrocodileEntity> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Brain<CrocodileEntity> brain) {
        brain.m_21891_(Activity.f_37979_, 10, ImmutableList.of((Object)StartAttacking.m_257710_(CrocodileAi::findNearestValidAttackTarget), (Object)new AnimalMakeLove((EntityType)Primal_Entities.CROCODILE.get(), 1.0f), TryFindWaterSurface.create(16, 1.0f), (Object)((Object)new CrocodileGoesToCompass()), (Object)((Object)new CrocodileGoesToEgg()), (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(livingEntity -> Float.valueOf(1.0f), livingEntity -> livingEntity.m_6162_() ? 2.5 : 3.5), (Object)4), (Object)Pair.of((Object)BehaviorBuilder.m_257845_(crocodile -> !crocodile.m_5912_() || crocodile.m_20146_() < 3500, (OneShot)BabyFollowAdult.m_257685_((UniformInt)ADULT_FOLLOW_RANGE, (float)1.0f)), (Object)1))), (Object)((Object)new CrocodileGoesToReed()), CrocodileAi.createIdleMovementBehaviors()));
    }

    private static void initFightActivity(Brain<CrocodileEntity> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.0f), (Object)((Object)new CrocodileStartAttack(20)), (Object)SetEntityLookTarget.m_257660_((float)50.0f), (Object)StopAttackingIfTargetInvalid.m_257822_(), (Object)EraseMemoryIf.m_258093_(Animal::m_27593_, (MemoryModuleType)MemoryModuleType.f_26372_)), MemoryModuleType.f_26372_);
    }

    public static void wasHurtBy(CrocodileEntity crocodile, LivingEntity target) {
        Brain<CrocodileEntity> brain = crocodile.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26357_);
        brain.m_21936_(MemoryModuleType.f_26375_);
        if (crocodile.m_6162_()) {
            CrocodileAi.retreatFromNearestTarget(crocodile, target);
            for (CrocodileEntity nearCrocodile : CrocodileAi.getNearestAdultCrocodiles(crocodile)) {
                nearCrocodile.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)target);
            }
        } else {
            crocodile.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)target);
        }
    }

    private static List<CrocodileEntity> getNearestAdultCrocodiles(CrocodileEntity crocodile) {
        return crocodile.m_9236_().m_45976_(CrocodileEntity.class, crocodile.m_20191_().m_82377_(30.0, 5.0, 30.0)).stream().filter(crocodile1 -> !crocodile1.m_6162_()).toList();
    }

    private static void retreatFromNearestTarget(CrocodileEntity crocodile, LivingEntity target) {
        Brain<CrocodileEntity> brain = crocodile.m_6274_();
        LivingEntity avoidTarget = BehaviorUtils.m_22625_((LivingEntity)crocodile, (Optional)brain.m_21952_(MemoryModuleType.f_26383_), (LivingEntity)target);
        avoidTarget = BehaviorUtils.m_22625_((LivingEntity)crocodile, (Optional)brain.m_21952_(MemoryModuleType.f_26372_), (LivingEntity)avoidTarget);
        CrocodileAi.setAvoidTarget(crocodile, avoidTarget);
    }

    private static void setAvoidTarget(CrocodileEntity crocodile, LivingEntity target) {
        crocodile.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        crocodile.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        crocodile.m_6274_().m_21882_(MemoryModuleType.f_26383_, (Object)target, (long)RETREAT_DURATION.m_214085_(crocodile.m_9236_().f_46441_));
    }

    private static void initThrashActivity(Brain<CrocodileEntity> brain) {
        brain.m_21895_((Activity)Primal_Activities.THRASH.get(), 10, ImmutableList.of((Object)((Object)new CrocodileThrash(100))), (MemoryModuleType)Primal_MemoryModuleTypes.IS_THRASHING.get());
    }

    private static void initExplosionActivity(Brain<CrocodileEntity> brain) {
        brain.m_21895_((Activity)Primal_Activities.EXPLODING.get(), 10, ImmutableList.of((Object)((Object)new CrocodileExploding(40))), (MemoryModuleType)Primal_MemoryModuleTypes.IS_EXPLODING.get());
    }

    private static void initRetreatActivity(Brain<CrocodileEntity> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.m_257370_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.2f, (int)20, (boolean)false), CrocodileAi.createIdleMovementBehaviors(), (Object)SetEntityLookTargetSometimes.m_257458_((float)8.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), (Object)EraseMemoryIf.m_258093_(crocodile -> !crocodile.m_6162_(), (MemoryModuleType)MemoryModuleType.f_26383_)), MemoryModuleType.f_26383_);
    }

    private static void initLayEggActivity(Brain<CrocodileEntity> brain) {
        brain.m_21903_(Activity.f_219848_, ImmutableList.of((Object)Pair.of((Object)1, TryLayEggOnLandOrNest.create((Block)Primal_Blocks.CROCODILE_EGG.get(), MiscUtil.EGGS_3, 3, 1)), (Object)Pair.of((Object)2, (Object)TryFindLand.m_257647_((int)16, (float)1.0f)), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)BehaviorBuilder.m_257590_(Entity::m_20096_), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_217767_, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static RunOne<CrocodileEntity> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)((Object)new CrocodileBasking(20)), (Object)1), (Object)Pair.of((Object)BehaviorBuilder.m_257845_(Predicate.not(crocodile -> crocodile.m_5912_() || crocodile.m_5842_() && crocodile.m_20146_() > 3500), (OneShot)RandomStroll.m_257965_((float)1.0f)), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivity(CrocodileEntity crocodile) {
        Brain<CrocodileEntity> brain = crocodile.m_6274_();
        if (crocodile.m_6162_()) {
            brain.m_21926_((List)ImmutableList.of((Object)((Activity)Primal_Activities.EXPLODING.get()), (Object)Activity.f_37991_, (Object)Activity.f_37979_));
        } else {
            brain.m_21926_((List)ImmutableList.of((Object)((Activity)Primal_Activities.EXPLODING.get()), (Object)((Activity)Primal_Activities.THRASH.get()), (Object)Activity.f_37988_, (Object)Activity.f_219848_, (Object)Activity.f_37979_));
        }
        crocodile.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_) || brain.m_21874_((MemoryModuleType)Primal_MemoryModuleTypes.IS_THRASHING.get()));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(CrocodileEntity crocodile) {
        return BehaviorUtils.m_217126_((LivingEntity)crocodile) || crocodile.m_6162_() || crocodile.isPacified() ? Optional.empty() : crocodile.m_6274_().m_21952_(MemoryModuleType.f_148194_);
    }
}

