/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.bear;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.BearEntity;

public final class BearRoar
extends Behavior<BearEntity> {
    public BearRoar() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_217782_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT), 45);
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull BearEntity bear, long p_217590_) {
        return true;
    }

    protected void start(@NotNull ServerLevel level, @Nonnull BearEntity bear, long gameTime) {
        bear.stopMoving();
        Optional target = bear.m_6274_().m_21952_(MemoryModuleType.f_217782_);
        target.ifPresent(entity -> BehaviorUtils.m_22595_((LivingEntity)bear, (LivingEntity)entity));
        if (bear.m_6274_().m_21874_(MemoryModuleType.f_217771_)) {
            this.stop(level, bear, gameTime);
        } else {
            bear.m_20124_(Pose.ROARING);
            if (bear.getRoarSound() != null) {
                bear.m_5496_(bear.getRoarSound(), 4.0f, 1.0f);
            }
            bear.triggerAnim("base_controller", "roar");
        }
    }

    protected void stop(@NotNull ServerLevel level, BearEntity bear, long gameTime) {
        if (bear.m_217003_(Pose.ROARING)) {
            bear.m_20124_(Pose.STANDING);
        }
        bear.m_6274_().m_21952_(MemoryModuleType.f_217782_).ifPresent(bear::setAttackTarget);
        bear.m_6274_().m_21936_(MemoryModuleType.f_217782_);
        if (!bear.m_6274_().m_21874_(MemoryModuleType.f_217771_)) {
            bear.m_6274_().m_21882_(MemoryModuleType.f_217771_, (Object)Unit.INSTANCE, 200L);
        }
    }
}

