/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.bear;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.BearEntity;

public class BearSleep
extends Behavior<BearEntity> {
    public BearSleep() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_217782_, (Object)MemoryStatus.VALUE_ABSENT), Integer.MAX_VALUE);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull BearEntity bear) {
        return this.canStillUse(level, bear, 0L);
    }

    protected boolean canStillUse(ServerLevel level, @NotNull BearEntity bear, long gameTime) {
        return level.m_46462_() && !bear.m_20160_() && (bear.m_21213_() > bear.f_19797_ || bear.f_19797_ - bear.m_21213_() >= 200) && bear.getAwakeCounter() == 0 && this.m_22543_((LivingEntity)bear);
    }

    protected void start(@NotNull ServerLevel level, BearEntity bear, long gameTime) {
        bear.stopMoving();
        if (!bear.isBearSleeping()) {
            bear.triggerAnim("base_controller", "sleep_start");
        }
        bear.m_20124_(Pose.CROAKING);
        if (bear.m_20160_()) {
            bear.m_20153_();
        }
        bear.setBearSleeping(true);
    }

    protected void tick(@NotNull ServerLevel level, @NotNull BearEntity bear, long gameTime) {
        bear.stopMoving();
    }

    protected void stop(@NotNull ServerLevel level, BearEntity entity, long gameTime) {
        entity.triggerAnim("base_controller", "sleep_end");
        entity.m_20124_(Pose.STANDING);
        if (entity.getWakeUpSound() != null) {
            entity.m_5496_(entity.getWakeUpSound(), 1.0f, 0.8f + (float)entity.m_217043_().m_216332_(0, 2) * 0.1f);
        }
        entity.setBearSleeping(false);
        entity.setAwakeCounter(600 + entity.m_217043_().m_216332_(20, 200));
    }
}

