/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.eagle;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.EagleEntity;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Tags;

public class EagleSnatch
extends Behavior<EagleEntity> {
    private long endTimestamp = 10L;
    private final int defaultDuration;

    public EagleSnatch(int defaultDuration) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get()), (Object)MemoryStatus.VALUE_ABSENT), defaultDuration);
        this.defaultDuration = defaultDuration;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, EagleEntity eagle) {
        return !eagle.m_20197_().isEmpty();
    }

    protected void start(@NotNull ServerLevel level, @NotNull EagleEntity eagle, long gameTime) {
        List<EagleEntity> babyEagles;
        Vec3 lookVec = eagle.m_20154_().m_82541_();
        int finalDuration = this.defaultDuration;
        double strengthAddition = 0.0;
        if (eagle.m_21023_(MobEffects.f_19600_)) {
            int amplifier = Objects.requireNonNull(eagle.m_21124_(MobEffects.f_19600_)).m_19564_();
            strengthAddition = 4 * (amplifier + 1);
            finalDuration += 2 * (amplifier + 1);
        }
        double verticalAddition = 20.0 + strengthAddition;
        this.endTimestamp = gameTime + (long)finalDuration;
        double forward = 10.0;
        Vec3 targetPos = eagle.m_20182_().m_82520_(lookVec.f_82479_ * forward, lookVec.f_82480_ * forward + verticalAddition, lookVec.f_82481_ * forward);
        if (!eagle.isFollowing() && eagle.m_146895_() != null && eagle.m_146895_().m_6095_().m_204039_(Primal_Tags.Entity.EAGLE_HUNTABLE) && !(babyEagles = level.m_45976_(EagleEntity.class, eagle.m_20191_().m_82400_(10.0)).stream().filter(babyEagle -> babyEagle.m_6162_() && !babyEagle.isFollowing()).toList()).isEmpty()) {
            BlockPos babyPos = babyEagles.get(level.f_46441_.m_188503_(babyEagles.size())).m_20097_();
            targetPos = new Vec3((double)babyPos.m_123341_(), (double)(babyPos.m_123342_() + 5), (double)babyPos.m_123343_());
        }
        BlockPos flyTo = BlockPos.m_274446_((Position)targetPos);
        eagle.stopMoving();
        eagle.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(flyTo));
        eagle.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(flyTo, 1.2f, 0));
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull EagleEntity eagle, long gameTime) {
        return this.checkExtraStartConditions(level, eagle) && this.m_22543_((LivingEntity)eagle);
    }

    protected void tick(@NotNull ServerLevel level, @NotNull EagleEntity eagle, long gameTime) {
        WalkTarget pos;
        LivingEntity living;
        Object e;
        LivingEntity target;
        LivingEntity livingEntity = target = !eagle.m_20197_().isEmpty() && (e = eagle.m_20197_().get(0)) instanceof LivingEntity ? (living = (LivingEntity)e) : null;
        if (target == null) {
            this.stop(level, eagle, gameTime);
        }
        if (eagle.m_6274_().m_21952_(MemoryModuleType.f_26370_).isPresent() && (float)(pos = (WalkTarget)eagle.m_6274_().m_21952_(MemoryModuleType.f_26370_).get()).m_26420_().m_6675_().m_123333_((Vec3i)eagle.m_20097_()) < 2.0f) {
            this.stop(level, eagle, gameTime);
        }
    }

    protected void stop(@NotNull ServerLevel level, @NotNull EagleEntity eagle, long gameTime) {
        if (!eagle.m_20197_().isEmpty()) {
            LivingEntity livingEntity;
            Entity passenger = (Entity)eagle.m_20197_().get(0);
            if (passenger instanceof LivingEntity && (livingEntity = (LivingEntity)passenger).m_21223_() > 0.0f) {
                eagle.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)livingEntity);
            }
            eagle.m_20153_();
        }
        eagle.m_20124_(Pose.STANDING);
        eagle.m_6274_().m_21936_((MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get());
        eagle.m_6274_().m_21882_((MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get(), (Object)true, 20L);
        eagle.m_6274_().m_21882_(MemoryModuleType.f_26373_, (Object)true, 10L);
    }

    protected boolean m_7773_(long gameTime) {
        return gameTime > this.endTimestamp;
    }
}

