/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.animal;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.primal.client.animation.entity.EagleAnimations;
import org.primal.entity.ai.EagleAi;
import org.primal.entity.ai.controls.EagleMoveControl;
import org.primal.entity.misc.TamableAnimalExtension;
import org.primal.registry.Primal_Activities;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sounds;
import org.primal.registry.Primal_Tags;
import org.primal.util.HostileMount;
import org.primal.util.MiscUtil;
import org.primal.util.VariantHolderPrimal;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EagleEntity
extends TamableAnimalExtension
implements VariantHolder<Variant>,
GeoEntity,
NeutralMob,
VariantHolderPrimal<Variant, EagleEntity>,
HostileMount,
FlyingAnimal {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(EagleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> HEALTH_WHEN_START_RIDING = SynchedEntityData.m_135353_(EagleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(EagleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FOLLOWER_STATE = SynchedEntityData.m_135353_(EagleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UUID SLOW_FALLING_ID = UUID.fromString("A5B6CF2A-2F7C-31EF-9022-7C3E7D5E6ABA");
    private static final AttributeModifier SLOW_FALLING = new AttributeModifier(SLOW_FALLING_ID, "Slow falling acceleration reduction", -0.07, AttributeModifier.Operation.ADDITION);
    private final float healthLossToBeReleased = 2.0f;

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.24f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22280_, (double)0.4f).m_22268_(Attributes.f_22277_, 48.0);
    }

    public EagleEntity(EntityType<EagleEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21153_(this.m_21233_());
        this.f_21342_ = new EagleMoveControl((Mob)this, 10, false);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_274367_(2.0f);
    }

    @NotNull
    public SpawnGroupData m_6518_(ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, CompoundTag tag) {
        this.setVariantFromBiome(this, (Holder<Biome>)level.m_204166_(this.m_20183_()));
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, tag);
    }

    @Override
    public void setVariantFromBiome(EagleEntity eagle, Holder<Biome> holder) {
        if (holder.m_203656_(Primal_Tags.Biome.SPAWNS_GOLDEN_EAGLE)) {
            eagle.setVariant(Variant.GOLDEN);
        } else if (holder.m_203656_(Primal_Tags.Biome.SPAWNS_HARPY_EAGLE)) {
            eagle.setVariant(Variant.HARPY);
        } else if (holder.m_203656_(Primal_Tags.Biome.SPAWNS_PHILIPPINE_EAGLE)) {
            eagle.setVariant(Variant.PHILIPPINE);
        } else {
            eagle.setVariant(Variant.BALD);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{EagleAnimations.mainController(this).receiveTriggeredAnimations()});
    }

    public int m_8132_() {
        return this.m_20096_() ? 40 : 90;
    }

    public int m_8085_() {
        return this.m_20096_() ? 15 : 1;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_6674_(@NotNull InteractionHand hand) {
        super.m_6674_(hand);
    }

    public boolean m_7327_(@NotNull Entity entity) {
        return super.m_7327_(entity);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)Variant.BALD.id);
        this.f_19804_.m_135372_(HEALTH_WHEN_START_RIDING, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FOLLOWER_STATE, (Object)0);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant().id);
        compound.m_128350_("HealthWhenStarted", this.getHealthWhenStartRiding());
        if (this.m_21805_() != null) {
            compound.m_128405_("FollowerState", this.getFollowerState());
        }
        compound.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(Variant.byId(compound.m_128451_("Variant")));
        this.setHealthWhenStartRiding(compound.m_128457_("HealthWhenStarted"));
        if (compound.m_128403_("Owner")) {
            this.setFollowerState(compound.m_128451_("FollowerState"));
        }
        if (compound.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)compound.m_128451_("CollarColor")));
        }
    }

    public float getHealthWhenStartRiding() {
        return ((Float)this.f_19804_.m_135370_(HEALTH_WHEN_START_RIDING)).floatValue();
    }

    public void setHealthWhenStartRiding(float healthWhenStartRiding) {
        this.f_19804_.m_135381_(HEALTH_WHEN_START_RIDING, (Object)Float.valueOf(healthWhenStartRiding));
    }

    public void setVariant(@NotNull Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    private void setCollarColor(DyeColor collarColor) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)collarColor.m_41060_());
    }

    public int getFollowerState() {
        return (Integer)this.f_19804_.m_135370_(FOLLOWER_STATE);
    }

    public void setFollowerState(int state) {
        this.f_19804_.m_135381_(FOLLOWER_STATE, (Object)state);
    }

    public boolean isSitting() {
        return this.getFollowerState() == 2;
    }

    public boolean isFollowing() {
        return this.getFollowerState() == 1;
    }

    public boolean isWandering() {
        return this.getFollowerState() == 0;
    }

    public void m_27563_(@NotNull ServerLevel level, @NotNull Animal mate) {
        this.m_277117_(level, mate, null);
        this.m_6274_().m_21879_(MemoryModuleType.f_217767_, (Object)Unit.INSTANCE);
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        EagleEntity eagle = (EagleEntity)((EntityType)Primal_Entities.EAGLE.get()).m_20615_((Level)level);
        if (eagle != null) {
            EagleAi.initMemories(eagle, level.m_213780_());
        }
        return eagle;
    }

    public boolean m_6898_(@NotNull ItemStack stack) {
        return EagleEntity.isMatingFood(stack) || EagleEntity.isHealFood(stack) || EagleEntity.isTameFood(stack);
    }

    public static boolean isTameFood(@NotNull ItemStack stack) {
        return stack.m_150930_(Items.f_42581_);
    }

    public static boolean isHealFood(@NotNull ItemStack stack) {
        return EagleEntity.isTameFood(stack) || EagleEntity.isMatingFood(stack);
    }

    public static boolean isMatingFood(@NotNull ItemStack stack) {
        return stack.m_150930_(Items.f_42699_);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    @Override
    protected boolean canFlyToOwner() {
        return !this.m_6162_();
    }

    public void stopMoving() {
        this.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        this.m_21573_().m_26573_();
        this.m_6274_().m_21936_(MemoryModuleType.f_26371_);
    }

    protected boolean m_6129_() {
        return this.m_6162_() || this.m_6274_().m_21954_((Activity)Primal_Activities.SIT.get());
    }

    protected void m_8024_() {
        super.m_8024_();
        Brain<EagleEntity> brain = this.m_6274_();
        brain.m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        Optional snatching = this.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get());
        if (snatching.isPresent() && ((Boolean)snatching.get()).booleanValue() && this.m_20197_().isEmpty()) {
            this.m_6274_().m_21936_((MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get());
            this.m_20124_(Pose.STANDING);
        }
        if (snatching.isEmpty() && !this.m_20197_().isEmpty()) {
            this.m_20153_();
        }
        EagleAi.updateActivity(this);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_6162_()) {
            Vec3 vec3 = this.m_20184_();
            if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
                this.m_20256_(vec3.m_82542_(1.0, this.m_146909_() > 50.0f ? 1.1 : 0.6, 1.0));
            }
        }
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.m_6109_()) {
            boolean flag;
            double d0 = 0.08;
            AttributeInstance gravity = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            boolean bl = flag = this.m_20184_().f_82480_ <= 0.0;
            if (flag && this.m_21023_(MobEffects.f_19591_)) {
                if (!gravity.m_22109_(SLOW_FALLING)) {
                    gravity.m_22118_(SLOW_FALLING);
                }
            } else if (gravity.m_22109_(SLOW_FALLING)) {
                gravity.m_22130_(SLOW_FALLING);
            }
            d0 = gravity.m_22135_();
            FluidState fluidstate = this.m_9236_().m_6425_(this.m_20183_());
            if ((this.m_20069_() || this.isInFluidType(fluidstate) && fluidstate.getFluidType() != ForgeMod.LAVA_TYPE.get()) && this.m_6129_() && !this.m_203441_(fluidstate)) {
                if (this.m_20069_() || this.isInFluidType(fluidstate) && !this.moveInFluid(fluidstate, travelVector, d0)) {
                    double d9 = this.m_20186_();
                    float f4 = this.m_20142_() ? 0.9f : this.m_6108_();
                    float f5 = 0.02f;
                    float f6 = EnchantmentHelper.m_44922_((LivingEntity)this);
                    if (f6 > 3.0f) {
                        f6 = 3.0f;
                    }
                    if (!this.m_20096_()) {
                        f6 *= 0.5f;
                    }
                    if (f6 > 0.0f) {
                        f4 += (0.54600006f - f4) * f6 / 3.0f;
                        f5 += (this.m_6113_() - f5) * f6 / 3.0f;
                    }
                    if (this.m_21023_(MobEffects.f_19593_)) {
                        f4 = 0.96f;
                    }
                    this.m_19920_(f5 *= (float)this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22135_(), travelVector);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    Vec3 vec36 = this.m_20184_();
                    if (this.f_19862_ && this.m_6147_()) {
                        vec36 = new Vec3(vec36.f_82479_, 0.2, vec36.f_82481_);
                    }
                    this.m_20256_(vec36.m_82542_((double)f4, (double)0.8f, (double)f4));
                    Vec3 vec32 = this.m_20994_(d0, flag, this.m_20184_());
                    this.m_20256_(vec32);
                    if (this.f_19862_ && this.m_20229_(vec32.f_82479_, vec32.f_82480_ + (double)0.6f - this.m_20186_() + d9, vec32.f_82481_)) {
                        this.m_20334_(vec32.f_82479_, 0.3f, vec32.f_82481_);
                    }
                }
            } else if (this.m_20077_() && this.m_6129_() && !this.m_203441_(fluidstate)) {
                double d8 = this.m_20186_();
                this.m_19920_(0.02f, travelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (this.m_204036_(FluidTags.f_13132_) <= this.m_20204_()) {
                    this.m_20256_(this.m_20184_().m_82542_(0.5, (double)0.8f, 0.5));
                    Vec3 vec33 = this.m_20994_(d0, flag, this.m_20184_());
                    this.m_20256_(vec33);
                } else {
                    this.m_20256_(this.m_20184_().m_82490_(0.5));
                }
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -d0 / 4.0, 0.0));
                }
                Vec3 vec34 = this.m_20184_();
                if (this.f_19862_ && this.m_20229_(vec34.f_82479_, vec34.f_82480_ + (double)0.6f - this.m_20186_() + d8, vec34.f_82481_)) {
                    this.m_20334_(vec34.f_82479_, 0.3f, vec34.f_82481_);
                }
            } else if (this.m_21255_()) {
                double d11;
                double d7;
                float f1;
                this.m_245125_();
                Vec3 vec3 = this.m_20184_();
                Vec3 vec31 = this.m_20154_();
                float f = this.m_146909_() * ((float)Math.PI / 180);
                double d1 = Math.sqrt(vec31.f_82479_ * vec31.f_82479_ + vec31.f_82481_ * vec31.f_82481_);
                double d3 = vec3.m_165924_();
                double d4 = vec31.m_82553_();
                double d5 = Math.cos(f);
                d5 = d5 * d5 * Math.min(1.0, d4 / 0.4);
                vec3 = this.m_20184_().m_82520_(0.0, d0 * (-1.0 + d5 * 0.75), 0.0);
                if (vec3.f_82480_ < 0.0 && d1 > 0.0) {
                    double d6 = vec3.f_82480_ * -0.1 * d5;
                    vec3 = vec3.m_82520_(vec31.f_82479_ * d6 / d1, d6, vec31.f_82481_ * d6 / d1);
                }
                if (f < 0.0f && d1 > 0.0) {
                    double d10 = d3 * (double)(-Mth.m_14031_((float)f)) * 0.04;
                    vec3 = vec3.m_82520_(-vec31.f_82479_ * d10 / d1, d10 * 3.2, -vec31.f_82481_ * d10 / d1);
                }
                if (d1 > 0.0) {
                    vec3 = vec3.m_82520_((vec31.f_82479_ / d1 * d3 - vec3.f_82479_) * 0.1, 0.0, (vec31.f_82481_ / d1 * d3 - vec3.f_82481_) * 0.1);
                }
                this.m_20256_(vec3.m_82542_((double)0.99f, (double)0.98f, (double)0.99f));
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (this.f_19862_ && !this.m_9236_().f_46443_ && (f1 = (float)((d7 = d3 - (d11 = this.m_20184_().m_165924_())) * 10.0 - 3.0)) > 0.0f) {
                    this.m_5496_(this.m_5896_((int)f1), 1.0f, 1.0f);
                    this.m_6469_(this.m_269291_().m_269515_(), f1);
                }
                if (this.m_20096_() && !this.m_9236_().f_46443_) {
                    this.m_20115_(7, false);
                }
            } else {
                BlockPos blockpos = this.m_20099_();
                float f2 = this.m_9236_().m_8055_(this.m_20099_()).getFriction((LevelReader)this.m_9236_(), this.m_20099_(), (Entity)this);
                float f3 = this.m_20096_() ? f2 * 0.91f : 0.98f;
                Vec3 vec35 = this.m_21074_(travelVector, f2);
                double d2 = vec35.f_82480_;
                if (this.m_21023_(MobEffects.f_19620_)) {
                    d2 += (0.05 * (double)(this.m_21124_(MobEffects.f_19620_).m_19564_() + 1) - vec35.f_82480_) * 0.2;
                } else if (this.m_9236_().f_46443_ && !this.m_9236_().m_46805_(blockpos)) {
                    d2 = this.m_20186_() > (double)this.m_9236_().m_141937_() ? -0.1 : 0.0;
                } else if (!this.m_20068_()) {
                    d2 -= d0;
                }
                if (this.m_147223_()) {
                    this.m_20334_(vec35.f_82479_, d2, vec35.f_82481_);
                } else {
                    this.m_20334_(vec35.f_82479_ * (double)f3, d2 * (double)0.98f, vec35.f_82481_ * (double)f3);
                }
            }
        }
        this.m_267651_(this instanceof FlyingAnimal);
    }

    private SoundEvent m_5896_(int height) {
        return height > 4 ? this.m_196493_().f_196627_() : this.m_196493_().f_196626_();
    }

    public boolean m_147223_() {
        return false;
    }

    public void m_7910_(float speed) {
        this.f_20953_ = speed;
        this.m_21564_(speed);
    }

    protected void m_7840_(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
        if (this.m_6162_()) {
            super.m_7840_(y, onGround, state, pos);
        }
    }

    protected void m_8099_() {
    }

    @NotNull
    protected Brain.Provider<EagleEntity> m_5490_() {
        return EagleAi.brainProvider();
    }

    @NotNull
    protected Brain<?> m_8075_(@NotNull Dynamic<?> dynamic) {
        return EagleAi.makeBrain((Brain<EagleEntity>)this.m_5490_().m_22073_(dynamic));
    }

    @NotNull
    public Brain<EagleEntity> m_6274_() {
        return super.m_6274_();
    }

    @org.jetbrains.annotations.Nullable
    public LivingEntity m_5448_() {
        return this.getTargetFromBrain();
    }

    protected final LivingEntity getTargetFromBrain() {
        return this.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
    }

    public boolean m_6779_(@NotNull LivingEntity target) {
        Optional lastEntity;
        Entity entity;
        Optional attackedList = this.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get());
        Optional<UUID> lastUuid = attackedList.map(list -> (UUID)list.get(list.size() - 1));
        if (lastUuid.isPresent() && !this.m_9236_().f_46443_ && (entity = ((ServerLevel)this.m_9236_()).m_8791_(lastUuid.get())) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            v0 = Optional.of(living);
        } else {
            v0 = lastEntity = Optional.empty();
        }
        if (lastEntity.isPresent() && lastEntity.get() == target && super.m_6779_(target) && MiscUtil.isSameEagleAttacking(target, (LivingEntity)this)) {
            return true;
        }
        if (this.m_21824_()) {
            return super.m_6779_(target) && MiscUtil.isNotNeverAttack(target) && MiscUtil.isSameEagleAttacking(target, (LivingEntity)this);
        }
        return super.m_6779_(target) && MiscUtil.isNotNeverAttack(target) && !(target instanceof EagleEntity) && this.m_21188_() != target && (target.m_6095_().m_204039_(Primal_Tags.Entity.EAGLE_HUNTABLE) && !this.m_6274_().m_21874_(MemoryModuleType.f_148201_) || this.m_21188_() == target) && MiscUtil.isSameEagleAttacking(target, (LivingEntity)this);
    }

    public boolean canPickUpEntity(@NotNull Entity target) {
        LivingEntity livingTarget;
        return target.m_20191_().m_82309_() < this.m_20191_().m_82309_() * 1.049 && !this.m_6274_().m_21874_((MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get()) && target instanceof LivingEntity && (livingTarget = (LivingEntity)target).m_21223_() > 0.0f && !(target instanceof FlyingAnimal) && !(target instanceof FlyingMob) && !this.m_6162_();
    }

    public boolean canBabyAttack(@NotNull Entity target) {
        return target.m_20191_().m_82309_() < this.m_20191_().m_82309_() * 1.049 && this.m_6162_();
    }

    public boolean m_214076_(@NotNull ServerLevel level, @NotNull LivingEntity killed) {
        if (killed.m_6095_().m_204039_(Primal_Tags.Entity.EAGLE_HUNTABLE) && !this.m_6162_()) {
            this.m_6274_().m_21882_(MemoryModuleType.f_148201_, (Object)true, 600L);
        }
        return super.m_214076_(level, killed);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        boolean hurt = super.m_6469_(source, amount);
        if (hurt) {
            Entity entity;
            EagleEntity eagle2;
            Player player;
            LivingEntity target;
            Entity entity2;
            if (this.m_20160_() && this.m_21223_() < this.getHealthWhenStartRiding() - 2.0f) {
                this.m_20153_();
                this.m_6274_().m_21882_((MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get(), (Object)true, 60L);
            }
            if (!(!((entity2 = source.m_7639_()) instanceof LivingEntity) || (target = (LivingEntity)entity2) instanceof Player && (player = (Player)target).m_7500_() || target == this.m_269323_() || target instanceof EagleEntity && (eagle2 = (EagleEntity)target).m_269323_() != null && eagle2.m_269323_() == this.m_269323_())) {
                EagleAi.wasHurtBy(this, target);
            }
            if (source.m_7639_() != null && (entity = source.m_7639_()) instanceof LivingEntity) {
                target = (LivingEntity)entity;
                this.m_6274_().m_21882_(MemoryModuleType.f_26383_, (Object)target, (long)this.m_9236_().m_213780_().m_216332_(60, 100));
            }
        }
        return hurt;
    }

    @NotNull
    public Vec3 m_7688_(LivingEntity passenger) {
        return new Vec3(passenger.m_20185_(), passenger.m_20186_() + 0.1, passenger.m_20189_());
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @org.jetbrains.annotations.Nullable
    public LivingEntity m_6688_() {
        return null;
    }

    protected void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (this.m_20363_(passenger)) {
            boolean isAirBelow = this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60795_();
            double y = isAirBelow ? this.m_20186_() - passenger.m_20191_().m_82376_() * 1.0 : this.m_20186_();
            float bodyYawRad = this.f_20883_ * ((float)Math.PI / 180);
            double forwardOffset = isAirBelow ? 0.2 : -passenger.m_20191_().m_82362_() * 0.7;
            double sideOffset = -0.0;
            double x = this.m_20185_() + (double)Mth.m_14031_((float)bodyYawRad) * forwardOffset + (double)Mth.m_14089_((float)bodyYawRad) * sideOffset;
            double z = this.m_20189_() - (double)Mth.m_14089_((float)bodyYawRad) * forwardOffset + (double)Mth.m_14031_((float)bodyYawRad) * sideOffset;
            callback.m_20372_(passenger, x, y, z);
        }
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        boolean wasFeed;
        ItemStack stackInHand = player.m_21120_(hand);
        Item item = stackInHand.m_41720_();
        if (item instanceof DyeItem) {
            DyeColor dyecolor;
            DyeItem dyeitem = (DyeItem)item;
            if (this.m_21830_((LivingEntity)player) && (dyecolor = dyeitem.m_41089_()) != this.getCollarColor()) {
                this.setCollarColor(dyecolor);
                MiscUtil.consumeStack(1, (LivingEntity)player, stackInHand);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (this.m_6898_(stackInHand) && (wasFeed = this.handleEating(player, stackInHand))) {
            MiscUtil.consumeStack(1, (LivingEntity)player, stackInHand);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            return this.changeFollowState(player, hand);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult changeFollowState(Player player, InteractionHand hand) {
        if (player != this.m_269323_()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_ && hand.equals((Object)InteractionHand.MAIN_HAND)) {
            this.setFollowerState(this.isWandering() ? 1 : (this.isFollowing() ? 2 : 0));
            player.m_5661_((Component)Component.m_237110_((String)(this.isFollowing() ? "primal.gui.animal_following" : (this.isSitting() ? "primal.gui.animal_sitting" : "primal.gui.animal_wandering")), (Object[])new Object[]{this.m_7755_()}), true);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    protected boolean handleEating(@NotNull Player player, @NotNull ItemStack stack) {
        if (this.m_6898_(stack)) {
            if (EagleEntity.isMatingFood(stack) && !this.m_9236_().f_46443_ && this.m_146764_() == 0 && this.m_5957_()) {
                this.m_27595_(player);
                return this.playEatingSound();
            }
            if (!this.m_21824_() && EagleEntity.isTameFood(stack) && this.m_6162_() && !this.m_9236_().f_46443_) {
                if (this.f_19796_.m_216332_(0, 5) == 0) {
                    this.m_21828_(player);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                return this.playEatingSound();
            }
            if (this.m_21824_() && !this.m_9236_().f_46443_ && EagleEntity.isHealFood(stack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(2.0f);
                return this.playEatingSound();
            }
            if (this.m_6162_() && !EagleEntity.isTameFood(stack)) {
                int i = this.m_146764_();
                this.m_146740_(EagleEntity.m_216967_((int)(-i)), true);
                return this.playEatingSound();
            }
        }
        return false;
    }

    public void m_7822_(byte id) {
        if (id == 13) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123792_);
        } else if (id == 14) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123748_);
        } else {
            super.m_7822_(id);
        }
    }

    @Override
    public boolean shouldTryTeleportToOwner() {
        LivingEntity livingentity = this.m_269323_();
        return livingentity != null && this.m_20280_((Entity)this.m_269323_()) >= 225.0;
    }

    protected void addParticlesAroundSelf(ParticleOptions particleOption) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(particleOption, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    protected boolean playEatingSound() {
        SoundEvent soundEvent;
        if (!this.m_20067_() && (soundEvent = this.getEatingSound()) != null) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundEvent, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        return true;
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)Primal_Sounds.EAGLE_IDLE.get();
    }

    protected boolean m_142039_() {
        double speed = this.m_20184_().m_82553_();
        return !this.m_20096_() && !this.m_20069_() && speed < 0.3 && (float)this.f_19797_ % 15.0f == 0.0f;
    }

    protected void m_142043_() {
        this.m_5496_((SoundEvent)Primal_Sounds.EAGLE_FLAP.get(), 0.15f, 1.0f);
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)Primal_Sounds.EAGLE_HURT.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)Primal_Sounds.EAGLE_DEATH.get();
    }

    @org.jetbrains.annotations.Nullable
    public SoundEvent getEatingSound() {
        return (SoundEvent)Primal_Sounds.EAGLE_EAT.get();
    }

    @org.jetbrains.annotations.Nullable
    public SoundEvent getShriekSound() {
        if (this.getVariant() == Variant.BALD && this.f_19796_.m_216332_(0, 500) == 0) {
            return (SoundEvent)Primal_Sounds.EAGLE_FREEDOM.get();
        }
        return (SoundEvent)Primal_Sounds.EAGLE_SHRIEK.get();
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int remainingPersistentAngerTime) {
    }

    @org.jetbrains.annotations.Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@org.jetbrains.annotations.Nullable UUID persistentAngerTarget) {
    }

    public void m_6825_() {
    }

    public static enum Variant implements StringRepresentable
    {
        BALD(0, "bald"),
        GOLDEN(1, "golden"),
        HARPY(2, "harpy"),
        PHILIPPINE(3, "philippine");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

