/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.satellite;

import com.holybuckets.foundation.LoggerBase;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import org.slf4j.Logger;

public class LoggerProject
extends LoggerBase {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String PREFIX = "HBs Satellites";
    public static final Boolean DEBUG = true;
    private static final HashMap<String, LoggerBase.LogEntry> FILTER_RULES = new HashMap();

    public static synchronized void logInfo(String logId, String message) {
        LoggerBase.logInfo((String)PREFIX, (String)logId, (String)message);
    }

    public static synchronized void logWarning(String logId, String string) {
        LoggerBase.logWarning((String)PREFIX, (String)logId, (String)string);
    }

    public static synchronized void logError(String logId, String string) {
        LoggerBase.logError((String)PREFIX, (String)logId, (String)string);
    }

    public static synchronized void logDebug(String logId, String string) {
        if (DEBUG_MODE.booleanValue()) {
            LoggerBase.logDebug((String)PREFIX, (String)logId, (String)string);
        }
    }

    public static synchronized void logInit(String logId, String string) {
        LoggerProject.logDebug(logId, "--------" + string.toUpperCase() + " INITIALIZED --------");
    }

    public static void logClientInfo(String message) {
        LoggerBase.logClientInfo((String)message);
    }

    public static void logClientDisplay(String message) {
        String msg = LoggerProject.buildClientDisplayMessage((String)"", (String)message);
    }

    public static float getTime(long t1, long t2) {
        return (t2 - t1) / 1000000L;
    }

    public static void threadExited(String logId, Object threadContainer, Throwable thrown) {
        StringBuilder sb = new StringBuilder();
        sb.append("Thread " + Thread.currentThread().getName() + " exited");
        if (thrown == null) {
            LoggerProject.logDebug(logId, sb + " gracefully");
        } else {
            StackTraceElement[] stackTrace;
            sb.append(" with exception: " + thrown.getMessage());
            for (StackTraceElement ste : stackTrace = thrown.getStackTrace()) {
                sb.append("\n" + ste.toString());
            }
            sb.append("\n\n");
            LoggerProject.logError(logId, sb.toString());
        }
    }
}

