/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.satellite;

import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.satellite.api.ChiselBitsAPI;
import com.holybuckets.satellite.block.be.SatelliteControllerBlockEntity;
import com.holybuckets.satellite.config.SatelliteConfig;
import com.holybuckets.satellite.core.SatelliteManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.minecraft.class_1937;

public class SatelliteMain {
    private static boolean DEV_MODE = false;
    public static SatelliteMain INSTANCE;
    public static ChiselBitsAPI chiselBitsApi;
    public static SatelliteConfig CONFIG;
    private static final Map<class_1937, SatelliteManager> MANAGERS;

    public SatelliteMain() {
        INSTANCE = this;
        chiselBitsApi = (ChiselBitsAPI)Balm.platformProxy().withForge("com.holybuckets.satellite.externalapi.ChiselBitsAPIForge").withFabric("com.holybuckets.satellite.externalapi.ChiselBitsAPIFabric").build();
    }

    static void init(EventRegistrar reg) {
        SatelliteManager.init(reg);
        ChiselBitsAPI.init(reg);
        reg.registerOnBeforeServerStarted(INSTANCE::onServerStarting, EventPriority.Highest);
        reg.registerOnLevelLoad(INSTANCE::onLoadLevel, EventPriority.Normal);
        reg.registerOnServerStopped(INSTANCE::onServerStopped, EventPriority.Lowest);
    }

    public static void loadConfig() {
        CONFIG = (SatelliteConfig)Balm.getConfig().getActiveConfig(SatelliteConfig.class);
    }

    private void onServerStarting(ServerStartingEvent e) {
        DEV_MODE = false;
        SatelliteMain.loadConfig();
        SatelliteManager.onWorldStart();
        SatelliteControllerBlockEntity.PLAYER_RANGE = SatelliteMain.CONFIG.displayConfig.playerRange;
        SatelliteControllerBlockEntity.PATH_REFRESH_TICKS = SatelliteMain.CONFIG.displayConfig.controllerPathRefreshRate;
        SatelliteControllerBlockEntity.UI_REFRESH_TICKS = SatelliteMain.CONFIG.displayConfig.controllerUIRefreshRate;
        SatelliteControllerBlockEntity.ENTITY_REFRESH_TICKS = SatelliteMain.CONFIG.displayConfig.entityRefreshRate;
    }

    private void onLoadLevel(LevelLoadingEvent event) {
        class_1937 level = (class_1937)event.getLevel();
        if (level.method_8608()) {
            return;
        }
        MANAGERS.putIfAbsent(level, new SatelliteManager(level));
    }

    private void onServerStopped(ServerStoppedEvent e) {
        MANAGERS.values().forEach(SatelliteManager::shutdown);
        MANAGERS.clear();
        SatelliteManager.onWorldStop();
    }

    public static SatelliteManager getManager(class_1937 level) {
        if (level.method_8608()) {
            return null;
        }
        return MANAGERS.computeIfAbsent(level, SatelliteManager::new);
    }

    public static Collection<SatelliteManager> getAllManagers() {
        return MANAGERS.values();
    }

    static {
        MANAGERS = new HashMap<class_1937, SatelliteManager>();
    }
}

