/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.satellite.block.be;

import com.holybuckets.foundation.HBUtil;
import com.holybuckets.satellite.CommonProxy;
import com.holybuckets.satellite.SatelliteMain;
import com.holybuckets.satellite.block.be.ModBlockEntities;
import com.holybuckets.satellite.block.be.isatelliteblocks.ISatelliteBE;
import com.holybuckets.satellite.core.SatelliteManager;
import net.blay09.mods.balm.api.Balm;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3965;
import net.minecraft.class_5558;

public class SatelliteBlockEntity
extends class_2586
implements ISatelliteBE,
class_5558<SatelliteBlockEntity> {
    int colorId = -1;
    SatelliteManager manager;
    class_2818 currentChunk;
    class_2338 targetPos;
    class_2338 travelPos;
    boolean traveling;
    private int ticks;
    private static final int HEXCODE_MAX = 0xFFFFFF;
    private static int TICKS_PER_MINUTE = 20;

    public SatelliteBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.satelliteBlockEntity.get(), pos, state);
        this.targetPos = pos;
        this.traveling = false;
    }

    public void use(class_1657 p, class_1268 hand, class_3965 res) {
        if (!hand.equals((Object)class_1268.field_5808)) {
            return;
        }
        boolean isClientSide = this.field_11863.field_9236;
        boolean isTopFaceUsed = res.method_17780().equals((Object)class_2350.field_11036);
        if (isClientSide && isTopFaceUsed) {
            ((CommonProxy)Balm.sidedProxy((String)"com.holybuckets.satellite.CommonClass", (String)"com.holybuckets.satellite.client.CommonClassClient").get()).openScreen(this);
        }
        if (isTopFaceUsed) {
            return;
        }
        int cmd = 16;
        if (cmd == 16) {
            int color = (this.colorId + 1) % SatelliteManager.totalIds();
            class_1792 class_17922 = p.method_5998(hand).method_7909();
            if (class_17922 instanceof class_1747) {
                class_1747 bi = (class_1747)class_17922;
                class_2248 b = bi.method_7711();
                color = SatelliteManager.getColorId(b);
            }
            this.setColorId(color);
        }
    }

    @Override
    public int getColorId() {
        return this.colorId;
    }

    @Override
    public void setColorId(int colorId) {
        if (colorId < 0 || colorId >= SatelliteManager.totalIds()) {
            return;
        }
        this.manager.remove(this.colorId, this);
        this.colorId = colorId;
        this.markUpdated();
    }

    public void setLevelChunk(class_2818 chunk) {
        this.currentChunk = chunk;
    }

    public void setTargetPos(class_2338 blockPos) {
        int y = Math.max(blockPos.method_10264(), SatelliteMain.CONFIG.satelliteConfig.minSatelliteWorkingHeight);
        this.targetPos = blockPos.method_33096(y);
    }

    public void launch(class_2338 pos) {
        if (pos != null) {
            this.setTargetPos(pos);
        }
        this.traveling = true;
        this.ticks = TICKS_PER_MINUTE - 1;
    }

    public class_2338 getTargetPos() {
        return this.targetPos;
    }

    public boolean isTraveling() {
        return this.traveling;
    }

    public void onDestroyed() {
        this.manager.remove(this.colorId, this);
    }

    public class_2591<?> method_11017() {
        return (class_2591)ModBlockEntities.satelliteBlockEntity.get();
    }

    public void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, SatelliteBlockEntity satelliteBlockEntity) {
        ++this.ticks;
        if (this.manager == null) {
            this.manager = SatelliteManager.get(level);
        }
        if (this.field_11863.field_9236) {
            return;
        }
        this.manager.put(this.colorId, this);
        if (this.traveling) {
            this.travel();
        }
    }

    private void travel() {
        class_1923 targetChunk;
        if (this.ticks % TICKS_PER_MINUTE != 0) {
            return;
        }
        if (this.method_11016().equals((Object)this.targetPos) || this.field_11863 == null) {
            this.traveling = false;
            return;
        }
        class_2338 currentPos = this.travelPos != null ? this.travelPos : this.method_11016();
        class_1923 currentChunk = new class_1923(currentPos);
        if (currentChunk.equals((Object)(targetChunk = new class_1923(this.targetPos)))) {
            if (this.manager.moveSatellite(this, this.targetPos)) {
                this.traveling = false;
                this.travelPos = null;
            }
            return;
        }
        int chunksToMove = SatelliteMain.CONFIG.satelliteConfig.satelliteTravelRateChunksPerSecond * 60;
        int dx = targetChunk.field_9181 - currentChunk.field_9181;
        int dz = targetChunk.field_9180 - currentChunk.field_9180;
        int moveX = 0;
        int moveZ = 0;
        if (targetChunk.field_9181 > currentChunk.field_9181) {
            moveX = Math.min(chunksToMove, dx);
        } else if (targetChunk.field_9181 < currentChunk.field_9181) {
            moveX = -Math.min(chunksToMove, -dx);
        }
        if (targetChunk.field_9180 > currentChunk.field_9180) {
            moveZ = Math.min(chunksToMove, dz);
        } else if (targetChunk.field_9180 < currentChunk.field_9180) {
            moveZ = -Math.min(chunksToMove, -dz);
        }
        class_2338 newPos = currentPos.method_10069(moveX * 16, 0, moveZ * 16);
        if (moveX < chunksToMove && moveZ < chunksToMove) {
            int yPos = SatelliteMain.CONFIG.satelliteConfig.minSatelliteWorkingHeight;
            newPos = targetChunk.method_8323().method_33096(yPos);
        }
        this.travelPos = newPos;
    }

    protected void method_11007(class_2487 tag) {
        String pos;
        super.method_11007(tag);
        tag.method_10569("colorId", this.colorId);
        tag.method_10556("traveling", this.traveling);
        if (this.traveling && this.travelPos != null) {
            pos = HBUtil.BlockUtil.positionToString((class_2382)this.travelPos);
            tag.method_10582("travelPos", pos);
        }
        if (this.traveling && this.targetPos != null) {
            pos = HBUtil.BlockUtil.positionToString((class_2382)this.targetPos);
            tag.method_10582("targetPos", pos);
        }
    }

    public void method_11014(class_2487 tag) {
        String pos;
        super.method_11014(tag);
        this.colorId = tag.method_10550("colorId");
        this.traveling = tag.method_10577("traveling");
        if (tag.method_10545("travelPos")) {
            pos = tag.method_10558("travelPos");
            this.travelPos = new class_2338((class_2382)HBUtil.BlockUtil.stringToBlockPos((String)pos));
        }
        if (tag.method_10545("targetPos")) {
            pos = tag.method_10558("targetPos");
            this.targetPos = new class_2338((class_2382)HBUtil.BlockUtil.stringToBlockPos((String)pos));
        }
        if (this.method_11016().equals((Object)this.targetPos) || this.travelPos == null || this.travelPos.equals((Object)this.targetPos)) {
            this.traveling = false;
            this.targetPos = this.method_11016();
            this.travelPos = null;
        }
    }

    private void markUpdated() {
        this.method_5431();
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        this.method_11007(tag);
        return tag;
    }
}

