/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.satellite.block.be;

import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.console.Messager;
import com.holybuckets.satellite.block.SatelliteControllerBlock;
import com.holybuckets.satellite.block.be.ModBlockEntities;
import com.holybuckets.satellite.block.be.SatelliteBlockEntity;
import com.holybuckets.satellite.block.be.SatelliteDisplayBlockEntity;
import com.holybuckets.satellite.block.be.isatelliteblocks.ISatelliteControllerBE;
import com.holybuckets.satellite.block.be.isatelliteblocks.ISatelliteDisplayBE;
import com.holybuckets.satellite.client.core.SatelliteDisplayClient;
import com.holybuckets.satellite.core.SatelliteDisplay;
import com.holybuckets.satellite.core.SatelliteManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public class SatelliteControllerBlockEntity
extends SatelliteDisplayBlockEntity
implements ISatelliteControllerBE {
    int colorId;
    SatelliteManager manager;
    class_2338 uiTargetBlockPos;
    class_2338 satelliteTargetPos;
    SatelliteBlockEntity linkedSatellite;
    boolean forceDisplayUpdates;
    final Commands commands;
    public static int PLAYER_RANGE = 64;
    public static int UI_REFRESH_TICKS = 10;
    private static final int START_BUFFER = 40;
    public static int PATH_REFRESH_TICKS = 200;
    public static int ENTITY_REFRESH_TICKS = 10;
    private static int PLAYER_UI_REFRESH_TICKS = 4;
    public static double REACH_DIST_BLOCKS = 1.749000072479248;

    public SatelliteControllerBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591<? extends class_2586>)((class_2591)ModBlockEntities.satelliteControllerBlockEntity.get()), pos, state);
        this.setColorId(0);
        this.uiTargetBlockPos = class_2338.field_10980;
        this.forceDisplayUpdates = false;
        this.linkedSatellite = null;
        this.satelliteTargetPos = null;
        this.commands = new Commands();
    }

    @Override
    public class_2338 getUiPosition() {
        return this.uiTargetBlockPos;
    }

    public void setUiPosition(class_2338 blockTarget) {
        this.uiTargetBlockPos = blockTarget;
        this.markUpdated();
        if (this.field_11863 == null || blockTarget == null) {
            return;
        }
        List players = HBUtil.PlayerUtil.getAllPlayersInBlockRange((class_2338)this.method_11016(), (int)PLAYER_RANGE);
        for (class_3222 player : players) {
            Messager.getInstance().sendChat((class_1657)player, "Targeted: " + HBUtil.BlockUtil.positionToString((class_2382)blockTarget));
        }
    }

    @Override
    public int getColorId() {
        return this.colorId;
    }

    @Override
    public void setColorId(int colorId) {
        this.colorId = colorId;
        this.markUpdated();
    }

    @Override
    public void setSource(SatelliteDisplay source, boolean forceDisplayUpdates) {
        this.source = source;
        class_2338 class_23382 = this.satelliteTargetPos = this.linkedSatellite != null ? this.linkedSatellite.method_11016() : null;
        if (forceDisplayUpdates) {
            this.forceUpdate();
        }
        if (source == null || source.noSource()) {
            return;
        }
        this.toggleOnOff(true);
        this.displayInfo = source.initDisplayInfo(this);
    }

    @Override
    public void onDestroyed() {
        this.turnOff();
    }

    private void turnOff() {
        this.clearDisplay();
        if (this.source != null) {
            this.source.clear();
            this.source.resetChunkSection();
            this.source.resetOrdinal();
        }
        this.forceUpdate();
    }

    public void use(class_1657 p, class_1268 hand, class_3965 res) {
        int cmd = ISatelliteControllerBE.calculateHitCommand(res);
        if (cmd == -1) {
            return;
        }
        this.commands.hasUpdate = true;
        if (cmd == 0) {
            this.toggleOnOff(!this.isDisplayOn);
        }
        if (cmd == 16) {
            class_1792 class_17922 = p.method_5998(hand).method_7909();
            if (class_17922 instanceof class_1747) {
                class_1747 bi = (class_1747)class_17922;
                class_2248 b = bi.method_7711();
                this.commands.dIdSet = SatelliteManager.getColorId(b);
            }
            if (this.commands.dIdSet < 0) {
                ++this.commands.dIdAdj;
            }
        } else if (cmd >= 17) {
            this.commands.dIdSet = cmd - 17;
        }
        if (!this.isDisplayOn || this.source == null) {
            return;
        }
        if (cmd != 0) {
            if (cmd < 5) {
                int dNS = 0;
                int dEW = 0;
                switch (cmd) {
                    case 1: {
                        dNS = 1;
                        break;
                    }
                    case 2: {
                        dNS = -1;
                        break;
                    }
                    case 3: {
                        dEW = 1;
                        break;
                    }
                    case 4: {
                        dEW = -1;
                        break;
                    }
                    default: {
                        dNS = 0;
                        dEW = 0;
                    }
                }
                this.commands.dNS += dNS;
                this.commands.dEW += dEW;
            } else if (cmd < 7) {
                this.commands.dSection = this.commands.dSection + (cmd == 5 ? 1 : -1);
            } else if (cmd < 9) {
                this.commands.dDepth = this.commands.dDepth + (cmd == 7 ? 1 : -1);
            }
        }
    }

    @Override
    public void forceUpdate() {
        this.ticks = PATH_REFRESH_TICKS - 1;
        this.forceDisplayUpdates = true;
    }

    @Override
    public void toggleOnOff(boolean toggle) {
        if (this.isDisplayOn == toggle) {
            return;
        }
        this.isDisplayOn = toggle;
        if (this.isDisplayOn) {
            if (this.source != null) {
                this.source.resetChunkSection();
            }
        } else {
            this.turnOff();
        }
        this.markUpdated();
        this.updateBlockState();
    }

    public class_2591<?> method_11017() {
        return (class_2591)ModBlockEntities.satelliteControllerBlockEntity.get();
    }

    private void processCommands() {
        if (this.ticks % UI_REFRESH_TICKS != 0) {
            return;
        }
        if (!this.commands.hasUpdate) {
            return;
        }
        if (this.commands.dIdSet > -1) {
            this.setColorId(this.commands.dIdSet);
            this.commands.dIdSet = -1;
        } else if (this.commands.dIdAdj != 0) {
            int newId = (this.getColorId() + this.commands.dIdAdj) % SatelliteManager.totalIds();
            this.setColorId(newId);
            this.commands.dIdAdj = 0;
        }
        if (!this.isDisplayOn || this.source == null || this.source.noSource()) {
            this.commands.reset();
            return;
        }
        this.source.adjCurrentSection(this.commands.dSection);
        this.commands.dSection = 0;
        this.source.adjOrdinal(this.commands.dNS, this.commands.dEW);
        this.commands.dNS = 0;
        this.commands.dEW = 0;
        this.source.adjDisplayDepth(this.commands.dDepth);
        this.commands.dDepth = 0;
        this.commands.hasUpdate = false;
        this.forceUpdate();
    }

    @Override
    public void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, SatelliteDisplayBlockEntity satelliteBlockEntity) {
        ++this.ticks;
        if (this.manager == null) {
            this.manager = SatelliteManager.get(level);
        }
        if (this.field_11863.field_9236) {
            if (this.isDisplayOn) {
                if (this.source == null) {
                    this.source = new SatelliteDisplayClient(level, this);
                }
                if (this.ticks % PATH_REFRESH_TICKS == 0) {
                    this.propagateToNeighbors();
                }
            } else {
                if (this.source != null) {
                    this.source.clear();
                }
                this.source = null;
            }
            return;
        }
        if (this.ticks < 40) {
            return;
        }
        if (this.ticks == 40) {
            this.propagateToNeighbors();
            this.turnOff();
        }
        if (this.linkedSatellite == null && this.satelliteTargetPos != null) {
            this.recoverSatellite();
        }
        if (this.linkedSatellite != this.manager.get(this.colorId)) {
            this.linkedSatellite = this.manager.get(this.colorId);
            if (this.linkedSatellite == null) {
                this.toggleOnOff(false);
                this.setSource(this.source, true);
                this.propagateToNeighbors();
                return;
            }
            this.toggleOnOff(true);
            SatelliteDisplay source = this.manager.generateSource(this.linkedSatellite, this);
            this.setSource(source, true);
        }
        this.processCommands();
        this.renderDisplay();
        if (this.source != null && this.isDisplayOn) {
            this.source.resetRateLimiter();
        }
    }

    @Override
    protected void renderDisplay() {
        if (this.isDisplayOn && this.ticks % PATH_REFRESH_TICKS == 0) {
            boolean playersInRange;
            boolean bl = playersInRange = HBUtil.PlayerUtil.getAllPlayersInBlockRange((class_2338)this.method_11016(), (int)PLAYER_RANGE).size() > 0;
            if (!playersInRange) {
                this.turnOff();
                return;
            }
            this.propagateToNeighbors();
            if (this.forceDisplayUpdates) {
                if (this.source != null) {
                    this.source.resetDisplayUpdates();
                }
                this.forceDisplayUpdates = false;
            } else if (this.source != null) {
                this.source.setNeedsUpdate(false);
            }
        }
        super.renderDisplay();
        if (this.source != null && this.ticks % ENTITY_REFRESH_TICKS == 0) {
            this.source.renderEntities(this.method_11016());
        }
        this.renderPlayerUI();
    }

    private void renderPlayerUI() {
        if (!this.isDisplayOn || this.source == null || this.source.noSource()) {
            return;
        }
        if (this.ticks % PLAYER_UI_REFRESH_TICKS != 0) {
            return;
        }
        this.source.renderUI();
    }

    private void recoverSatellite() {
        if (this.satelliteTargetPos == null) {
            return;
        }
        class_2818 distantChunk = SatelliteManager.getChunk(this.field_11863, this.satelliteTargetPos);
        if (distantChunk != null) {
            class_2586 be = distantChunk.method_8321(this.satelliteTargetPos);
            if (be instanceof SatelliteBlockEntity) {
                this.manager.put(this.colorId, (SatelliteBlockEntity)be);
            } else {
                this.satelliteTargetPos = null;
            }
        }
    }

    public void propagateToNeighbors() {
        if (this.field_11863 == null) {
            return;
        }
        HashSet<class_2338> visited = new HashSet<class_2338>();
        HashMap<class_2338, ISatelliteDisplayBE> nodes = new HashMap<class_2338, ISatelliteDisplayBE>();
        LinkedList<class_2338> toCheck = new LinkedList<class_2338>();
        toCheck.offer(this.method_11016());
        visited.add(this.method_11016());
        while (!toCheck.isEmpty()) {
            class_2338 current = (class_2338)toCheck.poll();
            ISatelliteDisplayBE temp = (ISatelliteDisplayBE)this.field_11863.method_8321(current);
            if (!this.field_11863.field_9236) {
                temp.setSource(this.source, this.forceDisplayUpdates);
            }
            nodes.put(current, temp);
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 neighbor = current.method_10093(direction);
                if (visited.contains(neighbor)) continue;
                visited.add(neighbor);
                class_2586 be = this.field_11863.method_8321(neighbor);
                if (!(be instanceof ISatelliteDisplayBE)) continue;
                ISatelliteDisplayBE displayBE = (ISatelliteDisplayBE)be;
                toCheck.offer(neighbor);
            }
        }
        if (this.source == null) {
            return;
        }
        this.source.clear();
        this.source.addAll(nodes);
        this.source.collectEntities();
    }

    @Override
    protected void method_11007(class_2487 tag) {
        String pos;
        super.method_11007(tag);
        tag.method_10569("colorId", this.colorId);
        tag.method_10556("isDisplayOn", this.isDisplayOn);
        if (this.uiTargetBlockPos != null) {
            pos = HBUtil.BlockUtil.positionToString((class_2382)this.uiTargetBlockPos);
            tag.method_10582("uiTargetBlockPos", pos);
        }
        if (this.satelliteTargetPos != null) {
            pos = HBUtil.BlockUtil.positionToString((class_2382)this.satelliteTargetPos);
            tag.method_10582("satelliteTargetPos", pos);
        }
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.colorId = tag.method_10550("colorId");
        this.isDisplayOn = tag.method_10577("isDisplayOn");
        if (tag.method_10545("uiTargetBlockPos")) {
            String targetPosStr = tag.method_10558("uiTargetBlockPos");
            this.uiTargetBlockPos = new class_2338((class_2382)HBUtil.BlockUtil.stringToBlockPos((String)targetPosStr));
        }
        if (tag.method_10545("satelliteTargetPos")) {
            String pos = tag.method_10558("satelliteTargetPos");
            this.satelliteTargetPos = new class_2338((class_2382)HBUtil.BlockUtil.stringToBlockPos((String)pos));
        }
    }

    private void markUpdated() {
        this.method_5431();
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        this.method_11007(tag);
        return tag;
    }

    private void updateBlockState() {
        if (this.field_11863 == null) {
            return;
        }
        class_2680 state = this.method_11010();
        class_2680 newState = (class_2680)state.method_11657((class_2769)SatelliteControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.isDisplayOn));
        this.field_11863.method_8652(this.method_11016(), newState, 3);
    }

    private static class Commands {
        boolean hasUpdate = false;
        int dSection = 0;
        int dNS = 0;
        int dEW = 0;
        int dDepth = 0;
        int dIdAdj = 0;
        int dIdSet = -1;
        class_3965 playerSelection = null;

        Commands() {
        }

        public void reset() {
            this.dSection = 0;
            this.dNS = 0;
            this.dEW = 0;
            this.dDepth = 0;
            this.dIdAdj = 0;
            this.dIdSet = -1;
            this.playerSelection = null;
            this.hasUpdate = false;
        }
    }
}

