/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.satellite.block.be;

import com.holybuckets.satellite.SatelliteMain;
import com.holybuckets.satellite.block.SatelliteDisplayBlock;
import com.holybuckets.satellite.block.be.ModBlockEntities;
import com.holybuckets.satellite.block.be.isatelliteblocks.ISatelliteDisplayBE;
import com.holybuckets.satellite.core.ChunkDisplayInfo;
import com.holybuckets.satellite.core.SatelliteDisplay;
import java.util.Deque;
import java.util.Random;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5558;

public class SatelliteDisplayBlockEntity
extends class_2586
implements ISatelliteDisplayBE,
class_5558<SatelliteDisplayBlockEntity> {
    protected SatelliteDisplay source;
    protected Deque<ChunkDisplayInfo> displayInfo;
    protected boolean isDisplayOn = false;
    protected int ticks = new Random(this.hashCode()).nextInt(REFRESH_RATE);
    private int height = 0;
    private int holoLift = 0;
    private boolean hasPlayer = false;
    public static int REFRESH_RATE = 60;
    public static int PLAYER_REFRESH_RATE = 10;

    public SatelliteDisplayBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591<? extends class_2586>)((class_2591)ModBlockEntities.satelliteDisplayBlockEntity.get()), pos, state);
    }

    public SatelliteDisplayBlockEntity(class_2591<? extends class_2586> beType, class_2338 pos, class_2680 state) {
        super(beType, pos, state);
    }

    public void setHeight(int height) {
        if (height != this.height) {
            this.height = height;
            if (height > 0) {
                this.clearAboveArea(height);
            }
        }
    }

    private void clearAboveArea(int height) {
        class_2338 pos = this.method_11016().method_10086(this.holoLift);
        for (int y = 1; y <= height; ++y) {
            class_2338 clearPos = pos.method_10086(y);
            SatelliteMain.chiselBitsApi.clear(this.field_11863, clearPos);
        }
    }

    @Override
    public void forceUpdate() {
        class_2338 offset = this.source.getOffset(this.method_11016());
        this.ticks = -(Math.abs(offset.method_10263()) + Math.abs(offset.method_10260()));
    }

    @Override
    public void toggleOnOff(boolean toggle) {
        if (toggle != this.isDisplayOn) {
            this.isDisplayOn = toggle;
            this.updateBlockState();
            if (!this.isDisplayOn) {
                this.clearDisplay();
            }
        }
    }

    private void updateBlockState() {
        if (this.field_11863 == null) {
            return;
        }
        class_2680 state = this.method_11010();
        class_2680 newState = (class_2680)state.method_11657((class_2769)SatelliteDisplayBlock.POWERED, (Comparable)Boolean.valueOf(this.isDisplayOn));
        this.field_11863.method_8652(this.method_11016(), newState, 3);
        this.method_5431();
        this.field_11863.method_8413(this.method_11016(), state, newState, 3);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isDisplayOn() {
        return this.isDisplayOn;
    }

    @Override
    public boolean hasPlayer() {
        return this.hasPlayer;
    }

    @Override
    public SatelliteDisplay getSource() {
        return this.source;
    }

    @Override
    public void setSource(SatelliteDisplay source, boolean forceUpdate) {
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.source == source && !forceUpdate) {
            return;
        }
        this.source = source;
        if (this.source == null || source.noSource()) {
            this.toggleOnOff(false);
            return;
        }
        this.toggleOnOff(true);
        this.displayInfo = source.initDisplayInfo(this);
        this.forceUpdate();
    }

    public void buildDisplay() {
        class_2338 pos = this.method_11016().method_10086(this.holoLift);
        for (ChunkDisplayInfo info : this.displayInfo) {
            pos = pos.method_10084();
            boolean proceedWithUpdates = false;
            for (boolean b : info.hasUpdates) {
                if (!b) continue;
                proceedWithUpdates = true;
                break;
            }
            if (!proceedWithUpdates) continue;
            class_2680 before = this.field_11863.method_8320(pos);
            class_2586 be = SatelliteMain.chiselBitsApi.build(this.field_11863, info.holoBits, pos, info.hasUpdates);
            if (be == null) continue;
            this.field_11863.method_8413(pos, before, be.method_11010(), 11);
        }
    }

    public void clearDisplay() {
        if (this.displayInfo == null) {
            this.clearAboveArea(this.height);
            this.height = 0;
            return;
        }
        this.displayInfo.forEach(info -> {
            info.isActive = false;
        });
        this.clearAboveArea(this.displayInfo.size());
        this.displayInfo.clear();
    }

    public void onDestroyed() {
        this.clearDisplay();
    }

    public void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, SatelliteDisplayBlockEntity satelliteDisplayBlockEntity) {
        ++this.ticks;
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.source == null) {
            return;
        }
        if (this.source == null || this.source.noSource() || !this.source.contains(this.method_11016())) {
            this.toggleOnOff(false);
        } else if (this.displayInfo != null && !this.displayInfo.isEmpty()) {
            this.renderDisplay();
        }
    }

    protected void renderDisplay() {
        boolean playerRefresh;
        if (this.source == null || this.source.noSource()) {
            return;
        }
        if (this.source.needsClear()) {
            this.clearAboveArea(this.height);
            this.height = this.source.getDepth();
        }
        if (this.displayInfo == null || this.displayInfo.isEmpty()) {
            return;
        }
        boolean stdRefresh = this.ticks % REFRESH_RATE == 0;
        boolean bl = playerRefresh = this.hasPlayer && this.ticks % PLAYER_REFRESH_RATE == 0;
        if (playerRefresh && stdRefresh) {
            this.displayInfo.forEach(info -> info.refreshBits(true));
            this.clearAboveArea(this.height);
        } else if (playerRefresh) {
            this.displayInfo.forEach(info -> info.refreshBits(true));
        } else if (stdRefresh) {
            this.displayInfo.forEach(info -> info.refreshBits(false));
        } else {
            return;
        }
        this.buildDisplay();
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("height", this.height);
        tag.method_10569("holoLift", this.holoLift);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.height = tag.method_10550("height");
        this.holoLift = tag.method_10550("holoLift");
    }

    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        this.method_11007(tag);
        return tag;
    }
}

