/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.satellite.client;

import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.client.ClientEventRegistrar;
import com.holybuckets.satellite.CommonClass;
import com.holybuckets.satellite.CommonProxy;
import com.holybuckets.satellite.SatelliteMain;
import com.holybuckets.satellite.block.be.ModBlockEntities;
import com.holybuckets.satellite.block.be.SatelliteBlockEntity;
import com.holybuckets.satellite.block.be.SatelliteControllerBlockEntity;
import com.holybuckets.satellite.client.ModRenderers;
import com.holybuckets.satellite.client.core.SatelliteDisplayClient;
import com.holybuckets.satellite.client.screen.ModScreens;
import com.holybuckets.satellite.client.screen.SatelliteScreen;
import com.holybuckets.satellite.config.ModConfig;
import com.holybuckets.satellite.core.SatelliteManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.client.ConnectedToServerEvent;
import net.blay09.mods.balm.api.event.client.DisconnectedFromServerEvent;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class CommonClassClient
implements CommonProxy {
    private static final float[] LINE_COLOR = new float[]{1.0f, 0.7f, 0.0f, 1.0f};
    private static final float[] LINE_COLOR_WHITE = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] LINE_COLOR_RED = new float[]{1.0f, 0.0f, 0.0f, 1.0f};

    public static void initClient() {
        ClientEventRegistrar registrar = ClientEventRegistrar.getInstance();
        registrar.registerOnConnectedToServer(CommonClassClient::onConnectedToServer, EventPriority.Highest);
        registrar.registerOnDisconnectedFromServer(CommonClassClient::onDisconnectedFromServer, EventPriority.Lowest);
        SatelliteDisplayClient.init(registrar);
        ModRenderers.clientInitialize(BalmClient.getRenderers());
        ModScreens.clientInitialize(BalmClient.getScreens());
    }

    @Override
    public void openScreen(class_2586 be) {
        if (be.method_11017().equals(ModBlockEntities.satelliteBlockEntity.get())) {
            class_310.method_1551().method_1507((class_437)new SatelliteScreen((SatelliteBlockEntity)be));
        }
    }

    public static void sample() {
    }

    private static void onConnectedToServer(ConnectedToServerEvent event) {
        SatelliteMain.loadConfig();
        SatelliteManager.onWorldStart();
        ModConfig.onConnectedToServer(HBUtil.LevelUtil.toLevel((HBUtil.LevelUtil.LevelNameSpace)HBUtil.LevelUtil.LevelNameSpace.CLIENT, (class_2960)GeneralConfig.OVERWORLD_LOC));
    }

    private static void onDisconnectedFromServer(DisconnectedFromServerEvent event) {
        SatelliteManager.onWorldStop();
    }

    public static class_1058 getSprite(class_2960 rl) {
        class_1059 textureAtlas = class_310.method_1551().method_1554().method_24153(class_1723.field_21668);
        return textureAtlas.method_4608(rl);
    }

    public static void renderUiSphere(class_4184 camera, class_4587 poseStack) {
        class_1297 class_12972 = camera.method_19331();
        if (!(class_12972 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_12972;
        class_1937 level = camera.method_19331().method_37908();
        class_3965 hitResult = CommonClass.getAnyHitResult(level, player, SatelliteControllerBlockEntity.REACH_DIST_BLOCKS * 2.0);
        if (hitResult == null) {
            return;
        }
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        class_4588 builder = bufferSource.getBuffer(class_1921.method_23594());
        class_243 cameraPos = camera.method_19326();
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.lineWidth((float)2.0f);
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        double bitSize = 0.0625;
        int radius = 2;
        class_243 hitLocation = hitResult.method_17784();
        double snappedX = Math.floor(hitLocation.field_1352 / bitSize) * bitSize;
        double snappedY = Math.floor(hitLocation.field_1351 / bitSize) * bitSize;
        double snappedZ = Math.floor(hitLocation.field_1350 / bitSize) * bitSize;
        class_243 center = new class_243(snappedX, snappedY, snappedZ);
        LineBuilder BUILDER = new LineBuilder(builder, poseStack);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + y * y + z * z > radius * radius) continue;
                    double bitX = center.field_1352 + (double)x * bitSize;
                    double bitY = center.field_1351 + (double)y * bitSize;
                    double bitZ = center.field_1350 + (double)z * bitSize;
                    if (!CommonClass.isViewingHoloBit(level, hitResult, new class_243((double)x * bitSize, (double)y * bitSize, (double)z * bitSize))) continue;
                    if ((double)x == 0.0 && (double)y == 0.0 && (double)z == 0.0) {
                        BUILDER.setColor(LINE_COLOR_RED);
                    } else {
                        BUILDER.setColor(LINE_COLOR);
                    }
                    BUILDER.drawCube(bitX, bitY, bitZ, bitSize);
                }
            }
        }
        poseStack.method_22909();
        bufferSource.method_22994(class_1921.method_23594());
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)1.0f);
    }

    private static class LineBuilder {
        private final class_4588 builder;
        private final Matrix4f matrix;
        private final Matrix3f normal;
        private float[] color;

        public LineBuilder(class_4588 builder, class_4587 poseStack) {
            this.builder = builder;
            this.matrix = poseStack.method_23760().method_23761();
            this.normal = poseStack.method_23760().method_23762();
        }

        void setColor(float[] color) {
            this.color = color;
        }

        public void addLine(double x1, double y1, double z1, double x2, double y2, double z2) {
            this.builder.method_22918(this.matrix, (float)x1, (float)y1, (float)z1).method_22915(this.color[0], this.color[1], this.color[2], this.color[3]).method_23763(this.normal, 1.0f, 0.0f, 0.0f).method_1344();
            this.builder.method_22918(this.matrix, (float)x2, (float)y2, (float)z2).method_22915(this.color[0], this.color[1], this.color[2], this.color[3]).method_23763(this.normal, 1.0f, 0.0f, 0.0f).method_1344();
        }

        public void drawCube(double minX, double minY, double minZ, double size) {
            double maxX = minX + size;
            double maxY = minY + size;
            double maxZ = minZ + size;
            this.addLine(minX, minY, minZ, maxX, minY, minZ);
            this.addLine(maxX, minY, minZ, maxX, minY, maxZ);
            this.addLine(maxX, minY, maxZ, minX, minY, maxZ);
            this.addLine(minX, minY, maxZ, minX, minY, minZ);
            this.addLine(minX, maxY, minZ, maxX, maxY, minZ);
            this.addLine(maxX, maxY, minZ, maxX, maxY, maxZ);
            this.addLine(maxX, maxY, maxZ, minX, maxY, maxZ);
            this.addLine(minX, maxY, maxZ, minX, maxY, minZ);
            this.addLine(minX, minY, minZ, minX, maxY, minZ);
            this.addLine(maxX, minY, minZ, maxX, maxY, minZ);
            this.addLine(maxX, minY, maxZ, maxX, maxY, maxZ);
            this.addLine(minX, minY, maxZ, minX, maxY, maxZ);
        }
    }
}

