/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.satellite.client.core;

import com.holybuckets.foundation.client.ClientEventRegistrar;
import com.holybuckets.satellite.SatelliteMain;
import com.holybuckets.satellite.block.be.SatelliteControllerBlockEntity;
import com.holybuckets.satellite.block.be.isatelliteblocks.ISatelliteDisplayBE;
import com.holybuckets.satellite.core.SatelliteDisplay;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.blay09.mods.balm.api.event.client.BlockHighlightDrawEvent;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3965;
import net.minecraft.class_4184;

public class SatelliteDisplayClient
extends SatelliteDisplay {
    private static LinkedHashSet<SatelliteDisplayClient> DISPLAYS = new LinkedHashSet();
    private final LinkedHashSet<class_2338> holoBlocks;

    public SatelliteDisplayClient(class_1937 level, SatelliteControllerBlockEntity controller) {
        super(level, controller);
        this.controller = controller;
        this.displayBlocks = new HashMap();
        this.holoBlocks = new LinkedHashSet();
        DISPLAYS.add(this);
    }

    @Override
    public void add(class_2338 blockPos, ISatelliteDisplayBE displayBlock) {
        this.displayBlocks.put(blockPos, displayBlock);
        this.updateBounds(blockPos);
    }

    private void updateBounds(class_2338 pos) {
        this.minX = Math.min(this.minX, pos.method_10263());
        this.maxX = Math.max(this.maxX, pos.method_10263());
        this.minZ = Math.min(this.minZ, pos.method_10260());
        this.maxZ = Math.max(this.maxZ, pos.method_10260());
    }

    private void recalculateBounds() {
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.minZ = Integer.MAX_VALUE;
        this.maxZ = Integer.MIN_VALUE;
        for (class_2338 pos : this.displayBlocks.keySet()) {
            this.updateBounds(pos);
        }
    }

    @Override
    public boolean isHitWithinDisplay(class_243 hit) {
        double epsilon = 0.001;
        double adjustedMinX = (double)this.minX - epsilon;
        double adjustedMaxX = (double)this.maxX + 1.0 + epsilon;
        double adjustedMinZ = (double)this.minZ - epsilon;
        double adjustedMaxZ = (double)this.maxZ + 1.0 + epsilon;
        double adjustedMinY = (double)this.controller.method_11016().method_10264() + 1.0 - epsilon;
        double adjustedMaxY = (double)this.controller.method_11016().method_10264() + 4.0 + epsilon;
        return !(hit.field_1352 < adjustedMinX || hit.field_1352 > adjustedMaxX || hit.field_1350 < adjustedMinZ || hit.field_1350 > adjustedMaxZ || hit.field_1351 < adjustedMinY || hit.field_1351 > adjustedMaxY);
    }

    @Override
    public void addAll(Map<class_2338, ISatelliteDisplayBE> blocks) {
        super.addAll(blocks);
        for (class_2338 pos : blocks.keySet()) {
            for (int i = 1; i <= this.controller.getHeight(); ++i) {
                this.holoBlocks.add(pos.method_10086(i));
            }
        }
        DISPLAYS.add(this);
    }

    @Override
    public void clear() {
        this.displayBlocks.clear();
        this.holoBlocks.clear();
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.minZ = Integer.MAX_VALUE;
        this.maxZ = Integer.MIN_VALUE;
        DISPLAYS.remove(this);
    }

    public static void init(ClientEventRegistrar reg) {
        reg.registerOnBlockHighlightDraw(SatelliteDisplayClient::onBlockHighlightDraw);
    }

    private static void onBlockHighlightDraw(BlockHighlightDrawEvent event) {
        class_4184 camera = event.getCamera();
        class_1297 class_12972 = camera.method_19331();
        if (!(class_12972 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_12972;
        class_1937 level = camera.method_19331().method_37908();
        if (!SatelliteMain.chiselBitsApi.isChiseledBlock(level, event.getHitResult().method_17777())) {
            return;
        }
        class_3965 hitResult = event.getHitResult();
        if (hitResult.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        for (SatelliteDisplayClient disp : DISPLAYS) {
            if (!disp.holoBlocks.contains(hitResult.method_17777())) continue;
            event.setCanceled(true);
            return;
        }
    }
}

