/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.satellite.client.screen;

import com.google.gson.JsonObject;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.console.Messager;
import com.holybuckets.foundation.networking.SimpleStringMessage;
import com.holybuckets.foundation.structure.StructureInfo;
import com.holybuckets.foundation.structure.StructureManager;
import com.holybuckets.satellite.block.be.SatelliteBlockEntity;
import com.holybuckets.satellite.client.screen.StructureListWidget;
import com.holybuckets.satellite.config.ModConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class SatelliteScreen
extends class_437 {
    private static final class_2561 TITLE = class_2561.method_43470((String)"Satellite Controller");
    private static final class_2561 X_LABEL = class_2561.method_43470((String)"X:");
    private static final class_2561 Y_LABEL = class_2561.method_43470((String)"Y:");
    private static final class_2561 Z_LABEL = class_2561.method_43470((String)"Z:");
    private final SatelliteBlockEntity satelliteBlock;
    private class_342 xEdit;
    private class_342 yEdit;
    private class_342 zEdit;
    private class_4185 exitButton;
    private class_4185 launchButton;
    private int currentX;
    private int currentY;
    private int currentZ;
    private StructureListWidget structureList;
    private static final float LEFT_COLUMN_WIDTH = 0.3f;
    private static final float RIGHT_COLUMN_WIDTH = 0.7f;
    private static final float COORD_SECTION_HEIGHT = 0.4f;
    private static final float INVENTORY_SECTION_HEIGHT = 0.3f;
    private static final float BUTTON_SECTION_HEIGHT = 0.3f;
    private static final float RIGHT_LIST_HEIGHT = 0.6f;
    private static final float RIGHT_INVENTORY_HEIGHT = 0.4f;
    private int leftColumnX;
    private int leftColumnWidth;
    private int rightColumnX;
    private int rightColumnWidth;
    private int guiTop;
    private int guiHeight;
    private int guiWidth;
    private int guiLeft;

    public SatelliteScreen(SatelliteBlockEntity satelliteBlock) {
        super(TITLE);
        this.satelliteBlock = satelliteBlock;
    }

    protected void method_25426() {
        super.method_25426();
        this.guiWidth = (int)((float)this.field_22789 * 0.7f);
        this.guiLeft = (this.field_22789 - this.guiWidth) / 2;
        this.guiHeight = this.field_22790 - 60;
        this.guiTop = 50;
        this.leftColumnWidth = (int)((float)this.guiWidth * 0.3f);
        this.rightColumnWidth = (int)((float)this.guiWidth * 0.7f);
        this.leftColumnX = this.guiLeft + 10;
        this.rightColumnX = this.leftColumnX + this.leftColumnWidth + 10;
        this.initLeftColumn();
        this.initRightColumn();
    }

    private void initLeftColumn() {
        int sectionHeight = (int)((float)this.guiHeight * 0.4f);
        int yStart = this.guiTop + 15;
        int labelWidth = 20;
        int editBoxWidth = this.leftColumnWidth - labelWidth - 10;
        int boxHeight = 20;
        int verticalBuffer = 8;
        int availableSpace = sectionHeight - 15 - 3 * boxHeight;
        int spacing = availableSpace / 4;
        this.xEdit = new class_342(this.field_22793, this.leftColumnX + labelWidth, yStart + spacing, editBoxWidth, boxHeight, (class_2561)class_2561.method_43470((String)"X"));
        this.currentX = this.satelliteBlock.getTargetPos().method_10263();
        this.xEdit.method_1852(String.valueOf(this.currentX));
        this.xEdit.method_1880(10);
        this.xEdit.method_1858(true);
        this.xEdit.method_1888(true);
        this.method_37063((class_364)this.xEdit);
        this.yEdit = new class_342(this.field_22793, this.leftColumnX + labelWidth, yStart + spacing + boxHeight + verticalBuffer, editBoxWidth, boxHeight, (class_2561)class_2561.method_43470((String)"Y"));
        this.currentY = this.satelliteBlock.getTargetPos().method_10264();
        this.yEdit.method_1852(String.valueOf(this.currentY));
        this.yEdit.method_1880(10);
        this.yEdit.method_1858(true);
        this.yEdit.method_1888(true);
        this.method_37063((class_364)this.yEdit);
        this.zEdit = new class_342(this.field_22793, this.leftColumnX + labelWidth, yStart + spacing + (boxHeight + verticalBuffer) * 2, editBoxWidth, boxHeight, (class_2561)class_2561.method_43470((String)"Z"));
        this.currentZ = this.satelliteBlock.getTargetPos().method_10260();
        this.zEdit.method_1852(String.valueOf(this.currentZ));
        this.zEdit.method_1880(10);
        this.zEdit.method_1858(true);
        this.zEdit.method_1888(true);
        this.method_37063((class_364)this.zEdit);
        int inventoryY = yStart + sectionHeight;
        int inventoryHeight = (int)((float)this.guiHeight * 0.3f);
        int buttonSectionY = inventoryY + inventoryHeight;
        int buttonSectionHeight = (int)((float)this.guiHeight * 0.3f);
        int buttonSpacing = buttonSectionHeight / 3;
        this.exitButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Exit"), button -> this.method_25419()).method_46434(this.leftColumnX, buttonSectionY + buttonSpacing / 2, this.leftColumnWidth, 20).method_46431();
        this.method_37063((class_364)this.exitButton);
        this.launchButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Move"), button -> this.onLaunch()).method_46434(this.leftColumnX, buttonSectionY + buttonSpacing + buttonSpacing / 2, this.leftColumnWidth, 20).method_46431();
        this.method_37063((class_364)this.launchButton);
    }

    private void initRightColumn() {
        int listHeight = (int)((float)this.guiHeight * 0.6f);
        int listTop = this.guiTop + 15;
        this.structureList = new StructureListWidget(this.field_22787, this.rightColumnWidth - 20, listHeight, listTop, listTop + listHeight, 25, this.rightColumnX, this);
        List<StructureInfo> structures = this.getStructureList(this.satelliteBlock.method_11016());
        for (StructureInfo info : structures) {
            this.structureList.addEntry(info);
        }
        this.method_37063((class_364)this.structureList);
        int inventoryY = listTop + listHeight + 10;
        int inventoryHeight = (int)((float)this.guiHeight * 0.4f);
    }

    public void method_25393() {
        super.method_25393();
        if (this.structureList != null && this.structureList.method_25334() != null && ((StructureListWidget.StructureEntry)this.structureList.method_25334()).method_25370()) {
            StructureListWidget.StructureEntry widget = (StructureListWidget.StructureEntry)this.structureList.method_25334();
            class_2338 pos = widget.getStructure().getOrigin();
            this.currentX = pos.method_10263();
            this.currentY = pos.method_10264();
            this.currentZ = pos.method_10260();
        }
        if (!this.xEdit.method_25370()) {
            this.xEdit.method_1852(String.valueOf(this.currentX));
        }
        if (!this.yEdit.method_25370()) {
            this.yEdit.method_1852(String.valueOf(this.currentY));
        }
        if (!this.zEdit.method_25370()) {
            this.zEdit.method_1852(String.valueOf(this.currentZ));
        }
        this.xEdit.method_1865();
        this.yEdit.method_1865();
        this.zEdit.method_1865();
        try {
            this.currentX = Integer.parseInt(this.xEdit.method_1882());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.currentY = Integer.parseInt(this.yEdit.method_1882());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.currentZ = Integer.parseInt(this.zEdit.method_1882());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)this.field_22789 / 2.0f, 10.0f, 0.0f);
        graphics.method_51448().method_22905(1.3f, 1.3f, 1.3f);
        graphics.method_27534(this.field_22793, this.field_22785, 0, 0, 0xFFFFFF);
        graphics.method_51448().method_22909();
        class_2338 currentPos = this.satelliteBlock.method_11016();
        String currentPosText = String.format("Current Position: %d, %d, %d", currentPos.method_10263(), currentPos.method_10264(), currentPos.method_10260());
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)currentPosText), this.field_22789 / 2, 24, 0x808080);
        class_2338 targetPos = this.satelliteBlock.getTargetPos();
        if (this.satelliteBlock.isTraveling() && targetPos != null && !targetPos.equals((Object)currentPos)) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)(this.field_22789 / 2), 36.0f, 0.0f);
            graphics.method_51448().method_22905(0.5f, 0.5f, 0.5f);
            String targetPosText = String.format("Traveling To: %d, %d, %d", targetPos.method_10263(), targetPos.method_10264(), targetPos.method_10260());
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)targetPosText), 0, 0, 65280);
            graphics.method_51448().method_22909();
        }
        graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Target Position"), this.leftColumnX, this.guiTop, 0xFFFFFF);
        graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Structures"), this.rightColumnX, this.guiTop, 0xFFFFFF);
        int sectionHeight = (int)((float)this.guiHeight * 0.4f);
        int yStart = this.guiTop + 15;
        int boxHeight = 20;
        int verticalBuffer = 8;
        int availableSpace = sectionHeight - 15 - 3 * boxHeight;
        int spacing = availableSpace / 4;
        graphics.method_27535(this.field_22793, X_LABEL, this.leftColumnX, yStart + spacing + 5, 0xA0A0A0);
        graphics.method_27535(this.field_22793, Y_LABEL, this.leftColumnX, yStart + spacing + boxHeight + verticalBuffer + 5, 0xA0A0A0);
        graphics.method_27535(this.field_22793, Z_LABEL, this.leftColumnX, yStart + spacing + (boxHeight + verticalBuffer) * 2 + 5, 0xA0A0A0);
        int listHeight = (int)((float)this.guiHeight * 0.6f);
        int listTop = this.guiTop + 15;
        graphics.method_25294(this.rightColumnX - 2, listTop - 2, this.rightColumnX + this.rightColumnWidth - 18, listTop + listHeight + 2, Integer.MIN_VALUE);
        graphics.method_49601(this.rightColumnX - 2, listTop - 2, this.rightColumnWidth - 16, listHeight + 4, -1);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public void method_25419() {
        try {
            int x = Integer.parseInt(this.xEdit.method_1882());
            int y = Integer.parseInt(this.yEdit.method_1882());
            int z = Integer.parseInt(this.zEdit.method_1882());
            this.satelliteBlock.setTargetPos(new class_2338(x, y, z));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        super.method_25419();
    }

    private void onLaunch() {
        this.method_25419();
        class_2338 target = this.satelliteBlock.getTargetPos();
        if (target == null) {
            this.msg("Satellite target position is not set");
            return;
        }
        if (target.equals((Object)this.satelliteBlock.method_11016())) {
            this.msg("Satellite target position is the same as current position");
            return;
        }
        if (this.satelliteBlock.getColorId() == -1) {
            this.msg("Satellite color ID is not set.  Right click the sides of the block");
            return;
        }
        this.satelliteBlock.launch(target);
        JsonObject json = new JsonObject();
        json.addProperty("colorId", (Number)this.satelliteBlock.getColorId());
        json.addProperty("targetPos", HBUtil.BlockUtil.positionToString((class_2382)this.satelliteBlock.getTargetPos()));
        SimpleStringMessage.createAndFire((String)"satellite_target_pos", (String)json.toString());
    }

    private void msg(String s) {
        Messager.getInstance().sendChat((class_1657)class_310.method_1551().field_1724, s);
    }

    public boolean method_25421() {
        return false;
    }

    private List<StructureInfo> getStructureList(class_2338 center) {
        class_1937 level = this.satelliteBlock.method_10997();
        StructureManager manager = StructureManager.get((class_1937)level);
        if (manager == null) {
            return new ArrayList<StructureInfo>();
        }
        Set<class_2960> targetStructures = ModConfig.getTrackedStructures();
        return manager.getNearestWhitelistedStructures(targetStructures, center, 128);
    }
}

