/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.satellite.client.screen;

import com.holybuckets.foundation.structure.StructureInfo;
import com.holybuckets.satellite.client.screen.SatelliteScreen;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_5250;

public class StructureListWidget
extends class_4280<StructureEntry> {
    private final SatelliteScreen parent;
    private final Set<class_2338> selectedPositions;

    public StructureListWidget(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight, int x0, SatelliteScreen parent) {
        super(minecraft, width, height, top, bottom, itemHeight);
        this.parent = parent;
        this.field_19088 = x0;
        this.field_19087 = x0 + width;
        this.method_31322(false);
        this.method_31323(false);
        this.selectedPositions = new HashSet<class_2338>();
    }

    public int method_25322() {
        return this.field_22742 - 20;
    }

    protected int method_25329() {
        return this.field_19087 - 6;
    }

    public int method_25342() {
        return this.field_19088;
    }

    protected void method_25325(class_332 graphics) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean listClicked = super.method_25402(mouseX, mouseY, button);
        if (button == 0 && !listClicked) {
            this.setSelected(null);
            return false;
        }
        return true;
    }

    public void method_44398(class_332 graphics, int top, int entryWidth, int entryHeight, int borderColor, int fillColor) {
        int left = this.method_25342();
        int right = left + entryWidth;
        graphics.method_49601(left - 1, top - 1, entryWidth + 2, entryHeight + 2, borderColor);
    }

    public void setSelected(StructureEntry entry) {
        super.method_25313((class_350.class_351)entry);
        if (entry != null) {
            // empty if block
        }
    }

    public void addEntry(StructureInfo structure) {
        if (structure == null || this.selectedPositions.contains(structure.getOrigin())) {
            return;
        }
        this.method_25321((class_350.class_351)new StructureEntry(structure, this));
    }

    public static class StructureEntry
    extends class_4280.class_4281<StructureEntry> {
        private final StructureInfo structure;
        private final StructureListWidget list;
        private final class_310 minecraft;

        public StructureEntry(StructureInfo structure, StructureListWidget list) {
            this.structure = structure;
            this.list = list;
            this.minecraft = class_310.method_1551();
        }

        public void method_25343(class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            if (isMouseOver) {
                graphics.method_25294(left, top, left + width, top + height, -2139062144);
            }
            class_5250 nameComponent = class_2561.method_43470((String)this.structure.getCommonName());
            graphics.method_27535(this.minecraft.field_1772, (class_2561)nameComponent, left + 5, top + 2, 0xFFFFFF);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)(left + 5), (float)(top + 12), 0.0f);
            graphics.method_51448().method_22905(0.8f, 0.8f, 0.8f);
            String coordText = String.format("X: %d, Y: %d, Z: %d", this.structure.getOrigin().method_10263(), this.structure.getOrigin().method_10264(), this.structure.getOrigin().method_10260());
            class_5250 coordComponent = class_2561.method_43470((String)coordText);
            graphics.method_27535(this.minecraft.field_1772, (class_2561)coordComponent, 0, 0, 0xA0A0A0);
            graphics.method_51448().method_22909();
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.list.setSelected(this);
                return true;
            }
            return false;
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)(this.structure.getCommonName() + " at " + this.structure.getOrigin().method_23854()));
        }

        public StructureInfo getStructure() {
            return this.structure;
        }
    }
}

