/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.satellite.config;

import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.satellite.LoggerProject;
import com.holybuckets.satellite.SatelliteMain;
import com.holybuckets.satellite.config.SatelliteConfig;
import java.util.HashSet;
import java.util.Set;
import net.blay09.mods.balm.api.event.EventPriority;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7924;

public class ModConfig {
    private static Set<class_1299<?>> friendlyEntities = new HashSet();
    private static Set<class_1299<?>> hostileEntities = new HashSet();
    private static Set<class_1299<?>> neutralEntities = new HashSet();
    private static Set<class_1299<?>> herdEntities = new HashSet();
    private static Set<class_2960> trackedStructures = new HashSet<class_2960>();

    public static void init(EventRegistrar reg) {
        reg.registerOnBeforeServerStarted(e -> ModConfig.loadDynamicConfigs((class_5455)e.getServer().method_30611()), EventPriority.High);
    }

    public static void onConnectedToServer(class_1937 level) {
        if (GeneralConfig.getInstance().isIntegrated()) {
            return;
        }
        ModConfig.loadDynamicConfigs(level.method_30349());
    }

    private static void loadDynamicConfigs(class_5455 reg) {
        friendlyEntities.clear();
        hostileEntities.clear();
        neutralEntities.clear();
        herdEntities.clear();
        class_2378 registry = reg.method_30530(class_7924.field_41266);
        SatelliteConfig config = SatelliteMain.CONFIG;
        for (String entityId : config.entityPings.friendlyEntityTypes) {
            ModConfig.addEntity(entityId, registry, friendlyEntities);
        }
        for (String entityId : config.entityPings.hostileEntityTypes) {
            ModConfig.addEntity(entityId, registry, hostileEntities);
        }
        for (String entityId : config.entityPings.neutralEntityTypes) {
            ModConfig.addEntity(entityId, registry, neutralEntities);
        }
        for (String entityId : config.entityPings.herdEntityTypes) {
            ModConfig.addEntity(entityId, registry, herdEntities);
        }
        trackedStructures.clear();
        for (String structId : config.satelliteConfig.satelliteStructureTargetOptions) {
            class_2960 loc = new class_2960(structId);
            if (loc != null) {
                trackedStructures.add(loc);
                continue;
            }
            LoggerProject.logWarning("010001", "Satellite Config: Could not find structure type for id: " + structId);
        }
    }

    private static void addEntity(String entityId, class_2378<class_1299<?>> registry, Set<class_1299<?>> targetSet) {
        class_1299 type = (class_1299)registry.method_10223(new class_2960(entityId));
        if (type != null) {
            targetSet.add(type);
        } else {
            LoggerProject.logWarning("010000", "Satellite Config: Could not find entity type for id: " + entityId);
        }
    }

    public static Set<class_1299<?>> getFriendlyEntities() {
        return friendlyEntities;
    }

    public static Set<class_1299<?>> getHostileEntities() {
        return hostileEntities;
    }

    public static Set<class_1299<?>> getNeutralEntities() {
        return neutralEntities;
    }

    public static Set<class_1299<?>> getHerdEntities() {
        return herdEntities;
    }

    public static Set<class_2960> getTrackedStructures() {
        return trackedStructures;
    }
}

