/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.satellite.config;

import java.util.Set;
import net.blay09.mods.balm.api.config.reflection.Comment;
import net.blay09.mods.balm.api.config.reflection.Config;
import net.blay09.mods.balm.api.config.reflection.NestedType;

@Config(value="hbs_satellites")
public class SatelliteConfig {
    public SatelliteDisplayConfig displayConfig = new SatelliteDisplayConfig();
    public EntityPingConfig entityPings = new EntityPingConfig();
    public SatelliteBlockConfig satelliteConfig = new SatelliteBlockConfig();

    public static class SatelliteDisplayConfig {
        @Comment(value="If there is no player within this range from the satellite controller, the controller turns off")
        public int playerRange = 64;
        @Comment(value="Display refresh rate in ticks")
        public int displayRefreshRate = 60;
        @Comment(value="Display refresh rate for chunks currently inhabited by a player in ticks")
        public int displayPlayerRefreshRate = 10;
        @Comment(value="Entity refresh rate in ticks")
        public int entityRefreshRate = 10;
        @Comment(value="Controller path refresh rate in ticks")
        public int controllerPathRefreshRate = 200;
        @Comment(value="Refresh rate for command processing in ticks")
        public int controllerUIRefreshRate = 20;
    }

    public static class EntityPingConfig {
        @NestedType(value=String.class)
        @Comment(value="Entity types produce green ping on the satellite display")
        public Set<String> friendlyEntityTypes = Set.of("minecraft:villager", "minecraft:allay");
        @Comment(value="Registers all mobs defined as hostile as red ping")
        public boolean addAllHostileMobsAsRedPing = true;
        @NestedType(value=String.class)
        @Comment(value="Entity types produce red ping on the satellite display")
        public Set<String> hostileEntityTypes = Set.of("minecraft:zombie", "minecraft:zombie_villager", "minecraft:skeleton", "minecraft:creeper", "minecraft:spider", "minecraft:enderman", "minecraft:wither_skeleton", "minecraft:husk", "minecraft:stray", "minecraft:drowned", "minecraft:phantom", "minecraft:evoker", "minecraft:vindicator", "minecraft:ravager", "minecraft:pillager", "minecraft:witch", "minecraft:blaze", "minecraft:magma_cube", "minecraft:ghast", "minecraft:endermite", "minecraft:silverfish", "minecraft:cave_spider");
        @NestedType(value=String.class)
        @Comment(value="Entity types produce a white ping")
        public Set<String> neutralEntityTypes = Set.of("minecraft:iron_golem");
        @NestedType(value=String.class)
        @Comment(value="Entity types only produce a white ping when grouped in large quantities")
        public Set<String> herdEntityTypes = Set.of("minecraft:cow", "minecraft:sheep", "minecraft:chicken", "minecraft:pig", "minecraft:horse", "minecraft:donkey", "minecraft:llama", "minecraft:wolf", "minecraft:cat");
        @Comment(value="Minimum count of entities to be considered a herd")
        public int minHerdCountThreshold = 5;
    }

    public static class SatelliteBlockConfig {
        @Comment(value="Satellite will not operate below this y level")
        public int minSatelliteWorkingHeight = 256;
        @Comment(value="Maximum chunk sections below surface that a satellite can view by default, each section is 16 blocks tall, larger number indicates deeper reach")
        public int maxSatelliteDepthSectionDefault = 8;
        @Comment(value="Maximum number of chunks away from Satellite Block players may view blocks, -1 for no limit")
        public int satelliteReachDistChunksDefault = -1;
        @Comment(value="Maximum number of chunks away from launch station satellite may operate, -1 for no limit")
        public int satelliteOperationalDistChunksDefault = -1;
        @Comment(value="Satellite travel rate")
        public int satelliteTravelRateChunksPerSecond = 8;
        @NestedType(value=String.class)
        @Comment(value="Surface structures the satellite block interface will seek for you. Overworld only. These locations are not validated on the client side.")
        public Set<String> satelliteStructureTargetOptions = Set.of("minecraft:desert_pyramid", "minecraft:jungle_pyramid", "minecraft:desert_outpost", "minecraft:pillager_outpost", "minecraft:mansion", "minecraft:village_plains", "minecraft:village_desert", "minecraft:village_savanna", "minecraft:village_snowy", "minecraft:village_taiga", "minecraft:swamp_hut", "minecraft:igloo");
    }
}

