/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.satellite.core;

import com.holybuckets.foundation.HBUtil;
import com.holybuckets.satellite.SatelliteMain;
import com.holybuckets.satellite.api.ChiselBitsAPI;
import com.holybuckets.satellite.block.be.isatelliteblocks.ISatelliteDisplayBE;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;

public class ChunkDisplayInfo {
    public int levelSectionIndex;
    public class_2818 chunk;
    public HBUtil.TripleInt blockOffset;
    public int[] holoBits;
    public boolean[] hasUpdates = new boolean[16];
    public int currentYIndexForBatch = -1;
    public boolean isActive = true;
    public int lifetime;
    public Map<class_1299<?>, EntityInfo> localEntities = new HashMap();
    public boolean hasPlayer = false;

    private ChunkDisplayInfo() {
    }

    public ChunkDisplayInfo(int[] bits) {
        this();
        this.holoBits = bits;
    }

    public ChunkDisplayInfo(int levelSectionIndex, class_2818 chunk, HBUtil.TripleInt blockOffset) {
        this();
        this.levelSectionIndex = levelSectionIndex;
        this.chunk = chunk;
        this.blockOffset = blockOffset;
        this.holoBits = new int[4096];
        ChunkDisplayInfo.updateBits(this.holoBits, this, true);
    }

    public ChunkDisplayInfo(class_2818 chunk, int levelSectionIndex) {
        this(levelSectionIndex, chunk, new HBUtil.TripleInt(0, 0, 0));
    }

    public int augmentBatch() {
        ++this.currentYIndexForBatch;
        if (this.currentYIndexForBatch > 15) {
            this.currentYIndexForBatch = 0;
        }
        return this.currentYIndexForBatch;
    }

    public void resetUpdates() {
        for (int i = 0; i < 16; ++i) {
            this.hasUpdates[i] = true;
        }
        this.lifetime = 0;
        this.isActive = true;
    }

    public void refreshBits(boolean force) {
        this.lifetime = 0;
        this.isActive = true;
        if (this.chunk == null) {
            return;
        }
        if (force || this.chunk.method_12044()) {
            ChunkDisplayInfo.updateBits(this.holoBits, this, false);
        }
        if (force) {
            this.resetUpdates();
        }
    }

    public void tick() {
        if (!this.isActive) {
            ++this.lifetime;
        }
    }

    static Set<Integer> updateBits(int[] holoBits, ChunkDisplayInfo info, boolean init) {
        class_2818 chunk = info.chunk;
        class_2826 section = chunk.method_12006()[info.levelSectionIndex];
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    class_2680 originalBlock = section.method_12254(x, y, z);
                    int p = ISatelliteDisplayBE.getCachePos(x, y, z);
                    int temp = ChiselBitsAPI.IGNORE.contains(originalBlock.method_26204()) ? 0 : (ChiselBitsAPI.DARK.contains(originalBlock.method_26204()) ? 4 : 2);
                    int n = y;
                    info.hasUpdates[n] = info.hasUpdates[n] | holoBits[p] != temp;
                    holoBits[p] = temp;
                }
            }
        }
        return null;
    }

    public void delta(int dx, int dy, int dz) {
        this.blockOffset.x += dx;
        this.blockOffset.y += dy;
        this.blockOffset.z += dz;
    }

    public boolean acceptLocalEntity(class_1297 e) {
        EntityInfo info = this.localEntities.get(e.method_5864());
        if (info == null) {
            info = new EntityInfo();
            info.target = e;
            info.others.add(e);
            this.localEntities.put(e.method_5864(), info);
            return false;
        }
        info.others.add(e);
        if (info.target == null) {
            info.target = e;
            return false;
        }
        return info.others.size() >= SatelliteMain.CONFIG.entityPings.minHerdCountThreshold;
    }

    public void clearEntities() {
        for (EntityInfo info : this.localEntities.values()) {
            info.others.clear();
            class_1297 e = info.target;
            if (e instanceof class_1309 && e.method_5805() && !e.method_31481()) continue;
            info.target = null;
        }
    }

    static class EntityInfo {
        public class_1297 target;
        public HashSet<class_1297> others = new HashSet();

        EntityInfo() {
        }
    }
}

