/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.satellite.core;

import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.event.custom.ServerTickEvent;
import com.holybuckets.foundation.event.custom.TickType;
import com.holybuckets.satellite.SatelliteMain;
import com.holybuckets.satellite.block.be.SatelliteBlockEntity;
import com.holybuckets.satellite.block.be.SatelliteControllerBlockEntity;
import com.holybuckets.satellite.block.be.SatelliteDisplayBlockEntity;
import com.holybuckets.satellite.block.be.isatelliteblocks.ISatelliteDisplayBE;
import com.holybuckets.satellite.config.ModConfig;
import com.holybuckets.satellite.config.SatelliteConfig;
import com.holybuckets.satellite.core.ChunkDisplayInfo;
import com.holybuckets.satellite.core.SatelliteManager;
import com.holybuckets.satellite.particle.ModParticles;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public class SatelliteDisplay {
    private static Map<HBUtil.TripleInt, ChunkDisplayInfo> INFO_CACHE = new LinkedHashMap<HBUtil.TripleInt, ChunkDisplayInfo>();
    protected class_1937 level;
    protected SatelliteControllerBlockEntity controller;
    private SatelliteBlockEntity satellite;
    int zOffset;
    int xOffset;
    class_1923 target;
    int currentSection;
    int maxSection;
    int depth;
    boolean needsUpdate;
    boolean needsEntityUpdate;
    protected Map<class_2338, ISatelliteDisplayBE> displayBlocks;
    protected int minX = Integer.MAX_VALUE;
    protected int maxX = Integer.MIN_VALUE;
    protected int minZ = Integer.MAX_VALUE;
    protected int maxZ = Integer.MIN_VALUE;
    Set<class_1297> displayEntities;
    private Set<ISatelliteDisplayBE> rateLimiter;
    private static final int MAX_RENDER_PER_TICK = 5;
    protected static SatelliteConfig CONFIG;
    public int lifetime;
    private class_3965 cursorPos;
    private class_3965 cursorSelection;
    private static int MAX_DEPTH;
    static final float RENDER_SCALE = 0.0625f;
    private static final int MAX_LIFETIME = 300;
    private static Map<class_1299, class_2394> PARTICLE_TYPE_MAP;

    protected SatelliteDisplay(class_1937 level, SatelliteControllerBlockEntity controller) {
        this(level, null, controller);
    }

    public SatelliteDisplay(class_1937 level, SatelliteBlockEntity satellite, SatelliteControllerBlockEntity controller) {
        this.level = level;
        this.satellite = satellite;
        this.controller = controller;
        this.zOffset = 0;
        this.xOffset = 0;
        this.depth = 2;
        this.needsUpdate = true;
        this.displayBlocks = new HashMap<class_2338, ISatelliteDisplayBE>();
        this.rateLimiter = new HashSet<ISatelliteDisplayBE>();
        this.displayEntities = new HashSet<class_1297>();
        if (satellite == null) {
            return;
        }
        this.target = HBUtil.ChunkUtil.getChunkPos((class_2338)satellite.method_11016());
        this.resetChunkSection();
        CONFIG = SatelliteMain.CONFIG;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getCurrentSection() {
        return this.currentSection;
    }

    public void adjOrdinal(int dNS, int dEW) {
        if (this.noSource() || this.satellite == null) {
            return;
        }
        if (dNS == 0 && dEW == 0) {
            return;
        }
        this.zOffset += dNS;
        this.xOffset += dEW;
        class_1923 satellitePos = HBUtil.ChunkUtil.getChunkPos((class_2338)this.satellite.method_11016());
        this.target = new class_1923(satellitePos.field_9181 + this.xOffset, satellitePos.field_9180 + this.zOffset);
        this.needsUpdate = true;
    }

    public void adjDisplayDepth(int dDepth) {
        if (this.noSource() || this.satellite == null) {
            return;
        }
        if (dDepth == 0) {
            return;
        }
        this.depth += dDepth;
        if (this.depth <= 0) {
            this.depth = MAX_DEPTH;
        }
        if (this.depth > MAX_DEPTH) {
            this.depth = 1;
        }
        this.needsUpdate = true;
    }

    public void setDepth(int newDepth) {
        if (this.noSource() || this.satellite == null) {
            return;
        }
        if (newDepth == this.depth) {
            return;
        }
        if (newDepth < 1) {
            newDepth = 1;
        }
        if (newDepth > 4) {
            newDepth = 4;
        }
        this.depth = newDepth;
        this.needsUpdate = true;
    }

    public void setCurrentSection(int section) {
        if (section < 0 || section >= this.maxSection - this.depth) {
            return;
        }
        if (section == this.currentSection) {
            return;
        }
        this.currentSection = section;
        this.needsUpdate = true;
    }

    public void adjCurrentSection(int delta) {
        if (this.noSource() || this.satellite == null) {
            return;
        }
        if (delta == 0) {
            return;
        }
        int newSection = this.currentSection + delta;
        if (newSection < 0 || newSection + this.depth > this.maxSection) {
            return;
        }
        this.currentSection = newSection;
        this.needsUpdate = true;
    }

    private void setPosition(class_1657 p, class_3965 res) {
        if (this.controller == null) {
            return;
        }
        if (res == null || p == null) {
            return;
        }
        class_243 playerEye = p.method_5836(1.0f);
        class_243 cursorToEye = playerEye.method_1020(res.method_17784()).method_1029();
        this.cursorSelection = new class_3965(res.method_17784().method_1019(cursorToEye.method_1021(0.0625)), res.method_17780(), res.method_17777(), res.method_17781());
        class_2338 holoBlock = this.cursorSelection.method_17777();
        class_243 hitLoc = this.cursorSelection.method_17784();
        class_2338 controllerOffset = this.getOffset(holoBlock);
        class_2382 chunkSecOffset = new class_2382(this.target.field_9181 + controllerOffset.method_10263(), this.currentSection - this.depth + controllerOffset.method_10264(), this.target.field_9180 + controllerOffset.method_10260());
        class_243 blockOffset = new class_243((hitLoc.field_1352 - (double)holoBlock.method_10263()) * 16.0, (hitLoc.field_1351 - (double)holoBlock.method_10264()) * 16.0, (hitLoc.field_1350 - (double)holoBlock.method_10260()) * 16.0);
        int yOffset = HBUtil.WorldPos.sectionIndexToY((int)chunkSecOffset.method_10264(), (int)this.level.method_31607()) + (int)blockOffset.field_1351;
        class_2338 blockTarget = this.level.method_8497(chunkSecOffset.method_10263(), chunkSecOffset.method_10260()).method_12004().method_35231((int)blockOffset.field_1352, yOffset, (int)blockOffset.field_1350);
        this.controller.setUiPosition(blockTarget);
    }

    public void resetChunkSection() {
        if (this.noSource() || this.satellite == null || this.target == null) {
            return;
        }
        class_2826[] sections = this.level.method_8497(this.target.field_9181, this.target.field_9180).method_12006();
        for (int i = this.maxSection = HBUtil.WorldPos.yToSectionIndex((int)this.satellite.method_11016().method_10264(), (int)this.level.method_31607()) - 1; i >= 1; --i) {
            class_2826 section = sections[i];
            if (section == null || section.method_38292()) continue;
            this.currentSection = i;
            break;
        }
        this.needsUpdate = true;
    }

    public void resetOrdinal() {
        this.zOffset = 0;
        this.xOffset = 0;
        if (this.noSource() || this.satellite == null) {
            return;
        }
        this.target = HBUtil.ChunkUtil.getChunkPos((class_2338)this.satellite.method_11016());
        this.needsUpdate = true;
    }

    public boolean needsClear() {
        return this.needsUpdate;
    }

    public void setNeedsUpdate(boolean b) {
        this.needsUpdate = b;
    }

    public void resetDisplayUpdates() {
        INFO_CACHE.values().forEach(info -> {
            if (info.isActive) {
                info.resetUpdates();
            }
        });
        this.needsUpdate = true;
        if (this.controller != null) {
            this.controller.setUiPosition(null);
        }
        this.cursorSelection = null;
    }

    public static boolean hasActiveDisplay(class_2818 chunk) {
        for (ChunkDisplayInfo info : INFO_CACHE.values()) {
            if (info.chunk != chunk || !info.isActive) continue;
            return true;
        }
        return false;
    }

    public boolean noSource() {
        if (this.satellite == null) {
            return true;
        }
        return !this.controller.isDisplayOn();
    }

    public void add(class_2338 blockPos, ISatelliteDisplayBE displayBlock) {
        this.displayBlocks.put(blockPos, displayBlock);
        this.updateBounds(blockPos);
    }

    private void updateBounds(class_2338 pos) {
        this.minX = Math.min(this.minX, pos.method_10263());
        this.maxX = Math.max(this.maxX, pos.method_10263());
        this.minZ = Math.min(this.minZ, pos.method_10260());
        this.maxZ = Math.max(this.maxZ, pos.method_10260());
    }

    private void recalculateBounds() {
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.minZ = Integer.MAX_VALUE;
        this.maxZ = Integer.MIN_VALUE;
        for (class_2338 pos : this.displayBlocks.keySet()) {
            this.updateBounds(pos);
        }
    }

    public boolean isHitWithinDisplay(class_243 hit) {
        double epsilon = 0.001;
        double adjustedMinX = (double)this.minX - epsilon;
        double adjustedMaxX = (double)this.maxX + 1.0 + epsilon;
        double adjustedMinZ = (double)this.minZ - epsilon;
        double adjustedMaxZ = (double)this.maxZ + 1.0 + epsilon;
        double adjustedMinY = (double)this.controller.method_11016().method_10264() + 1.0 - epsilon;
        double adjustedMaxY = (double)(this.controller.method_11016().method_10264() + this.depth) + 1.0 + epsilon;
        return !(hit.field_1352 < adjustedMinX || hit.field_1352 > adjustedMaxX || hit.field_1350 < adjustedMinZ || hit.field_1350 > adjustedMaxZ || hit.field_1351 < adjustedMinY) && !(hit.field_1351 > adjustedMaxY);
    }

    public void addAll(Map<class_2338, ISatelliteDisplayBE> blocks) {
        this.displayBlocks.putAll(blocks);
        for (class_2338 pos : blocks.keySet()) {
            this.updateBounds(pos);
        }
    }

    public void remove(class_2338 blockPos) {
        this.displayBlocks.remove(blockPos);
        this.recalculateBounds();
    }

    public boolean contains(class_2338 blockPos) {
        return this.displayBlocks.containsKey(blockPos);
    }

    public void clear() {
        this.displayBlocks.clear();
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.minZ = Integer.MAX_VALUE;
        this.maxZ = Integer.MIN_VALUE;
    }

    public class_2338 getOffset(class_2338 blockPos) {
        return blockPos.method_10059((class_2382)this.controller.method_11016());
    }

    public Deque<ChunkDisplayInfo> initDisplayInfo(SatelliteDisplayBlockEntity displayblock) {
        ChunkDisplayInfo info;
        ArrayDeque<ChunkDisplayInfo> infoList = new ArrayDeque<ChunkDisplayInfo>();
        for (int i = this.currentSection; i > this.currentSection - this.depth && i >= 0 && (info = this.getDisplayInfo(displayblock, i)) != null; --i) {
            infoList.push(info);
        }
        return infoList;
    }

    public ChunkDisplayInfo getDisplayInfo(SatelliteDisplayBlockEntity displayblock, int section) {
        class_2338 dispOffset = this.getOffset(displayblock.method_11016());
        HBUtil.TripleInt chunkSelection = new HBUtil.TripleInt(this.target.field_9181 + dispOffset.method_10263(), section, this.target.field_9180 + dispOffset.method_10260());
        if (INFO_CACHE.containsKey(chunkSelection)) {
            ChunkDisplayInfo info = INFO_CACHE.get(chunkSelection);
            if (!info.isActive) {
                info.refreshBits(true);
            }
            info.isActive = true;
            return info;
        }
        SatelliteManager manager = SatelliteManager.get(this.level);
        class_2818 chunk = SatelliteManager.getChunk((class_3218)this.level, chunkSelection.x, chunkSelection.z);
        if (chunk == null) {
            return null;
        }
        if (chunk.method_12006().length <= section) {
            return null;
        }
        INFO_CACHE.put(chunkSelection, new ChunkDisplayInfo(chunk, section));
        return INFO_CACHE.get(chunkSelection);
    }

    public boolean testRender(ISatelliteDisplayBE disp) {
        if (disp.hasPlayer()) {
            return true;
        }
        if (this.rateLimiter.size() > 5 || this.rateLimiter.contains(disp)) {
            return false;
        }
        this.rateLimiter.add(disp);
        return true;
    }

    public void resetRateLimiter() {
        this.rateLimiter.clear();
    }

    public void collectEntities() {
        if (this.noSource() || this.target == null) {
            return;
        }
        if (this.needsUpdate) {
            int zEnd;
            int zStart;
            class_2818 extendedChunk;
            int xEnd;
            int xStart;
            this.needsEntityUpdate = true;
            this.displayEntities.clear();
            class_2338 cntrlPos = this.controller.method_11016();
            int xChunkStart = this.maxX - cntrlPos.method_10263() + this.target.field_9181;
            int xChunkEnd = this.minX - cntrlPos.method_10263() + this.target.field_9181;
            int zChunkStart = this.maxZ - cntrlPos.method_10260() + this.target.field_9180;
            int zChunkEnd = this.minZ - cntrlPos.method_10260() + this.target.field_9180;
            SatelliteManager manager = SatelliteManager.get(this.level);
            class_2818 startChunk = SatelliteManager.getChunk((class_3218)this.level, xChunkStart, zChunkStart);
            class_2818 endChunk = SatelliteManager.getChunk((class_3218)this.level, xChunkEnd, zChunkEnd);
            if (startChunk == null || endChunk == null) {
                return;
            }
            if (xChunkStart <= xChunkEnd) {
                xStart = startChunk.method_12004().method_8326();
                xEnd = endChunk.method_12004().method_8327();
            } else {
                extendedChunk = SatelliteManager.getChunk((class_3218)this.level, xChunkEnd - 1, zChunkStart);
                if (extendedChunk == null) {
                    return;
                }
                xStart = extendedChunk.method_12004().method_8326();
                xEnd = startChunk.method_12004().method_8327();
            }
            if (zChunkStart <= zChunkEnd) {
                zStart = startChunk.method_12004().method_8328();
                zEnd = endChunk.method_12004().method_8329();
            } else {
                extendedChunk = SatelliteManager.getChunk((class_3218)this.level, xChunkStart, zChunkEnd - 1);
                if (extendedChunk == null) {
                    return;
                }
                zStart = extendedChunk.method_12004().method_8328();
                zEnd = startChunk.method_12004().method_8329();
            }
            int minX = Math.min(xStart, xEnd);
            int maxX = Math.max(xStart, xEnd);
            int minZ = Math.min(zStart, zEnd);
            int maxZ = Math.max(zStart, zEnd);
            int yTop = cntrlPos.method_10264();
            int sectionTop = 16 * this.currentSection + 1 + this.level.method_31607();
            int yStart = sectionTop - 16 * (this.depth + 1);
            class_238 aabb = new class_238((double)minX, (double)yStart, (double)minZ, (double)maxX, (double)yTop, (double)maxZ);
            List entitiesInArea = this.level.method_8333((class_1297)null, aabb, this::entityPredicate);
            for (class_1297 e : entitiesInArea) {
                this.addEntity(e);
            }
            this.needsEntityUpdate = false;
        }
        this.displayEntities.addAll(HBUtil.PlayerUtil.getAllPlayers());
    }

    private boolean entityPredicate(class_1297 e) {
        if (!(e instanceof class_1309) || !e.method_5805() || e.method_31481() || this.displayEntities.contains(e)) {
            return false;
        }
        if (e instanceof class_3222) {
            return false;
        }
        if (!(ModConfig.getHostileEntities().contains(e.method_5864()) || ModConfig.getFriendlyEntities().contains(e.method_5864()) || ModConfig.getNeutralEntities().contains(e.method_5864()) || ModConfig.getHerdEntities().contains(e.method_5864()))) {
            return false;
        }
        if (ModConfig.getHerdEntities().contains(e.method_5864())) {
            ChunkDisplayInfo info = INFO_CACHE.get(new HBUtil.TripleInt(e.method_31476().field_9181, this.currentSection, e.method_31476().field_9180));
            if (info == null) {
                return false;
            }
            return info.acceptLocalEntity(e);
        }
        return true;
    }

    public void addEntity(class_1297 e) {
        if (e == null) {
            return;
        }
        this.displayEntities.add(e);
    }

    private static class_2394 getParticleType(class_1297 e) {
        return PARTICLE_TYPE_MAP.getOrDefault(e.method_5864(), (class_2394)class_2398.field_11219);
    }

    public void renderEntities(class_2338 cntrlPos) {
        if (cntrlPos == null || this.noSource() || this.target == null) {
            return;
        }
        if (this.needsEntityUpdate) {
            this.collectEntities();
        }
        Iterator<class_1297> iterator = this.displayEntities.iterator();
        while (iterator.hasNext()) {
            class_1297 e = iterator.next();
            if (e == null || !e.method_5805() || e.method_31481()) {
                iterator.remove();
                continue;
            }
            int chunkOffsetX = e.method_31476().field_9181 - this.target.field_9181;
            int chunkOffsetZ = e.method_31476().field_9180 - this.target.field_9180;
            class_2338 chunkWorldPos = e.method_31476().method_8323();
            int blockOffsetX = e.method_24515().method_10263() - chunkWorldPos.method_10263();
            int blockOffsetZ = e.method_24515().method_10260() - chunkWorldPos.method_10260();
            if (!this.displayBlocks.containsKey(new class_2338(cntrlPos.method_10263() + chunkOffsetX, cntrlPos.method_10264(), cntrlPos.method_10260() + chunkOffsetZ))) continue;
            int Y_MIN = this.level.method_31607();
            int blockOffsetY = e.method_24515().method_10264() - (this.currentSection * 16 + Y_MIN) + (this.depth - 1) * 16;
            if (blockOffsetY < 0) continue;
            if (blockOffsetY > 16 * this.depth) {
                if (!(e instanceof class_3222)) continue;
                blockOffsetY = 16 * (this.depth + 1);
            }
            class_2394 particleType = SatelliteDisplay.getParticleType(e);
            float x = (float)(cntrlPos.method_10263() + chunkOffsetX) + (float)blockOffsetX * 0.0625f;
            float z = (float)(cntrlPos.method_10260() + chunkOffsetZ) + (float)blockOffsetZ * 0.0625f;
            float y = (float)cntrlPos.method_10264() + 1.125f + (float)blockOffsetY * 0.0625f;
            if (x < (float)this.minX || x > (float)this.maxX || z < (float)this.minZ || z > (float)this.maxZ) continue;
            ((class_3218)this.level).method_14199(particleType, (double)x, (double)y, (double)z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void renderUI() {
        if (this.cursorSelection != null) {
            class_243 hitLoc = this.cursorSelection.method_17784();
            ((class_3218)this.level).method_14199((class_2394)class_2390.field_11188, hitLoc.field_1352, hitLoc.field_1351, hitLoc.field_1350, 2, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void init(EventRegistrar reg) {
        reg.registerOnUseBlock(SatelliteDisplay::onBlockUsed);
        reg.registerOnBeforeServerStarted(SatelliteDisplay::onBeforeServerStarted, EventPriority.Lowest);
        reg.registerOnServerTick(TickType.ON_20_TICKS, SatelliteDisplay::onServerTick);
        reg.registerOnServerStopped(event -> INFO_CACHE.clear());
    }

    private static void onServerTick(ServerTickEvent event) {
        Iterator<Map.Entry<HBUtil.TripleInt, ChunkDisplayInfo>> iterator = INFO_CACHE.entrySet().iterator();
        LongOpenHashSet chunksContainPlayer = new LongOpenHashSet();
        HBUtil.PlayerUtil.getAllPlayers().forEach(p -> chunksContainPlayer.add(HBUtil.ChunkUtil.getChunkPos1DMap((class_1923)p.method_31476())));
        while (iterator.hasNext()) {
            Map.Entry<HBUtil.TripleInt, ChunkDisplayInfo> entry = iterator.next();
            ChunkDisplayInfo info = entry.getValue();
            long chunkId = HBUtil.ChunkUtil.getChunkPos1DMap((class_1923)info.chunk.method_12004());
            info.hasPlayer = chunksContainPlayer.contains(chunkId);
            if (info.isActive) continue;
            info.tick();
            if (info.lifetime <= 300) continue;
            iterator.remove();
            SatelliteManager.flagChunkForUnload(info.chunk.method_12200(), info.chunk.method_12004());
        }
    }

    private static void onBeforeServerStarted(ServerStartingEvent event) {
        INFO_CACHE.clear();
        SatelliteDisplay.loadParticleTypes();
    }

    private static void loadParticleTypes() {
        for (class_1299<?> et : ModConfig.getHostileEntities()) {
            PARTICLE_TYPE_MAP.put(et, (class_2394)ModParticles.redPing);
        }
        for (class_1299<?> et : ModConfig.getFriendlyEntities()) {
            PARTICLE_TYPE_MAP.put(et, (class_2394)ModParticles.greenPing);
        }
        for (class_1299<?> et : ModConfig.getNeutralEntities()) {
            PARTICLE_TYPE_MAP.put(et, (class_2394)ModParticles.basePing);
        }
        for (class_1299<?> et : ModConfig.getHerdEntities()) {
            PARTICLE_TYPE_MAP.put(et, (class_2394)ModParticles.basePing);
        }
        PARTICLE_TYPE_MAP.put(class_1299.field_6097, (class_2394)ModParticles.basePing);
        PARTICLE_TYPE_MAP.put(class_1299.field_6069, (class_2394)class_2398.field_11246);
    }

    private static void onBlockUsed(UseBlockEvent useBlockEvent) {
        SatelliteDisplayBlockEntity displayBlockEntity;
        SatelliteDisplay source;
        class_1937 level = useBlockEvent.getLevel();
        if (level == null || level.field_9236) {
            return;
        }
        if (useBlockEvent.getPlayer() == null) {
            return;
        }
        if (useBlockEvent.getHand() != class_1268.field_5808) {
            return;
        }
        if (!useBlockEvent.getPlayer().method_5998(class_1268.field_5808).method_7960()) {
            return;
        }
        if (!SatelliteMain.chiselBitsApi.isChiseledBlock(level, useBlockEvent.getHitResult().method_17777())) {
            return;
        }
        class_3965 res = useBlockEvent.getHitResult();
        double reach = SatelliteControllerBlockEntity.REACH_DIST_BLOCKS;
        if (res == null) {
            return;
        }
        class_2338 pos = res.method_17777();
        class_2338 displayBlockPos = pos.method_10074();
        int dDepth = 0;
        while (dDepth++ < MAX_DEPTH && !(level.method_8321(displayBlockPos) instanceof ISatelliteDisplayBE)) {
            displayBlockPos = displayBlockPos.method_10074();
        }
        class_2586 class_25862 = level.method_8321(displayBlockPos);
        if (class_25862 instanceof SatelliteDisplayBlockEntity && (source = (displayBlockEntity = (SatelliteDisplayBlockEntity)class_25862).getSource()) != null) {
            source.setPosition(useBlockEvent.getPlayer(), res);
        }
    }

    static {
        MAX_DEPTH = 4;
        PARTICLE_TYPE_MAP = new HashMap<class_1299, class_2394>();
    }
}

