/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.satellite.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.event.custom.ServerTickEvent;
import com.holybuckets.foundation.event.custom.SimpleMessageEvent;
import com.holybuckets.foundation.event.custom.TickType;
import com.holybuckets.foundation.model.ManagedChunk;
import com.holybuckets.foundation.model.ManagedChunkUtility;
import com.holybuckets.satellite.SatelliteMain;
import com.holybuckets.satellite.block.ModBlocks;
import com.holybuckets.satellite.block.be.SatelliteBlockEntity;
import com.holybuckets.satellite.block.be.SatelliteControllerBlockEntity;
import com.holybuckets.satellite.core.SatelliteDisplay;
import io.netty.util.collection.IntObjectHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.blay09.mods.balm.api.event.TossItemEvent;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public class SatelliteManager {
    private final IntObjectHashMap<SatelliteBlockEntity> satellites = new IntObjectHashMap(24);
    private final Map<SourceKey, SatelliteDisplay> displaySources = new HashMap<SourceKey, SatelliteDisplay>();
    private final Long2ObjectMap<CachedChunkInfo> chunkCache = new Long2ObjectOpenHashMap(128);
    private static final int MAX_CHUNK_LIFETIME = 300;
    private static final int MAX_DISPLAY_LIFETIME = 300;
    private static boolean anyControllerOn;
    private static final List<class_2248> woolIds;
    private final class_1937 level;
    private static SatelliteManager CLIENT_MANAGER;
    private final boolean isServerSide;
    public static final String MSG_ID_TARGET_POS = "satellite_target_pos";

    public SatelliteManager(class_1937 level) {
        this.level = level;
        this.isServerSide = !level.method_8608();
    }

    public static void init(EventRegistrar reg) {
        reg.registerOnServerTick(TickType.ON_20_TICKS, SatelliteManager::onServerTick);
        reg.registerOnTossItem(SatelliteManager::onTossSatellite);
        reg.registerOnSimpleMessage(MSG_ID_TARGET_POS, SatelliteManager::handleTargetPosMessage);
        SatelliteDisplay.init(reg);
    }

    public static SatelliteManager get(class_1937 level) {
        if (level.field_9236) {
            if (CLIENT_MANAGER == null) {
                CLIENT_MANAGER = new SatelliteManager(level);
            }
            return CLIENT_MANAGER;
        }
        return SatelliteMain.getManager(level);
    }

    public SatelliteBlockEntity get(int colorId) {
        return (SatelliteBlockEntity)this.satellites.get(colorId);
    }

    public void put(int colorId, SatelliteBlockEntity be) {
        if (be == null || colorId < 0) {
            return;
        }
        if (this.satellites.containsKey(colorId)) {
            return;
        }
        ArrayList colors = new ArrayList(this.satellites.keySet());
        Iterator iterator = colors.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            if (this.satellites.get(id) != be) continue;
            this.satellites.remove(id);
        }
        this.satellites.putIfAbsent((Object)colorId, (Object)be);
        be.setLevelChunk(SatelliteManager.getChunk(be.method_10997(), be.method_11016()));
    }

    public void remove(int colorId, SatelliteBlockEntity be) {
        if (colorId < 0) {
            return;
        }
        if (this.satellites.get(colorId) == be) {
            this.satellites.remove(colorId);
        }
    }

    public SatelliteDisplay generateSource(SatelliteBlockEntity satellite, SatelliteControllerBlockEntity controller) {
        anyControllerOn = true;
        SourceKey key = new SourceKey(satellite, controller);
        SatelliteDisplay satelliteDisplay = this.displaySources.get(key);
        if (satelliteDisplay != null) {
            return satelliteDisplay;
        }
        satelliteDisplay = new SatelliteDisplay(this.level, satellite, controller);
        satelliteDisplay.add(controller.method_11016(), controller);
        this.displaySources.put(key, satelliteDisplay);
        return satelliteDisplay;
    }

    public SatelliteDisplay getSource(SatelliteBlockEntity satellite, SatelliteControllerBlockEntity controller) {
        return this.displaySources.get(new SourceKey(satellite, controller));
    }

    public void putSource(SatelliteBlockEntity satellite, SatelliteControllerBlockEntity controller, SatelliteDisplay source) {
        this.displaySources.put(new SourceKey(satellite, controller), source);
    }

    public void removeSource(SatelliteBlockEntity satellite, SatelliteControllerBlockEntity controller) {
        this.displaySources.remove(new SourceKey(satellite, controller));
    }

    public int totalSatellites() {
        return this.satellites.size();
    }

    public static int totalIds() {
        return woolIds.size();
    }

    private static void onTossSatellite(TossItemEvent event) {
        if (event.getPlayer().method_37908().field_9236) {
            return;
        }
        class_1799 stack = event.getItemStack();
        if (!stack.method_31574(ModBlocks.satelliteBlock.method_8389())) {
            return;
        }
        stack.method_7939(stack.method_7947() - 1);
        class_1657 p = event.getPlayer();
        class_2338 placePos = p.method_24515().method_10074().method_10093(p.method_5735());
        p.method_37908().method_8652(placePos, ModBlocks.satelliteBlock.method_9564(), 3);
        event.setCanceled(true);
    }

    public static class_2248 getWool(int id) {
        return new ArrayList<class_2248>(woolIds).get(id % woolIds.size());
    }

    public static int getColorId(class_2248 b) {
        return woolIds.indexOf(b);
    }

    public static class_2960 getResourceForColorId(int colorId) {
        class_2248 wool = SatelliteManager.getWool(colorId);
        if (wool == null) {
            return null;
        }
        class_2960 blockId = class_7923.field_41175.method_10221((Object)wool);
        class_2960 woolLoc = new class_2960(blockId.method_12836(), "block/" + blockId.method_12832());
        return woolLoc;
    }

    public static class_2818 getChunk(class_1937 level, class_2338 pos) {
        return SatelliteManager.getChunk((class_3218)level, HBUtil.ChunkUtil.getChunkPos((class_2338)pos));
    }

    public static class_2818 getChunk(class_3218 level, int chunkX, int chunkZ) {
        return SatelliteManager.getChunk(level, new class_1923(chunkX, chunkZ));
    }

    public static class_2818 getChunk(class_3218 level, class_1923 pos) {
        if (level == null) {
            return null;
        }
        SatelliteManager manager = SatelliteMain.getManager((class_1937)level);
        if (manager == null) {
            return null;
        }
        Long2ObjectMap<CachedChunkInfo> chunkCache = manager.chunkCache;
        long posKey = HBUtil.ChunkUtil.getChunkPos1DMap((class_1923)pos);
        CachedChunkInfo cachedInfo = (CachedChunkInfo)chunkCache.get(posKey);
        if (cachedInfo != null) {
            cachedInfo.lifetime = 0;
            return cachedInfo.chunk;
        }
        String chunkId = HBUtil.ChunkUtil.getId((class_1923)pos);
        ManagedChunk chunk = ManagedChunkUtility.getManagedChunk((class_1936)level, (String)chunkId);
        if (chunk != null) {
            chunkCache.put(posKey, (Object)new CachedChunkInfo(chunk.getLevelChunk(), false));
            return chunk.getLevelChunk();
        }
        HBUtil.ChunkUtil.forceLoadChunk((class_3218)level, (class_1923)pos, (String)"hbs_satellites");
        if (chunk != null) {
            class_2818 levelChunk = chunk.getLevelChunk();
            chunkCache.put(posKey, (Object)new CachedChunkInfo(levelChunk, true));
            return levelChunk;
        }
        return null;
    }

    public static void flagChunkForUnload(class_1937 level, class_1923 pos) {
        if (level == null) {
            return;
        }
        SatelliteManager manager = SatelliteMain.getManager(level);
        if (manager == null) {
            return;
        }
        Long2ObjectMap<CachedChunkInfo> chunkCache = manager.chunkCache;
        long posKey = HBUtil.ChunkUtil.getChunkPos1DMap((class_1923)pos);
        CachedChunkInfo info = (CachedChunkInfo)chunkCache.get(posKey);
        if (info != null) {
            info.lifetime = 300;
        }
    }

    private static void handleTargetPosMessage(SimpleMessageEvent event) {
        JsonElement elem = JsonParser.parseString((String)event.getContent());
        if (elem == null || !elem.isJsonObject()) {
            return;
        }
        JsonObject json = elem.getAsJsonObject();
        int colorId = json.get("colorId").getAsInt();
        class_2338 targetPos = HBUtil.BlockUtil.stringToBlockPos((String)json.get("targetPos").getAsString());
        SatelliteManager manager = SatelliteMain.getManager((class_1937)GeneralConfig.OVERWORLD);
        if (manager == null) {
            return;
        }
        SatelliteBlockEntity satellite = manager.get(colorId);
        if (satellite == null) {
            return;
        }
        satellite.launch(targetPos);
    }

    public boolean moveSatellite(SatelliteBlockEntity be, class_2338 targetPos) {
        if (be == null || targetPos == null) {
            return false;
        }
        if (this.level == null || this.level.field_9236) {
            return false;
        }
        class_2338 oldPos = be.method_11016();
        if (oldPos.equals((Object)targetPos)) {
            return false;
        }
        class_1923 targetChunk = new class_1923(targetPos);
        class_2818 chunk = SatelliteManager.getChunk((class_3218)this.level, targetChunk);
        if (chunk == null) {
            return false;
        }
        int colorId = be.getColorId();
        this.remove(colorId, be);
        class_2487 nbt = be.method_38242();
        class_2680 state = this.level.method_8320(oldPos);
        this.level.method_8650(oldPos, false);
        this.level.method_8652(targetPos, state, 3);
        class_2586 newBE = this.level.method_8321(targetPos);
        if (newBE instanceof SatelliteBlockEntity) {
            SatelliteBlockEntity newSatellite = (SatelliteBlockEntity)newBE;
            newSatellite.method_11014(nbt);
            newSatellite.method_5431();
            ((class_3218)this.level).method_14178().method_14128(targetPos);
            this.put(colorId, newSatellite);
            return true;
        }
        return false;
    }

    public static void onWorldStart() {
        SatelliteManager.initWoolIds();
    }

    public static void onWorldStop() {
        CLIENT_MANAGER = null;
    }

    public static void initWoolIds() {
        woolIds.clear();
        woolIds.add(class_2246.field_10314);
        woolIds.add(class_2246.field_10095);
        woolIds.add(class_2246.field_10490);
        woolIds.add(class_2246.field_10028);
        woolIds.add(class_2246.field_10170);
        woolIds.add(class_2246.field_10619);
        woolIds.add(class_2246.field_10294);
        woolIds.add(class_2246.field_10514);
        woolIds.add(class_2246.field_10259);
        woolIds.add(class_2246.field_10215);
        woolIds.add(class_2246.field_10459);
        woolIds.add(class_2246.field_10446);
        woolIds.add(class_2246.field_10222);
        woolIds.add(class_2246.field_10423);
        woolIds.add(class_2246.field_10113);
        woolIds.add(class_2246.field_10146);
    }

    private static void onServerTick(ServerTickEvent event) {
        Collection<SatelliteManager> managers = SatelliteMain.getAllManagers();
        for (SatelliteManager manager : managers) {
            manager.watchDisplaySourcesCache();
        }
        for (SatelliteManager manager : managers) {
            manager.watchChunkCache();
        }
    }

    private void watchChunkCache() {
        ObjectIterator iterator = this.chunkCache.values().iterator();
        while (iterator.hasNext()) {
            CachedChunkInfo info = (CachedChunkInfo)iterator.next();
            if (SatelliteDisplay.hasActiveDisplay(info.chunk)) {
                info.lifetime = 0;
                continue;
            }
            ++info.lifetime;
            if (info.lifetime <= 300) continue;
            if (info.forceLoaded) {
                HBUtil.ChunkUtil.unforceLoadChunk((class_3218)((class_3218)info.chunk.method_12200()), (class_1923)info.chunk.method_12004(), (String)"hbs_satellites");
            }
            iterator.remove();
        }
    }

    private void watchDisplaySourcesCache() {
        Iterator<Map.Entry<SourceKey, SatelliteDisplay>> sourceIterator = this.displaySources.entrySet().iterator();
        anyControllerOn = false;
        while (sourceIterator.hasNext()) {
            Map.Entry<SourceKey, SatelliteDisplay> entry = sourceIterator.next();
            SatelliteDisplay display = entry.getValue();
            if (display == entry.getKey().controller.getSource()) {
                display.lifetime = 0;
                anyControllerOn = true;
                continue;
            }
            ++display.lifetime;
            if (display.lifetime <= 300) continue;
            display.clear();
            sourceIterator.remove();
        }
    }

    public void shutdown() {
        this.satellites.clear();
        this.chunkCache.forEach((pos, info) -> {
            if (info.forceLoaded) {
                HBUtil.ChunkUtil.unforceLoadChunk((class_3218)((class_3218)info.chunk.method_12200()), (class_1923)info.chunk.method_12004(), (String)"hbs_satellites");
            }
        });
        this.chunkCache.clear();
    }

    public static boolean isAnyControllerOn() {
        return anyControllerOn;
    }

    static {
        woolIds = new ArrayList<class_2248>(64);
    }

    private static class SourceKey {
        SatelliteBlockEntity satellite;
        SatelliteControllerBlockEntity controller;

        SourceKey(SatelliteBlockEntity satellite, SatelliteControllerBlockEntity controller) {
            this.satellite = satellite;
            this.controller = controller;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SourceKey)) {
                return false;
            }
            SourceKey other = (SourceKey)obj;
            return Objects.equals(this.satellite, other.satellite) && Objects.equals(this.controller, other.controller);
        }
    }

    private static class CachedChunkInfo {
        class_2818 chunk;
        int lifetime;
        boolean forceLoaded;

        CachedChunkInfo(class_2818 chunk, boolean forceLoaded) {
            this.chunk = chunk;
            this.lifetime = 0;
            this.forceLoaded = forceLoaded;
        }
    }
}

