/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.satellite.externalapi;

import com.holybuckets.foundation.HBUtil;
import com.holybuckets.satellite.LoggerProject;
import com.holybuckets.satellite.api.ChiselBitsAPI;
import com.holybuckets.satellite.block.HoloBlock;
import com.holybuckets.satellite.block.be.isatelliteblocks.ISatelliteDisplayBE;
import com.holybuckets.satellite.core.ChunkDisplayInfo;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.block.ChiseledBlock;
import mod.chiselsandbits.block.entities.ChiseledBlockEntity;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.multistate.mutator.ChiselAdaptingWorldMutator;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

public class ChiselBitsAPIFabric
implements ChiselBitsAPI {
    static final IBlockInformation[] HOLO_BLOCKS = new IBlockInformation[16];

    private static void initHolo(class_1937 level) {
        int i;
        if (HOLO_BLOCKS[0] != null) {
            return;
        }
        Optional CHISELED = Optional.empty();
        class_2680 AIR = ChiselBitsAPI.HOLO_EMPTY().method_9564();
        ChiselBitsAPIFabric.HOLO_BLOCKS[0] = new BlockInformation(AIR, IStateVariantManager.getInstance().getStateVariant(AIR, CHISELED));
        class_2680 LIGHT = ChiselBitsAPI.HOLO_LIGHT().method_9564();
        ChiselBitsAPIFabric.HOLO_BLOCKS[1] = new BlockInformation(LIGHT, IStateVariantManager.getInstance().getStateVariant(LIGHT, Optional.empty()));
        class_2680 BASE = ChiselBitsAPI.HOLO_BASE().method_9564();
        ChiselBitsAPIFabric.HOLO_BLOCKS[2] = new BlockInformation(BASE, IStateVariantManager.getInstance().getStateVariant(BASE, CHISELED));
        class_2680 DARK = ChiselBitsAPI.HOLO_DARK().method_9564();
        ChiselBitsAPIFabric.HOLO_BLOCKS[3] = new BlockInformation(DARK, IStateVariantManager.getInstance().getStateVariant(DARK, CHISELED));
        class_2680 BLACK = ChiselBitsAPI.HOLO_BLACK().method_9564();
        ChiselBitsAPIFabric.HOLO_BLOCKS[4] = new BlockInformation(BLACK, IStateVariantManager.getInstance().getStateVariant(BLACK, CHISELED));
        for (i = 5; i < 8; ++i) {
            ChiselBitsAPIFabric.HOLO_BLOCKS[i] = HOLO_BLOCKS[4];
        }
        for (i = 8; i < 16; ++i) {
            class_2680 STAINED = ChiselBitsAPI.DEMARCATOR(i - 8).method_9564();
            ChiselBitsAPIFabric.HOLO_BLOCKS[i] = new BlockInformation(STAINED, IStateVariantManager.getInstance().getStateVariant(STAINED, CHISELED));
        }
    }

    @Override
    public class_2586 build(class_1937 level, int[] bits, class_2338 pos) {
        return this.build(level, bits, pos, null);
    }

    @Override
    public class_2586 build(class_1937 level, int[] bits, class_2338 pos, boolean[] yLevelHasUpdates) {
        ChiselBitsAPIFabric.initHolo(level);
        class_2680 above = level.method_8320(pos);
        class_2586 aboveBe = level.method_8321(pos);
        boolean aboveIsAir = above.equals(class_2246.field_10124.method_9564());
        boolean aboveIsChiseled = aboveBe instanceof IMultiStateBlockEntity;
        if (!aboveIsAir && !aboveIsChiseled) {
            return null;
        }
        ChiselAdaptingWorldMutator mutator = new ChiselAdaptingWorldMutator((class_1936)level, pos);
        try (IBatchMutation m = mutator.batch();){
            AtomicInteger i = new AtomicInteger(0);
            for (int y = 0; y < 16; ++y) {
                if (yLevelHasUpdates != null && !yLevelHasUpdates[y]) continue;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (bits[ISatelliteDisplayBE.getCachePos(x, y, z)] == 0) {
                            mutator.clearInAreaTarget(ISatelliteDisplayBE.get3Dpos(x, y, z));
                            continue;
                        }
                        mutator.overrideInAreaTarget(HOLO_BLOCKS[bits[ISatelliteDisplayBE.getCachePos(x, y, z)]], ISatelliteDisplayBE.get3Dpos(x, y, z));
                    }
                }
                if (yLevelHasUpdates == null) continue;
                yLevelHasUpdates[y] = false;
            }
        }
        catch (Exception e) {
            LoggerProject.logError("100003", "Error placing chiseled block at " + pos + ": " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        return level.method_8321(pos);
    }

    @Override
    public void clear(class_1937 level, class_2338 pos) {
        this.clear(level, pos, -1);
    }

    @Override
    public void clear(class_1937 level, class_2338 pos, int yLevel) {
        class_2586 blockEntity = level.method_8321(pos);
        if (yLevel < 0 || yLevel > 15) {
            level.method_8544(pos);
            level.method_8652(pos, class_2246.field_10124.method_9564(), 11);
        } else if (!(blockEntity instanceof ChiseledBlockEntity)) {
            level.method_8652(pos, class_2246.field_10124.method_9564(), 11);
            level.method_8544(pos);
        } else {
            ChiselAdaptingWorldMutator mutator = new ChiselAdaptingWorldMutator((class_1936)level, pos);
            try (IBatchMutation m = mutator.batch();){
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        mutator.clearInAreaTarget(ISatelliteDisplayBE.get3Dpos(x, yLevel, z));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void update(ChunkDisplayInfo info, int[] bits, List<HBUtil.TripleInt> updates, class_2338 pos) {
    }

    @Override
    public void offset(ChunkDisplayInfo info, int[] bits, List<int[][][]> adj, HBUtil.TripleInt offset, class_2338 pos) {
    }

    @Override
    public boolean isChiseledBlock(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        if (!(state.method_26204() instanceof ChiseledBlock)) {
            return false;
        }
        class_2586 be = level.method_8321(pos);
        return be instanceof IMultiStateBlockEntity;
    }

    @Override
    public boolean isViewingHoloBit(class_1937 level, class_3965 hitResult, class_243 offset) {
        class_243 target = hitResult.method_17784().method_1019(offset);
        class_2338 blockPos = new class_2338((int)Math.floor(target.field_1352), (int)Math.floor(target.field_1351), (int)Math.floor(target.field_1350));
        return this.isViewingHoloBlock(level, blockPos, target);
    }

    @Override
    public boolean isViewingHoloBlock(class_1937 level, class_2338 pos, class_243 loc) {
        class_2680 state = level.method_8320(pos);
        if (!(state.method_26204() instanceof ChiseledBlock)) {
            return false;
        }
        class_2586 be = level.method_8321(pos);
        if (!(be instanceof IMultiStateBlockEntity)) {
            return false;
        }
        IMultiStateBlockEntity cbe = (IMultiStateBlockEntity)be;
        class_243 target = ChiselBitsAPI.clamp(loc, pos);
        if (!cbe.isInside(target)) {
            return false;
        }
        class_2680 internalState = ((IStateEntryInfo)cbe.getInAreaTarget(target).get()).getBlockInformation().getBlockState();
        return internalState.method_26204() instanceof HoloBlock;
    }

    @Override
    public boolean isViewingHoloBlock(class_1937 level, class_3965 hitResult) {
        class_2338 pos = hitResult.method_17777();
        class_243 loc = hitResult.method_17784();
        return this.isViewingHoloBlock(level, pos, loc);
    }
}

