/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation;

import com.holybuckets.foundation.Constants;
import com.holybuckets.foundation.FoundationInitializers;
import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.LoggerBase;
import com.holybuckets.foundation.block.ModBlocks;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.event.custom.ClientInputEvent;
import com.holybuckets.foundation.event.custom.ServerTickEvent;
import com.holybuckets.foundation.model.ManagedChunk;
import com.holybuckets.foundation.model.ManagedChunkUtility;
import com.holybuckets.foundation.platform.Services;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.blay09.mods.balm.api.event.ChunkLoadingEvent;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.event.TossItemEvent;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import org.apache.commons.lang3.tuple.Pair;

public class CommonClass {
    public static boolean isInitialized = false;
    public static final ThreadPoolExecutor POOL = new ThreadPoolExecutor(2, 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public static void init() {
        Constants.LOG.info("Loaded {} mod on {}! we are currently in a {} environment!", new Object[]{"HB's Foundation", Services.PLATFORM.getPlatformName(), Services.PLATFORM.getEnvironmentName()});
        if (Services.PLATFORM.isModLoaded("hbs_foundation")) {
            Constants.LOG.info("Hello to HB's Foundation!");
        }
        FoundationInitializers.init();
        isInitialized = true;
    }

    public static void test(EventRegistrar reg) {
    }

    private static void onTossItem(TossItemEvent event) {
        LoggerBase.logInfo(null, "001200", "Player Tossed Item Event - Item: " + event.getItemStack().method_7909().method_7876() + " Qty: " + event.getItemStack().method_7947());
    }

    private static void on120Ticks(ServerTickEvent event) {
        GeneralConfig config = GeneralConfig.getInstance();
        LoggerBase.logDebug(null, "001090", "Server ticks: " + config.getTotalTickCount());
        LoggerBase.logDebug(null, "001091", "Overworld ticks: " + config.getTotalTickCountWithSleep((class_1937)GeneralConfig.OVERWORLD));
        LoggerBase.logDebug(null, "001092", "Nether ticks: " + config.getTotalTickCountWithSleep((class_1937)GeneralConfig.NETHER));
    }

    private static void onDailyTick(ServerTickEvent.DailyTickEvent event) {
        LoggerBase.logDebug(null, "001100", "Daily tick: " + event.getLevel().method_27983().method_29177());
        LoggerBase.logDebug(null, "001100", "Daily tick: " + event.getTickCountWithSleeps());
        LoggerBase.logDebug(null, "001100", "Daily tick: " + event.isTriggeredByWakeUp());
    }

    private static void onClientInput(ClientInputEvent event) {
        LoggerBase.logInfo(null, "001001", "Client Input Event - Keys pressed: " + event.getKeyCodes());
    }

    private static void onPlayerLogin(PlayerLoginEvent event) {
        Constants.LOG.info("Player connected CONNECTED: " + event.getPlayer().method_7334().getName());
    }

    static void onServerTick(ServerTickEvent event) {
        Constants.LOG.info("Server ticked: " + event.getTickCount());
    }

    private static void onPlayerLoad(PlayerLoginEvent event) {
        Constants.LOG.info("Player loaded: " + event.getPlayer().method_7334().getName());
    }

    public static void onChunkLoad(ChunkLoadingEvent.Load event) {
        if (event.getLevel().method_8608()) {
            return;
        }
        String id = HBUtil.ChunkUtil.getId(event.getChunk().method_12004().method_8323());
        String chunkId = HBUtil.ChunkUtil.getId(event.getChunk());
        if (!chunkId.equals("0,0")) {
            return;
        }
        Constants.LOG.info("Chunk loaded: " + id + " " + chunkId + " MATCH: " + id.equals(chunkId));
        POOL.submit(() -> CommonClass.threadAddChunkBlock(event));
    }

    public static void threadAddChunkBlock(ChunkLoadingEvent.Load event) {
        class_2680 GOLDSTATE = class_2246.field_29029.method_9564();
        class_2248 GOLD = ModBlocks.empty;
        ArrayList blocks = new ArrayList();
        class_2791 c = event.getChunk();
        class_2338 p = c.method_12004().method_8323();
        class_1936 level = event.getLevel();
        ManagedChunkUtility util = ManagedChunkUtility.getInstance(level);
        while (!util.isChunkFullyLoaded(c.method_12004())) {
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ArrayList<Pair<class_2680, class_2338>> blockStateList = new ArrayList<Pair<class_2680, class_2338>>();
        LoggerBase.logInfo(null, "999000", "Added blocks to chunk: " + p);
        ManagedChunk.updateChunkBlockStates(level, blockStateList);
        class_2338 p1 = new class_2338(0, 0, 0);
        class_2338 p2 = new class_2338(0, 15, 0);
        class_2338 p2a = new class_2338(0, 16, 0);
        class_2338 p2b = new class_2338(0, -15, 0);
        class_2338 p2c = new class_2338(0, -16, 0);
        class_2338 p2d = new class_2338(0, -17, 0);
        class_2338 p3 = new class_2338(0, -64, 0);
        HBUtil.WorldPos wp1 = new HBUtil.WorldPos(p1, c);
        HBUtil.WorldPos wp2 = new HBUtil.WorldPos(p2, c);
        HBUtil.WorldPos wp2a = new HBUtil.WorldPos(p2a, c);
        HBUtil.WorldPos wp2b = new HBUtil.WorldPos(p2b, c);
        HBUtil.WorldPos wp2c = new HBUtil.WorldPos(p2c, c);
        HBUtil.WorldPos wp2d = new HBUtil.WorldPos(p2d, c);
        HBUtil.WorldPos wp3 = new HBUtil.WorldPos(p3, c);
        Constants.LOG.info("WorldPos: " + wp1 + " " + wp1.worldPosToString() + " " + wp1.sectionToString());
        Constants.LOG.info("WorldPos: " + wp2 + " " + wp2.worldPosToString() + " " + wp2.sectionToString());
        Constants.LOG.info("WorldPos: " + wp2a + " " + wp2a.worldPosToString() + " " + wp2a.sectionToString());
        Constants.LOG.info("WorldPos: " + wp2b + " " + wp2b.worldPosToString() + " " + wp2b.sectionToString());
        Constants.LOG.info("WorldPos: " + wp2c + " " + wp2c.worldPosToString() + " " + wp2c.sectionToString());
        Constants.LOG.info("WorldPos: " + wp2d + " " + wp2d.worldPosToString() + " " + wp2d.sectionToString());
        Constants.LOG.info("WorldPos: " + wp3 + " " + wp3.worldPosToString() + " " + wp3.sectionToString());
    }

    public static void onLevelLoad(LevelLoadingEvent event) {
        if (event.getLevel().method_8608()) {
            return;
        }
        Constants.LOG.info("Level loaded: " + ((class_3218)event.getLevel()).method_44013());
    }
}

