/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.LoggerBase;
import com.holybuckets.foundation.config.PerformanceImpactConfig;
import com.holybuckets.foundation.datastore.DataStore;
import com.holybuckets.foundation.datastore.LevelSaveData;
import com.holybuckets.foundation.datastore.WorldSaveData;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.event.custom.ServerTickEvent;
import com.holybuckets.foundation.event.custom.TickType;
import com.holybuckets.foundation.event.custom.WakeUpAllPlayersEvent;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5217;
import net.minecraft.server.MinecraftServer;

public class GeneralConfig {
    public static final String CLASS_ID = "000";
    public static final Gson GSON = new Gson();
    private static GeneralConfig instance;
    private DataStore dataStore;
    private volatile boolean running = true;
    private boolean isClientSide;
    private boolean isServerSide;
    private MinecraftServer server;
    private final Map<String, class_1937> LEVELS;
    private Map<class_1937, class_2382> WORLD_SPAWNS;
    private Long worldSeed;
    private boolean isWorldConfigInit;
    private Boolean isPlayerLoaded;
    private PerformanceImpactConfig performanceImpactConfig;
    public static final class_2960 OVERWORLD_LOC;
    public static final class_2960 NETHER_LOC;
    public static final class_2960 END_LOC;
    public static class_3218 OVERWORLD;
    public static class_3218 NETHER;
    public static class_3218 END;
    public static long TICKS_PER_DAY;

    private GeneralConfig() {
        instance = this;
        LoggerBase.logInit(null, "000000", this.getClass().getName());
        this.isClientSide = false;
        this.isPlayerLoaded = false;
        this.LEVELS = new HashMap<String, class_1937>();
        this.WORLD_SPAWNS = new HashMap<class_1937, class_2382>();
        this.running = true;
        this.isWorldConfigInit = false;
    }

    public static void init(EventRegistrar reg) {
        if (instance != null) {
            return;
        }
        instance = new GeneralConfig();
        GeneralConfig.instance.dataStore = DataStore.init();
        reg.registerOnServerTick(TickType.ON_1200_TICKS, instance::on1200Ticks, EventPriority.Lowest);
    }

    public static void fireEvent(Class<?> eventClass, Object event) {
        if (instance == null) {
            LoggerBase.logError(null, "000001", "GeneralConfig not initialized, cannot fire event: " + eventClass.getName());
            return;
        }
        if (eventClass.equals(WakeUpAllPlayersEvent.class)) {
            instance.onWakeUpAllPlayers((WakeUpAllPlayersEvent)event);
        }
        if (eventClass.equals(ServerTickEvent.DailyTickEvent.class)) {
            instance.onDailyTick((ServerTickEvent.DailyTickEvent)event);
        }
        if (eventClass.equals(ServerStartingEvent.class)) {
            instance.onBeforeServerStarted((ServerStartingEvent)event);
        }
        if (eventClass.equals(ServerStoppedEvent.class)) {
            instance.onServerStopped((ServerStoppedEvent)event);
        }
        if (eventClass.equals(LevelLoadingEvent.Load.class)) {
            instance.onLevelLoad((LevelLoadingEvent.Load)event);
        }
        if (eventClass.equals(LevelLoadingEvent.Unload.class)) {
            instance.onLevelUnload((LevelLoadingEvent.Unload)event);
        }
    }

    private void onWakeUpAllPlayers(WakeUpAllPlayersEvent event) {
        LevelSaveData lsd = this.dataStore.getOrCreateLevelSaveData("hbs_foundation", (class_1937)event.getLevel());
        lsd.addProperty("totalSleeps", (JsonElement)new JsonPrimitive((Number)event.getTotalSleeps()));
    }

    private void onDailyTick(ServerTickEvent.DailyTickEvent event) {
        if (event.getLevel() != null) {
            class_1937 level = event.getLevel();
            LevelSaveData lsd = this.dataStore.getOrCreateLevelSaveData("hbs_foundation", level);
            long dayTickLength = level.method_8597().comp_641().orElse(TICKS_PER_DAY);
            long nextDailyTick = event.getTickCount() + dayTickLength;
            int totalDays = this.getTotalDays(level) + 1;
            lsd.addProperty("totalDays", (JsonElement)new JsonPrimitive((Number)totalDays));
            lsd.addProperty("nextDailyTick", (JsonElement)new JsonPrimitive((Number)nextDailyTick));
            long sleepTicks = this.getTotalTickCountWithSleep(level);
            lsd.addProperty("totalTicksWithSleep", (JsonElement)new JsonPrimitive((Number)sleepTicks));
        }
        this.saveData(event.getLevel());
        EventRegistrar.getInstance().dataSaveEvent(false);
    }

    private void on1200Ticks(ServerTickEvent event) {
        this.saveData(null);
        EventRegistrar.getInstance().dataSaveEvent(true);
    }

    private void saveData(class_1937 level) {
        WorldSaveData worldData = this.dataStore.getOrCreateWorldSaveData("hbs_foundation");
        Long currentTicks = this.getTotalTickCount();
        worldData.addProperty("totalTicks", (JsonElement)new JsonPrimitive((Number)currentTicks));
        if (level == null) {
            return;
        }
        LevelSaveData lsd = this.dataStore.getOrCreateLevelSaveData("hbs_foundation", level);
        long sleepTicks = this.getTotalTickCountWithSleep(level);
        lsd.addProperty("totalTicksWithSleep", (JsonElement)new JsonPrimitive((Number)sleepTicks));
    }

    private void initPerformanceConfig() {
        this.performanceImpactConfig = new PerformanceImpactConfig();
    }

    public static GeneralConfig getInstance() {
        return instance;
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public Map<String, class_1937> getLevels() {
        return new HashMap<String, class_1937>(this.LEVELS);
    }

    public void onBeforeServerStarted(ServerStartingEvent event) {
        this.isServerSide = true;
        this.initPerformanceConfig();
        if (this.server == null) {
            this.server = event.getServer();
        }
        if (!this.isWorldConfigInit) {
            this.worldSeed = this.server.method_27728().method_28057().method_28028();
            if (this.worldSeed != null) {
                this.isWorldConfigInit = true;
                LoggerBase.logInfo(null, "010001", "World Seed: " + this.worldSeed);
            }
        }
        this.dataStore.onBeforeServerStarted(event);
    }

    public void onServerStopped(ServerStoppedEvent event) {
        if (this.dataStore == null) {
            return;
        }
        this.dataStore.onServerStopped(event);
        this.server = null;
        this.isClientSide = false;
        this.isServerSide = false;
    }

    public void onLevelLoad(LevelLoadingEvent.Load event) {
        class_1937 level = (class_1937)event.getLevel();
        this.LEVELS.put(HBUtil.LevelUtil.toLevelId((class_1936)level), level);
        class_5217 data = level.method_8401();
        class_2338 spawn = new class_2338(data.method_215(), data.method_144(), data.method_166());
        this.WORLD_SPAWNS.put(level, (class_2382)spawn);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            this.isServerSide = true;
            if (HBUtil.LevelUtil.testLevel(level, OVERWORLD_LOC)) {
                OVERWORLD = serverLevel;
            } else if (HBUtil.LevelUtil.testLevel(level, NETHER_LOC)) {
                NETHER = serverLevel;
            } else if (HBUtil.LevelUtil.testLevel(level, END_LOC)) {
                END = serverLevel;
            }
            LevelSaveData lsd = this.dataStore.getOrCreateLevelSaveData("hbs_foundation", level);
            WorldSaveData worldData = this.dataStore.getOrCreateWorldSaveData("hbs_foundation");
            LevelSaveData.validate(lsd, worldData);
        }
        if (level.method_8608()) {
            this.isClientSide = true;
        }
    }

    public void onLevelUnload(LevelLoadingEvent.Unload event) {
        if (event.getLevel().method_8608()) {
            return;
        }
    }

    public boolean isWorldConfigInit() {
        return this.isWorldConfigInit;
    }

    @Nullable
    class_1936 getLevel(String id) {
        if (this.LEVELS == null) {
            return null;
        }
        class_1936 level = (class_1936)this.LEVELS.get(id);
        if (level == null) {
            return null;
        }
        return level;
    }

    public Long getWorldSeed() {
        return this.worldSeed;
    }

    public class_2382 getWorldSpawn(class_1936 level) {
        return this.WORLD_SPAWNS.get(level);
    }

    public Boolean getIsPLAYER_LOADED() {
        return this.isPlayerLoaded;
    }

    public boolean isClientSide() {
        return this.isClientSide;
    }

    public boolean isServerSide() {
        return this.isServerSide;
    }

    public boolean isIntegrated() {
        return this.isServerSide && this.isClientSide;
    }

    @Nullable
    public MinecraftServer getServer() {
        return this.server;
    }

    public long getTotalTickCount() {
        if (this.isServerSide) {
            GeneralConfig generalConfig = this;
            return generalConfig.dataStore.getTotalTicksFromPreviousSession() + (long)this.server.method_3780();
        }
        return 0L;
    }

    public long getTotalTickCountWithSleep(class_1937 level) {
        int totalDays = this.getTotalDays(level);
        long dayTickLength = level.method_8597().comp_641().orElse(TICKS_PER_DAY) + 1L;
        return dayTickLength * (long)totalDays + level.method_8532() % dayTickLength;
    }

    public long getSessionTickCount() {
        if (this.isServerSide) {
            return this.server.method_3780();
        }
        return -1L;
    }

    public int getTotalSleeps(class_1937 level) {
        LevelSaveData lsd = this.dataStore.getOrCreateLevelSaveData("hbs_foundation", level);
        return lsd.get("totalSleeps").getAsInt();
    }

    public int getTotalDays(class_1937 level) {
        LevelSaveData lsd = this.dataStore.getOrCreateLevelSaveData("hbs_foundation", level);
        return lsd.get("totalDays").getAsInt();
    }

    public long getNextDailyTick(class_1937 level) {
        LevelSaveData lsd = this.dataStore.getOrCreateLevelSaveData("hbs_foundation", level);
        return lsd.get("nextDailyTick").getAsLong();
    }

    public PerformanceImpactConfig getPerformanceImpactConfig() {
        if (this.performanceImpactConfig == null) {
            this.initPerformanceConfig();
        }
        return this.performanceImpactConfig;
    }

    static {
        OVERWORLD_LOC = new class_2960("minecraft", "overworld");
        NETHER_LOC = new class_2960("minecraft", "the_nether");
        END_LOC = new class_2960("minecraft", "the_end");
        TICKS_PER_DAY = 24000L;
    }
}

