/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.client;

import com.holybuckets.foundation.client.ClientEventRegistrar;
import com.holybuckets.foundation.datastructure.ConcurrentSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.client.BlockHighlightDrawEvent;
import net.blay09.mods.balm.api.event.client.ClientStartedEvent;
import net.blay09.mods.balm.api.event.client.ConnectedToServerEvent;
import net.blay09.mods.balm.api.event.client.DisconnectedFromServerEvent;

public class ClientBalmEventRegister {
    private static final Set<Integer> registeredEvents = new ConcurrentSet<Integer>();
    private static ClientEventRegistrar events;

    private static boolean notRegistered(Consumer<?> c) {
        return c != null && !registeredEvents.contains(c.hashCode());
    }

    public static EventPriority p(Consumer<?> func) {
        return ClientBalmEventRegister.events.PRIORITIES.getOrDefault(func.hashCode(), EventPriority.Normal);
    }

    public static void registerEvents() {
        BalmEvents registry = Balm.getEvents();
        events = ClientEventRegistrar.getInstance();
        ClientBalmEventRegister.events.ON_CLIENT_STARTED_EVENT.stream().filter(ClientBalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(ClientStartedEvent.class, c, ClientBalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        ClientBalmEventRegister.events.ON_CONNECTED_TO_SERVER.stream().filter(ClientBalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(ConnectedToServerEvent.class, c, ClientBalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        ClientBalmEventRegister.events.ON_DISCONNECTED_FROM_SERVER.stream().filter(ClientBalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(DisconnectedFromServerEvent.class, c, ClientBalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        ClientBalmEventRegister.events.ON_BLOCK_HIGHLIGHT_DRAW.stream().filter(ClientBalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(BlockHighlightDrawEvent.class, c, ClientBalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
    }

    static void registerClientTickEvents() {
        BalmEvents registry = Balm.getEvents();
        if (registeredEvents.add(Objects.hash("onClientTick"))) {
            registry.onTickEvent(TickType.Client, TickPhase.End, events::onClientTick);
        }
        if (registeredEvents.add(Objects.hash("onClientLevelTick"))) {
            registry.onTickEvent(TickType.ClientLevel, TickPhase.Start, events::onClientLevelTick);
        }
    }
}

