/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.holybuckets.foundation.LoggerBase;
import com.holybuckets.foundation.client.ClientBalmEventRegister;
import com.holybuckets.foundation.datastructure.ConcurrentSet;
import com.holybuckets.foundation.event.custom.ClientInputEvent;
import com.holybuckets.foundation.event.custom.ClientLevelTickEvent;
import com.holybuckets.foundation.event.custom.ClientTickEvent;
import com.holybuckets.foundation.event.custom.SimpleMessageEvent;
import com.holybuckets.foundation.event.custom.TickType;
import com.holybuckets.foundation.model.ManagedChunkEvents;
import com.holybuckets.foundation.networking.ClientInputMessage;
import com.holybuckets.foundation.networking.SimpleStringMessage;
import com.holybuckets.foundation.util.MixinManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.client.BlockHighlightDrawEvent;
import net.blay09.mods.balm.api.event.client.ClientStartedEvent;
import net.blay09.mods.balm.api.event.client.ConnectedToServerEvent;
import net.blay09.mods.balm.api.event.client.DisconnectedFromServerEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_310;

public class ClientEventRegistrar {
    public static final String CLASS_ID = "010";
    private static ClientEventRegistrar instance;
    final Map<Integer, EventPriority> PRIORITIES = new HashMap<Integer, EventPriority>();
    final Set<Consumer<ClientStartedEvent>> ON_CLIENT_STARTED_EVENT = new ConcurrentSet<Consumer<ClientStartedEvent>>();
    final Set<Consumer<ConnectedToServerEvent>> ON_CONNECTED_TO_SERVER = new ConcurrentSet<Consumer<ConnectedToServerEvent>>();
    final Set<Consumer<DisconnectedFromServerEvent>> ON_DISCONNECTED_FROM_SERVER = new ConcurrentSet<Consumer<DisconnectedFromServerEvent>>();
    final Set<Consumer<ServerStartingEvent>> ON_BEFORE_SERVER_START = new ConcurrentSet<Consumer<ServerStartingEvent>>();
    final Set<Consumer<ServerStoppedEvent>> ON_SERVER_STOP = new ConcurrentSet<Consumer<ServerStoppedEvent>>();
    final Map<TickScheme, Consumer<?>> CLIENT_TICK_EVENTS = new ConcurrentHashMap();
    final Map<TickScheme, Consumer<?>> CLIENT_LEVEL_TICK_EVENTS = new ConcurrentHashMap();
    final Set<Consumer<ClientInputEvent>> ON_CLIENT_INPUT = new ConcurrentSet<Consumer<ClientInputEvent>>();
    final Multimap<String, Consumer<SimpleMessageEvent>> ON_SIMPLE_MESSAGE = HashMultimap.create();
    private int ticks = 0;
    final Set<Consumer<BlockHighlightDrawEvent>> ON_BLOCK_HIGHLIGHT_DRAW = new ConcurrentSet<Consumer<BlockHighlightDrawEvent>>();

    private ClientEventRegistrar() {
        LoggerBase.logInit(null, "010000", this.getClass().getName());
        this.ticks = 0;
        instance = this;
    }

    public static ClientEventRegistrar getInstance() {
        if (instance == null) {
            ClientEventRegistrar.init();
        }
        return instance;
    }

    private static void init() {
        instance = new ClientEventRegistrar();
        instance.registerOnClientStarted(ClientEventRegistrar::registerOnClientStarted);
    }

    private static void registerOnClientStarted(ClientStartedEvent event) {
        ClientBalmEventRegister.registerClientTickEvents();
    }

    private <T> void generalRegister(Consumer<T> function, Set<Consumer<T>> set, EventPriority priority) {
        set.add(function);
        this.PRIORITIES.put(function.hashCode(), priority);
    }

    public void registerOnBlockHighlightDraw(Consumer<BlockHighlightDrawEvent> function) {
        this.registerOnBlockHighlightDraw(function, EventPriority.Normal);
    }

    public void registerOnBlockHighlightDraw(Consumer<BlockHighlightDrawEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_BLOCK_HIGHLIGHT_DRAW, priority);
    }

    public void registerOnClientStarted(Consumer<ClientStartedEvent> function) {
        this.registerOnClientStarted(function, EventPriority.Normal);
    }

    public void registerOnClientStarted(Consumer<ClientStartedEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_CLIENT_STARTED_EVENT, priority);
    }

    public void registerOnConnectedToServer(Consumer<ConnectedToServerEvent> function) {
        this.registerOnConnectedToServer(function, EventPriority.Normal);
    }

    public void registerOnConnectedToServer(Consumer<ConnectedToServerEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_CONNECTED_TO_SERVER, priority);
    }

    public void registerOnDisconnectedFromServer(Consumer<DisconnectedFromServerEvent> function) {
        this.registerOnDisconnectedFromServer(function, EventPriority.Normal);
    }

    public void registerOnDisconnectedFromServer(Consumer<DisconnectedFromServerEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_DISCONNECTED_FROM_SERVER, priority);
    }

    public void registerOnBeforeServerStart(Consumer<ServerStartingEvent> function) {
        this.registerOnBeforeServerStart(function, EventPriority.Normal);
    }

    public void registerOnBeforeServerStart(Consumer<ServerStartingEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_BEFORE_SERVER_START, priority);
    }

    public void registerOnServerStop(Consumer<ServerStoppedEvent> function) {
        this.registerOnServerStop(function, EventPriority.Normal);
    }

    public void registerOnServerStop(Consumer<ServerStoppedEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_SERVER_STOP, priority);
    }

    public void registerOnClientInput(Consumer<ClientInputEvent> function) {
        this.registerOnClientInput(function, EventPriority.Normal);
    }

    public void registerOnClientInput(Consumer<ClientInputEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_CLIENT_INPUT, priority);
    }

    public void registerOnSimpleMessage(String messageId, Consumer<SimpleMessageEvent> function) {
        this.registerOnSimpleMessage(messageId, function, EventPriority.Normal);
    }

    public void registerOnSimpleMessage(String messageId, Consumer<SimpleMessageEvent> function, EventPriority priority) {
        this.ON_SIMPLE_MESSAGE.put((Object)messageId, function);
        this.PRIORITIES.put(function.hashCode(), priority);
    }

    private void generalTickEventRegister(Consumer<?> function, Map<TickScheme, Consumer<?>> map, TickType type, EventPriority priority) {
        TickScheme scheme = new TickScheme(function, type);
        map.put(scheme, function);
        this.PRIORITIES.put(function.hashCode(), priority);
    }

    public <T extends ClientTickEvent> void registerOnClientTick(TickType type, Consumer<T> function) {
        this.registerOnClientTick(type, function, EventPriority.Normal);
    }

    public <T extends ClientTickEvent> void registerOnClientTick(TickType type, Consumer<T> function, EventPriority priority) {
        this.generalTickEventRegister(function, this.CLIENT_TICK_EVENTS, type, priority);
    }

    public <T extends ClientLevelTickEvent> void registerOnClientLevelTick(TickType type, Consumer<T> function) {
        this.registerOnClientLevelTick(type, function, EventPriority.Normal);
    }

    public <T extends ClientLevelTickEvent> void registerOnClientLevelTick(TickType type, Consumer<T> function, EventPriority priority) {
        this.generalTickEventRegister(function, this.CLIENT_LEVEL_TICK_EVENTS, type, priority);
    }

    public void onClientTick(class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        ClientTickEvent event = new ClientTickEvent(this.ticks++);
        this.CLIENT_TICK_EVENTS.forEach((scheme, consumer) -> {
            if (this.ticks % scheme.getFrequency() == scheme.offset) {
                this.tryEvent((Consumer)consumer, (Object)event);
            }
        });
    }

    public void onClientLevelTick(class_1937 level) {
        if (level == null) {
            return;
        }
        long totalTicks = level.method_8532();
        ClientLevelTickEvent event = new ClientLevelTickEvent(level, totalTicks);
        ManagedChunkEvents.onWorldTickStart(level);
        this.CLIENT_LEVEL_TICK_EVENTS.forEach((scheme, consumer) -> {
            if (totalTicks % (long)scheme.getFrequency() == (long)scheme.offset) {
                this.tryEvent((Consumer)consumer, (Object)event);
            }
        });
    }

    public void onClientInput(ClientInputMessage message) {
        class_1657 p = Balm.getProxy().getClientPlayer();
        ClientInputEvent event = new ClientInputEvent(p, message);
        this.ON_CLIENT_INPUT.forEach(consumer -> this.tryEvent((Consumer)consumer, (Object)event));
    }

    public void onSimpleMessage(class_1657 player, SimpleStringMessage message, String messageId) {
        SimpleMessageEvent event = new SimpleMessageEvent(player, message, messageId);
        Collection consumers = this.ON_SIMPLE_MESSAGE.get((Object)messageId);
        List sortedConsumers = consumers.stream().sorted((a, b) -> this.PRIORITIES.get(b.hashCode()).compareTo((Enum)this.PRIORITIES.get(a.hashCode()))).toList();
        for (Consumer consumer : sortedConsumers) {
            this.tryEvent(consumer, event);
        }
    }

    private <T> void tryEvent(Consumer<T> consumer, T event) {
        String id = consumer.toString() + "::" + event.getClass().getName();
        if (MixinManager.isEnabled(consumer.toString())) {
            try {
                consumer.accept(event);
            }
            catch (Exception e) {
                MixinManager.recordError(id, e);
            }
        }
    }

    private class TickScheme {
        int offset;
        TickType frequency;

        <T> TickScheme(Consumer<T> func, TickType frequency) {
            this.frequency = frequency;
            this.offset = func.hashCode() % this.getFrequency();
        }

        int getFrequency() {
            switch (this.frequency) {
                case ON_SINGLE_TICK: {
                    return 1;
                }
                case ON_20_TICKS: {
                    return 20;
                }
                case ON_120_TICKS: {
                    return 120;
                }
                case ON_1200_TICKS: {
                    return 1200;
                }
                case ON_24000_TICKS: {
                    return 24000;
                }
            }
            return 1;
        }
    }
}

