/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.config;

import com.holybuckets.foundation.config.PerformanceImpactConfigData;
import com.holybuckets.foundation.config.PerformanceImpactLevel;
import java.util.concurrent.atomic.AtomicInteger;
import net.blay09.mods.balm.api.Balm;

public class PerformanceImpactConfig {
    public static final String CLASS_ID = "001";
    PerformanceImpactLevel performanceImpactLevel;
    AtomicInteger blockWritesPerTick;

    public static PerformanceImpactConfigData getActive() {
        return (PerformanceImpactConfigData)Balm.getConfig().getActive(PerformanceImpactConfigData.class);
    }

    public static void initialize() {
        Balm.getConfig().registerConfig(PerformanceImpactConfigData.class, null);
    }

    public PerformanceImpactConfig() {
        this(PerformanceImpactLevel.valueOf(PerformanceImpactConfig.getActive().performanceImpactConfig.performanceImpact));
    }

    public PerformanceImpactConfig(PerformanceImpactLevel p) {
        this.performanceImpactLevel = p;
        this.setBlockWritesPerTick(p);
    }

    public void setBlockWritesPerTick(PerformanceImpactLevel p) {
        if (p == null) {
            return;
        }
        if (this.blockWritesPerTick == null) {
            this.blockWritesPerTick = new AtomicInteger(20);
        }
        if (p == PerformanceImpactLevel.VERY_LOW) {
            this.blockWritesPerTick.set(5);
        } else if (p == PerformanceImpactLevel.LOW) {
            this.blockWritesPerTick.set(10);
        } else if (p == PerformanceImpactLevel.MEDIUM) {
            this.blockWritesPerTick.set(20);
        } else if (p == PerformanceImpactLevel.HIGH) {
            this.blockWritesPerTick.set(40);
        } else if (p == PerformanceImpactLevel.VERY_HIGH) {
            this.blockWritesPerTick.set(60);
        }
    }

    public AtomicInteger getBlockWritesPerTick() {
        return this.blockWritesPerTick;
    }
}

