/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.datastore;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.LoggerBase;
import com.holybuckets.foundation.datastore.LevelSaveData;
import com.holybuckets.foundation.datastore.ModSaveData;
import com.holybuckets.foundation.datastore.WorldSaveData;
import com.holybuckets.foundation.modelInterface.IStringSerializable;
import java.io.File;
import java.nio.file.Path;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_32;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class DataStore
implements IStringSerializable {
    private static final String CLASS_ID = "007";
    private static DataStore INSTANCE;
    private static final File DATA_STORE_FILE;
    private final Map<String, ModSaveData> STORE;
    private String currentWorldId;
    private Path currentWorldPath;
    private long totalTickCountFromPreviousSession;

    private DataStore() {
        this.currentWorldId = null;
        this.STORE = new HashMap<String, ModSaveData>();
    }

    public static DataStore init() {
        INSTANCE = new DataStore();
        return INSTANCE;
    }

    private void loadData(Path worldPath) {
        this.currentWorldId = worldPath.getParent().getFileName().toString();
        this.currentWorldPath = worldPath.resolve(DATA_STORE_FILE.toPath());
        String json = HBUtil.FileIO.loadJsonConfigs(this.currentWorldPath.toFile(), DATA_STORE_FILE, new DefaultDataStore());
        this.deserialize(json);
        this.write();
    }

    private DataStore(ModSaveData data) {
        this.STORE = new HashMap<String, ModSaveData>();
        this.STORE.put(data.getModId(), data);
    }

    public ModSaveData getOrCreateModSavedData(String modId) {
        ModSaveData data = this.STORE.getOrDefault(modId, new ModSaveData(modId));
        this.STORE.put(modId, data);
        return data;
    }

    public WorldSaveData getOrCreateWorldSaveData(String modId) {
        ModSaveData modData = this.getOrCreateModSavedData(modId);
        return modData.getOrCreateWorldSaveData(this.currentWorldId);
    }

    public LevelSaveData getOrCreateLevelSaveData(String modId, class_1937 level) {
        WorldSaveData worldData = this.getOrCreateWorldSaveData(modId);
        return worldData.getOrCreateLevelSaveData(level);
    }

    public boolean initWorldDataOnServerStart(ServerStartingEvent event) {
        ModSaveData modData = this.getOrCreateModSavedData("hbs_foundation");
        if (modData.worldSaveData.containsKey(this.currentWorldId)) {
            this.totalTickCountFromPreviousSession = modData.getOrCreateWorldSaveData(this.currentWorldId).get("totalTicks").getAsLong();
            return false;
        }
        GeneralConfig config = GeneralConfig.getInstance();
        while (config == null || !config.isWorldConfigInit()) {
            config = GeneralConfig.getInstance();
        }
        modData.getOrCreateWorldSaveData(this.currentWorldId);
        this.totalTickCountFromPreviousSession = 0L;
        return true;
    }

    private static JsonElement parse(Object o) {
        return JsonParser.parseString((String)GeneralConfig.GSON.toJson(o));
    }

    private void removeDeletedWorldSaveData(class_32 lss) {
        Set worldNames = lss.method_235().comp_731().stream().map(ld -> ld.method_43422()).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        if (worldNames.isEmpty()) {
            return;
        }
        this.STORE.forEach((modId, modData) -> modData.worldSaveData.keySet().removeIf(worldId -> !worldNames.contains(worldId)));
    }

    @Override
    public void deserialize(String jsonString) {
        if (jsonString == null || jsonString.isEmpty()) {
            return;
        }
        String malformedJson = null;
        try {
            JsonParser.parseString((String)jsonString);
        }
        catch (Exception e) {
            StringBuilder error = new StringBuilder();
            error.append("Error parsing JSON data from Datastore, file: ");
            error.append(DATA_STORE_FILE);
            error.append(".  The datastore will be configured with defaults values. Copy the file to save your data. ");
            malformedJson = new String(jsonString);
            jsonString = new DefaultDataStore().serialize();
        }
        try {
            JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
            JsonArray modSaveDataArray = json.getAsJsonArray("modSaveData");
            if (modSaveDataArray == null || !modSaveDataArray.isJsonArray()) {
                throw new JsonParseException("modSaveData is missing or not an array");
            }
            modSaveDataArray.forEach(modSaveData -> {
                ModSaveData data = new ModSaveData(modSaveData.getAsJsonObject());
                this.STORE.put(data.getModId(), data);
            });
        }
        catch (Exception e) {
            malformedJson = jsonString;
            LoggerBase.logError(null, "007011", "Error processing mod save data, entire suspect data written out to hb_datastore.json");
        }
        if (malformedJson != null) {
            ModSaveData utilData = this.STORE.get("hbs_foundation");
            String asString = malformedJson.replace('\"', '\'').replaceAll("\r\n", "");
            utilData.addProperty("malformedJson", DataStore.parse(asString));
            this.write();
        }
    }

    @Override
    public String serialize() {
        JsonObject json = new JsonObject();
        JsonArray modSaveDataArray = new JsonArray();
        this.STORE.forEach((modId, data) -> modSaveDataArray.add((JsonElement)data.toJson()));
        json.add("modSaveData", (JsonElement)modSaveDataArray);
        return json.toString();
    }

    public void write() {
        if (this.currentWorldPath == null) {
            return;
        }
        HBUtil.FileIO.serializeJsonConfigs(this.currentWorldPath.toFile(), this.serialize());
    }

    public Path getCurrentWorldPath() {
        return this.currentWorldPath;
    }

    public void onBeforeServerStarted(ServerStartingEvent event) {
        MinecraftServer s = event.getServer();
        Path path = s.method_27050(class_5218.field_24188);
        this.loadData(path);
        this.initWorldDataOnServerStart(event);
    }

    public void onServerStopped(ServerStoppedEvent s) {
        this.shutdown(s);
    }

    public void shutdown(ServerStoppedEvent s) {
        try {
            WorldSaveData worldData = this.getOrCreateWorldSaveData("hbs_foundation");
            Long currentTicks = GeneralConfig.getInstance().getTotalTickCount();
            worldData.addProperty("totalTicks", DataStore.parse(currentTicks));
            this.write();
        }
        catch (Exception e) {
            return;
        }
    }

    public static Long getTotalTickCount() {
        ModSaveData modData = INSTANCE.getOrCreateModSavedData("hbs_foundation");
        if (!modData.worldSaveData.containsKey(DataStore.INSTANCE.currentWorldId)) {
            return -1L;
        }
        WorldSaveData worldData = modData.getOrCreateWorldSaveData(DataStore.INSTANCE.currentWorldId);
        return worldData.get("totalTicks").getAsLong();
    }

    public static Long getTotalTicksFromPreviousSession() {
        return DataStore.INSTANCE.totalTickCountFromPreviousSession;
    }

    private static void initLevelSaveData(LevelSaveData lsd, class_1936 l) {
        String id = HBUtil.LevelUtil.toLevelId(l);
        lsd.addProperty("levelId", (JsonElement)new JsonPrimitive(id));
        lsd.addProperty("totalSleeps", (JsonElement)new JsonPrimitive((Number)0));
        lsd.addProperty("totalTicksWithSleep", (JsonElement)new JsonPrimitive((Number)0));
        lsd.addProperty("totalDays", (JsonElement)new JsonPrimitive((Number)0));
        long nextDailyTick = l.method_8597().comp_641().orElse(GeneralConfig.TICKS_PER_DAY);
        lsd.addProperty("nextDailyTick", (JsonElement)new JsonPrimitive((Number)nextDailyTick));
    }

    static {
        DATA_STORE_FILE = new File("hb_datastore.json");
    }

    private class DefaultDataStore
    extends DataStore
    implements IStringSerializable {
        public static final ModSaveData DATA = new ModSaveData("hbs_foundation");

        public DefaultDataStore() {
            super(DATA);
        }

        @Override
        public String serialize() {
            return super.serialize();
        }

        @Override
        public void deserialize(String jsonString) {
        }

        static {
            DATA.setComment("The purpose of this JSON file is to store data at the world save file level for supporting HB Utility Foundation mods. This data is not intended to be modified by the user.");
        }
    }
}

