/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.datastore;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.datastore.WorldSaveData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1936;
import net.minecraft.class_1937;

public class LevelSaveData {
    String levelId;
    class_1937 level;
    final Map<String, JsonElement> properties;

    public LevelSaveData(class_1937 level) {
        if (level == null) {
            throw new IllegalArgumentException("Level cannot be null");
        }
        this.level = level;
        this.levelId = HBUtil.LevelUtil.toLevelId((class_1936)level);
        this.properties = new ConcurrentHashMap<String, JsonElement>();
    }

    public LevelSaveData(JsonObject json) {
        this.levelId = json.get("levelId").getAsString();
        this.level = null;
        this.properties = new ConcurrentHashMap<String, JsonElement>();
        this.fromJson(json);
    }

    public class_1936 getLevel() {
        return this.level;
    }

    public void addProperty(String key, JsonElement data) {
        this.properties.put(key, data);
    }

    public JsonElement get(String jsonProperty) {
        return this.properties.get(jsonProperty);
    }

    JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("levelId", this.levelId);
        this.properties.forEach((key, value) -> json.add(key, value));
        return json;
    }

    public void fromJson(JsonObject json) {
        this.properties.clear();
        this.levelId = json.get("levelId").getAsString();
        json.remove("levelId");
        this.properties.putAll(json.asMap());
    }

    public static void validate(LevelSaveData data, WorldSaveData worldData) {
        if (data == null || data.properties == null) {
            return;
        }
        Map<String, JsonElement> props = data.properties;
        if (data.level == null) {
            data.level = HBUtil.LevelUtil.toServerLevel(data.levelId);
        }
        if (data.level == null) {
            return;
        }
        if (!props.containsKey("levelId")) {
            props.put("levelId", (JsonElement)new JsonPrimitive(data.levelId));
        }
        if (!props.containsKey("totalSleeps")) {
            props.put("totalSleeps", (JsonElement)new JsonPrimitive((Number)0));
        }
        if (!props.containsKey("totalTicksWithSleep")) {
            long currentTick = worldData.get("totalTicks").getAsLong();
            props.put("totalTicksWithSleep", (JsonElement)new JsonPrimitive((Number)currentTick));
        }
        if (!props.containsKey("nextDailyTick")) {
            long nextDailyTick = data.level.method_8597().comp_641().orElse(GeneralConfig.TICKS_PER_DAY);
            long currentTick = worldData.get("totalTicks").getAsLong();
            props.put("nextDailyTick", (JsonElement)new JsonPrimitive((Number)(nextDailyTick + currentTick)));
        }
        if (!props.containsKey("totalDays")) {
            long dayLength = data.level.method_8597().comp_641().orElse(GeneralConfig.TICKS_PER_DAY);
            long totalDays = data.level.method_8510() / dayLength;
            props.put("totalDays", (JsonElement)new JsonPrimitive((Number)totalDays));
        }
    }
}

