/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.datastructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentLinkedSet<T>
implements Set<T> {
    private final ConcurrentHashMap<T, Node<T>> map;
    private final Node<T> header;

    public ConcurrentLinkedSet() {
        this.map = new ConcurrentHashMap();
        this.header = new Node<Object>(null, null, null);
        this.header.prev = this.header;
        this.header.next = this.header.prev;
    }

    public ConcurrentLinkedSet(int initialCapacity) {
        this.map = new ConcurrentHashMap(initialCapacity);
        this.header = new Node<Object>(null, null, null);
        this.header.prev = this.header;
        this.header.next = this.header.prev;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Node<T> current;
            private Node<T> lastReturned;
            {
                this.current = ConcurrentLinkedSet.this.header.next;
                this.lastReturned = null;
            }

            @Override
            public boolean hasNext() {
                return this.current != ConcurrentLinkedSet.this.header;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.current;
                this.current = this.current.next;
                return this.lastReturned.element;
            }

            @Override
            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                ConcurrentLinkedSet.this.remove(this.lastReturned.element);
                this.lastReturned = null;
            }
        };
    }

    @Override
    public Object[] toArray() {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : this) {
            list.add(element);
        }
        return list.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : this) {
            list.add(element);
        }
        return list.toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T t) {
        if (this.map.containsKey(t)) {
            return false;
        }
        Node<T> newNode = new Node<T>(t, this.header, this.header.prev);
        Node<T> node = this.header;
        synchronized (node) {
            this.header.prev.next = newNode;
            this.header.prev = newNode;
        }
        this.map.put(t, newNode);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Node<T> node = this.map.remove(o);
        if (node != null) {
            Node<T> node2 = this.header;
            synchronized (node2) {
                node.prev.next = node.next;
                node.next.prev = node.prev;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return ((ConcurrentHashMap.CollectionView)((Object)this.map.keySet())).containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        for (T e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object e : c) {
            if (!this.remove(e)) continue;
            modified = true;
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Node<T> node = this.header;
        synchronized (node) {
            this.header.prev = this.header;
            this.header.next = this.header.prev;
        }
        this.map.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set s = (Set)o;
        return s.size() == this.map.size() && this.containsAll(s);
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (T e : this) {
            if (e == null) continue;
            h += e.hashCode();
        }
        return h;
    }

    private static class Node<T> {
        T element;
        Node<T> next;
        Node<T> prev;

        Node(T element, Node<T> next, Node<T> prev) {
            this.element = element;
            this.next = next;
            this.prev = prev;
        }
    }
}

