/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.event;

import com.holybuckets.foundation.datastructure.ConcurrentSet;
import com.holybuckets.foundation.event.CommandRegistry;
import com.holybuckets.foundation.event.EventRegistrar;
import java.util.Set;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.command.BalmCommands;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.ChunkLoadingEvent;
import net.blay09.mods.balm.api.event.DigSpeedEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.blay09.mods.balm.api.event.LivingDeathEvent;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.blay09.mods.balm.api.event.PlayerChangedDimensionEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.event.PlayerLogoutEvent;
import net.blay09.mods.balm.api.event.PlayerRespawnEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.TossItemEvent;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;

public class BalmEventRegister {
    private static final Set<Integer> registeredEvents = new ConcurrentSet<Integer>();
    private static EventRegistrar registrar;

    private static boolean notRegistered(Consumer<?> c) {
        return !registeredEvents.contains(c.hashCode());
    }

    public static EventPriority p(Consumer<?> func) {
        return BalmEventRegister.registrar.PRIORITIES.getOrDefault(func.hashCode(), EventPriority.Normal);
    }

    public static void registerEvents() {
        BalmEvents registry = Balm.getEvents();
        registrar = EventRegistrar.getInstance();
        BalmEventRegister.registrar.ON_CHUNK_LOAD.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(ChunkLoadingEvent.Load.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.registrar.ON_CHUNK_UNLOAD.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(ChunkLoadingEvent.Unload.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.registrar.ON_PLAYER_LOGIN.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(PlayerLoginEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.registrar.ON_PLAYER_LOGOUT.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(PlayerLogoutEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.registrar.ON_PLAYER_ATTACK.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(PlayerAttackEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.registrar.ON_BLOCK_BROKEN.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(BreakBlockEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.registrar.ON_PLAYER_CHANGED_DIMENSION.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(PlayerChangedDimensionEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.registrar.ON_PLAYER_RESPAWN.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(PlayerRespawnEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.registrar.ON_PLAYER_DEATH.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(LivingDeathEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.registrar.ON_USE_BLOCK.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(UseBlockEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.registrar.ON_PLAYER_ATTACK_EVENT.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(PlayerAttackEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.registrar.ON_DIG_SPEED_EVENT.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(DigSpeedEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.registrar.ON_WAKE_UP_ALL_PLAYERS.stream().filter(BalmEventRegister::notRegistered).forEach(c -> registeredEvents.add(c.hashCode()));
        BalmEventRegister.registrar.ON_TOSS_ITEM.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(TossItemEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
    }

    public static void registerCommands() {
        BalmCommands commands = Balm.getCommands();
        commands.register(CommandRegistry::register);
    }

    static void registerPriorityEvents(EventRegistrar registrar) {
        BalmEvents registry = Balm.getEvents();
        registry.onEvent(ServerStartingEvent.class, registrar::onBeforeServerStarted, EventPriority.Highest);
        registry.onEvent(ServerStartedEvent.class, registrar::onServerStarted, EventPriority.Highest);
        registry.onEvent(ServerStoppedEvent.class, registrar::onServerStopped, EventPriority.Lowest);
        registry.onEvent(LevelLoadingEvent.Load.class, registrar::onLevelLoad, EventPriority.High);
        registry.onEvent(LevelLoadingEvent.Unload.class, registrar::onLevelUnload, EventPriority.Low);
        registry.onTickEvent(TickType.Server, TickPhase.End, registrar::onServerTick);
        registry.onTickEvent(TickType.ServerLevel, TickPhase.Start, registrar::onServerLevelTick);
    }
}

