/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.event;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.LoggerBase;
import com.holybuckets.foundation.datastructure.ConcurrentSet;
import com.holybuckets.foundation.event.BalmEventRegister;
import com.holybuckets.foundation.event.custom.ClientInputEvent;
import com.holybuckets.foundation.event.custom.DatastoreSaveEvent;
import com.holybuckets.foundation.event.custom.ServerTickEvent;
import com.holybuckets.foundation.event.custom.SimpleMessageEvent;
import com.holybuckets.foundation.event.custom.TickType;
import com.holybuckets.foundation.event.custom.WakeUpAllPlayersEvent;
import com.holybuckets.foundation.model.ManagedChunkEvents;
import com.holybuckets.foundation.networking.ClientInputMessage;
import com.holybuckets.foundation.networking.SimpleStringMessage;
import com.holybuckets.foundation.util.MixinManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.ChunkLoadingEvent;
import net.blay09.mods.balm.api.event.DigSpeedEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.blay09.mods.balm.api.event.LivingDeathEvent;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.blay09.mods.balm.api.event.PlayerChangedDimensionEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.event.PlayerLogoutEvent;
import net.blay09.mods.balm.api.event.PlayerRespawnEvent;
import net.blay09.mods.balm.api.event.TossItemEvent;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class EventRegistrar {
    public static final String CLASS_ID = "010";
    private static EventRegistrar instance;
    final Map<Integer, EventPriority> PRIORITIES = new HashMap<Integer, EventPriority>();
    final Set<Consumer<PlayerLoginEvent>> ON_PLAYER_LOGIN = new ConcurrentSet<Consumer<PlayerLoginEvent>>();
    final Set<Consumer<PlayerLogoutEvent>> ON_PLAYER_LOGOUT = new ConcurrentSet<Consumer<PlayerLogoutEvent>>();
    final Set<Consumer<LevelLoadingEvent.Load>> ON_LEVEL_LOAD = new ConcurrentSet<Consumer<LevelLoadingEvent.Load>>();
    final Set<Consumer<LevelLoadingEvent.Unload>> ON_LEVEL_UNLOAD = new ConcurrentSet<Consumer<LevelLoadingEvent.Unload>>();
    final Set<Consumer<ChunkLoadingEvent.Load>> ON_CHUNK_LOAD = new ConcurrentSet<Consumer<ChunkLoadingEvent.Load>>();
    final Set<Consumer<ChunkLoadingEvent.Unload>> ON_CHUNK_UNLOAD = new ConcurrentSet<Consumer<ChunkLoadingEvent.Unload>>();
    final Set<Consumer<ServerStartingEvent>> ON_BEFORE_SERVER_START = new ConcurrentSet<Consumer<ServerStartingEvent>>();
    final Set<Consumer<ServerStartedEvent>> ON_SERVER_START = new ConcurrentSet<Consumer<ServerStartedEvent>>();
    final Set<Consumer<ServerStoppedEvent>> ON_SERVER_STOP = new ConcurrentSet<Consumer<ServerStoppedEvent>>();
    final Map<TickScheme, Consumer<?>> SERVER_TICK_EVENTS = new ConcurrentHashMap();
    final Multimap<class_2960, Consumer<ServerTickEvent.DailyTickEvent>> DAILY_TICK_EVENTS = HashMultimap.create();
    final Set<Consumer<DatastoreSaveEvent>> ON_DATA_SAVE = new ConcurrentSet<Consumer<DatastoreSaveEvent>>();
    final Set<Consumer<PlayerAttackEvent>> ON_PLAYER_ATTACK = new ConcurrentSet<Consumer<PlayerAttackEvent>>();
    final Set<Consumer<BreakBlockEvent>> ON_BLOCK_BROKEN = new ConcurrentSet<Consumer<BreakBlockEvent>>();
    final Set<Consumer<PlayerChangedDimensionEvent>> ON_PLAYER_CHANGED_DIMENSION = new ConcurrentSet<Consumer<PlayerChangedDimensionEvent>>();
    final Set<Consumer<PlayerRespawnEvent>> ON_PLAYER_RESPAWN = new ConcurrentSet<Consumer<PlayerRespawnEvent>>();
    final Set<Consumer<LivingDeathEvent>> ON_PLAYER_DEATH = new ConcurrentSet<Consumer<LivingDeathEvent>>();
    final Set<Consumer<UseBlockEvent>> ON_USE_BLOCK = new ConcurrentSet<Consumer<UseBlockEvent>>();
    final Set<Consumer<PlayerAttackEvent>> ON_PLAYER_ATTACK_EVENT = new ConcurrentSet<Consumer<PlayerAttackEvent>>();
    final Set<Consumer<DigSpeedEvent>> ON_DIG_SPEED_EVENT = new ConcurrentSet<Consumer<DigSpeedEvent>>();
    final Set<Consumer<ClientInputEvent>> ON_CLIENT_INPUT = new ConcurrentSet<Consumer<ClientInputEvent>>();
    final Set<Consumer<WakeUpAllPlayersEvent>> ON_WAKE_UP_ALL_PLAYERS = new ConcurrentSet<Consumer<WakeUpAllPlayersEvent>>();
    final Set<Consumer<TossItemEvent>> ON_TOSS_ITEM = new ConcurrentSet<Consumer<TossItemEvent>>();
    final Multimap<String, Consumer<SimpleMessageEvent>> ON_SIMPLE_MESSAGE = HashMultimap.create();
    private static final class_2960 EMPTY_LOC;

    private EventRegistrar() {
        LoggerBase.logInit(null, "010000", this.getClass().getName());
        instance = this;
    }

    public static EventRegistrar getInstance() {
        return instance;
    }

    public static void init() {
        instance = new EventRegistrar();
        BalmEventRegister.registerPriorityEvents(instance);
    }

    void onBeforeServerStarted(ServerStartingEvent event) {
        List sortedConsumers = this.ON_BEFORE_SERVER_START.stream().sorted((a, b) -> this.PRIORITIES.get(b.hashCode()).compareTo((Enum)this.PRIORITIES.get(a.hashCode()))).toList();
        GeneralConfig.fireEvent(ServerStartingEvent.class, event);
        for (Consumer consumer : sortedConsumers) {
            this.tryEvent(consumer, event);
        }
    }

    void onServerStopped(ServerStoppedEvent event) {
        List sortedConsumers = this.ON_SERVER_STOP.stream().sorted((a, b) -> this.PRIORITIES.get(b.hashCode()).compareTo((Enum)this.PRIORITIES.get(a.hashCode()))).toList();
        for (Consumer consumer : sortedConsumers) {
            this.tryEvent(consumer, event);
        }
        GeneralConfig.fireEvent(ServerStoppedEvent.class, event);
    }

    void onServerStarted(ServerStartedEvent event) {
        List sortedConsumers = this.ON_SERVER_START.stream().sorted((a, b) -> this.PRIORITIES.get(b.hashCode()).compareTo((Enum)this.PRIORITIES.get(a.hashCode()))).toList();
        for (Consumer consumer : sortedConsumers) {
            this.tryEvent(consumer, event);
        }
    }

    void onLevelLoad(LevelLoadingEvent.Load event) {
        List sortedConsumers = this.ON_LEVEL_LOAD.stream().sorted((a, b) -> this.PRIORITIES.get(b.hashCode()).compareTo((Enum)this.PRIORITIES.get(a.hashCode()))).toList();
        GeneralConfig.fireEvent(LevelLoadingEvent.Load.class, event);
        for (Consumer consumer : sortedConsumers) {
            this.tryEvent(consumer, event);
        }
    }

    void onLevelUnload(LevelLoadingEvent.Unload event) {
        List sortedConsumers = this.ON_LEVEL_UNLOAD.stream().sorted((a, b) -> this.PRIORITIES.get(b.hashCode()).compareTo((Enum)this.PRIORITIES.get(a.hashCode()))).toList();
        GeneralConfig.fireEvent(LevelLoadingEvent.Unload.class, event);
        for (Consumer consumer : sortedConsumers) {
            this.tryEvent(consumer, event);
        }
    }

    private <T> void generalRegister(Consumer<T> function, Set<Consumer<T>> set, EventPriority priority) {
        set.add(function);
        this.PRIORITIES.put(function.hashCode(), priority);
    }

    private void generalTickEventRegister(Consumer<?> function, Map<TickScheme, Consumer<?>> map, TickType type, EventPriority priority) {
        TickScheme scheme = new TickScheme(function, type);
        map.put(scheme, function);
        this.PRIORITIES.put(function.hashCode(), priority);
    }

    public void registerOnPlayerLogin(Consumer<PlayerLoginEvent> function) {
        this.registerOnPlayerLogin(function, EventPriority.Normal);
    }

    public void registerOnPlayerLogin(Consumer<PlayerLoginEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_PLAYER_LOGIN, priority);
    }

    public void registerOnPlayerLogout(Consumer<PlayerLogoutEvent> function) {
        this.registerOnPlayerLogout(function, EventPriority.Normal);
    }

    public void registerOnPlayerLogout(Consumer<PlayerLogoutEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_PLAYER_LOGOUT, priority);
    }

    public void registerOnLevelLoad(Consumer<LevelLoadingEvent.Load> function) {
        this.registerOnLevelLoad(function, EventPriority.Normal);
    }

    public void registerOnLevelLoad(Consumer<LevelLoadingEvent.Load> function, EventPriority priority) {
        this.generalRegister(function, this.ON_LEVEL_LOAD, priority);
    }

    public void registerOnLevelUnload(Consumer<LevelLoadingEvent.Unload> function) {
        this.registerOnLevelUnload(function, EventPriority.Normal);
    }

    public void registerOnLevelUnload(Consumer<LevelLoadingEvent.Unload> function, EventPriority priority) {
        this.generalRegister(function, this.ON_LEVEL_UNLOAD, priority);
    }

    public void registerOnChunkLoad(Consumer<ChunkLoadingEvent.Load> function) {
        this.registerOnChunkLoad(function, EventPriority.Normal);
    }

    public void registerOnChunkLoad(Consumer<ChunkLoadingEvent.Load> function, EventPriority priority) {
        this.generalRegister(function, this.ON_CHUNK_LOAD, priority);
    }

    public void registerOnChunkUnload(Consumer<ChunkLoadingEvent.Unload> function) {
        this.registerOnChunkUnload(function, EventPriority.Normal);
    }

    public void registerOnChunkUnload(Consumer<ChunkLoadingEvent.Unload> function, EventPriority priority) {
        this.generalRegister(function, this.ON_CHUNK_UNLOAD, priority);
    }

    public void registerOnBeforeServerStarted(Consumer<ServerStartingEvent> function) {
        this.registerOnBeforeServerStarted(function, EventPriority.Normal);
    }

    public void registerOnBeforeServerStarted(Consumer<ServerStartingEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_BEFORE_SERVER_START, priority);
    }

    public void registerOnServerStarted(Consumer<ServerStartedEvent> function) {
        this.registerOnServerStarted(function, EventPriority.Normal);
    }

    public void registerOnServerStarted(Consumer<ServerStartedEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_SERVER_START, priority);
    }

    public void registerOnServerStopped(Consumer<ServerStoppedEvent> function) {
        this.registerOnServerStopped(function, EventPriority.Normal);
    }

    public void registerOnServerStopped(Consumer<ServerStoppedEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_SERVER_STOP, priority);
    }

    public void registerOnDataSave(Consumer<DatastoreSaveEvent> function) {
        this.registerOnDataSave(function, EventPriority.Normal);
    }

    public void registerOnDataSave(Consumer<DatastoreSaveEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_DATA_SAVE, priority);
    }

    public <T extends ServerTickEvent> void registerOnServerTick(TickType type, Consumer<T> function) {
        this.registerOnServerTick(type, function, EventPriority.Normal);
    }

    public <T extends ServerTickEvent> void registerOnServerTick(TickType type, Consumer<T> function, EventPriority priority) {
        this.generalTickEventRegister(function, this.SERVER_TICK_EVENTS, type, priority);
    }

    public void registerOnDailyTick(class_2960 dimension, Consumer<ServerTickEvent.DailyTickEvent> function) {
        this.registerOnDailyTick(dimension, function, EventPriority.Normal);
    }

    public void registerOnDailyTick(@Nullable class_2960 dimension, Consumer<ServerTickEvent.DailyTickEvent> function, EventPriority priority) {
        class_2960 dimLoc = dimension != null ? dimension : EMPTY_LOC;
        this.DAILY_TICK_EVENTS.put((Object)dimLoc, function);
        this.PRIORITIES.put(function.hashCode(), priority);
    }

    public void registerOnPlayerAttack(Consumer<PlayerAttackEvent> function) {
        this.registerOnPlayerAttack(function, EventPriority.Normal);
    }

    public void registerOnPlayerAttack(Consumer<PlayerAttackEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_PLAYER_ATTACK, priority);
    }

    public void registerOnBreakBlock(Consumer<BreakBlockEvent> function) {
        this.registerOnBreakBlock(function, EventPriority.Normal);
    }

    public void registerOnBreakBlock(Consumer<BreakBlockEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_BLOCK_BROKEN, priority);
    }

    public void registerOnPlayerChangedDimension(Consumer<PlayerChangedDimensionEvent> function) {
        this.registerOnPlayerChangedDimension(function, EventPriority.Normal);
    }

    public void registerOnPlayerChangedDimension(Consumer<PlayerChangedDimensionEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_PLAYER_CHANGED_DIMENSION, priority);
    }

    public void registerOnPlayerRespawn(Consumer<PlayerRespawnEvent> function) {
        this.registerOnPlayerRespawn(function, EventPriority.Normal);
    }

    public void registerOnPlayerRespawn(Consumer<PlayerRespawnEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_PLAYER_RESPAWN, priority);
    }

    public void registerOnPlayerDeath(Consumer<LivingDeathEvent> function) {
        this.registerOnPlayerDeath(function, EventPriority.Normal);
    }

    public void registerOnPlayerDeath(Consumer<LivingDeathEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_PLAYER_DEATH, priority);
    }

    public void registerOnUseBlock(Consumer<UseBlockEvent> function) {
        this.registerOnUseBlock(function, EventPriority.Normal);
    }

    public void registerOnUseBlock(Consumer<UseBlockEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_USE_BLOCK, priority);
    }

    public void registerOnPlayerAttackEvent(Consumer<PlayerAttackEvent> function) {
        this.registerOnPlayerAttackEvent(function, EventPriority.Normal);
    }

    public void registerOnPlayerAttackEvent(Consumer<PlayerAttackEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_PLAYER_ATTACK_EVENT, priority);
    }

    public void registerOnDigSpeedEvent(Consumer<DigSpeedEvent> function) {
        this.registerOnDigSpeedEvent(function, EventPriority.Normal);
    }

    public void registerOnDigSpeedEvent(Consumer<DigSpeedEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_DIG_SPEED_EVENT, priority);
    }

    public void registerOnClientInput(Consumer<ClientInputEvent> function) {
        this.registerOnClientInput(function, EventPriority.Normal);
    }

    public void registerOnClientInput(Consumer<ClientInputEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_CLIENT_INPUT, priority);
    }

    public void registerOnWakeUpAllPlayers(Consumer<WakeUpAllPlayersEvent> function) {
        this.registerOnWakeUpAllPlayers(function, EventPriority.Normal);
    }

    public void registerOnWakeUpAllPlayers(Consumer<WakeUpAllPlayersEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_WAKE_UP_ALL_PLAYERS, priority);
    }

    public void registerOnTossItem(Consumer<TossItemEvent> function) {
        this.registerOnTossItem(function, EventPriority.Normal);
    }

    public void registerOnTossItem(Consumer<TossItemEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_TOSS_ITEM, priority);
    }

    public void registerOnSimpleMessage(String messageId, Consumer<SimpleMessageEvent> function) {
        this.registerOnSimpleMessage(messageId, function, EventPriority.Normal);
    }

    public void registerOnSimpleMessage(String messageId, Consumer<SimpleMessageEvent> function, EventPriority priority) {
        this.ON_SIMPLE_MESSAGE.put((Object)messageId, function);
        this.PRIORITIES.put(function.hashCode(), priority);
    }

    public void dataSaveEvent(boolean writeOut) {
        DatastoreSaveEvent event = DatastoreSaveEvent.create();
        for (Consumer<DatastoreSaveEvent> saver : this.ON_DATA_SAVE) {
            saver.accept(event);
        }
        if (writeOut) {
            event.getDataStore().write();
        }
    }

    public void onServerTick(MinecraftServer s) {
        GeneralConfig config = GeneralConfig.getInstance();
        long totalTicks = config.getTotalTickCount();
        ServerTickEvent event = new ServerTickEvent(totalTicks);
        this.SERVER_TICK_EVENTS.forEach((scheme, consumer) -> {
            if (scheme.shouldTrigger(totalTicks)) {
                this.tryEvent((Consumer)consumer, (Object)event);
            }
        });
        HashMap<class_2960, ServerTickEvent.DailyTickEvent> cache = new HashMap<class_2960, ServerTickEvent.DailyTickEvent>();
        for (class_1937 l : config.getLevels().values()) {
            if (l.field_9236 || config.getNextDailyTick(l) > totalTicks) continue;
            class_2960 dimLoc2 = l.method_27983().method_29177();
            long sleepTicks = config.getTotalTickCountWithSleep(l);
            cache.put(dimLoc2, new ServerTickEvent.DailyTickEvent(totalTicks, sleepTicks, l, false));
        }
        cache.forEach((dim, dailyTickEvent) -> GeneralConfig.fireEvent(ServerTickEvent.DailyTickEvent.class, dailyTickEvent));
        this.DAILY_TICK_EVENTS.asMap().forEach((dimLoc, consumers) -> {
            if (dimLoc == EMPTY_LOC) {
                cache.forEach((dim, dailyTickEvent) -> consumers.forEach(consumer -> this.tryEvent((Consumer)consumer, (Object)dailyTickEvent)));
                return;
            }
            if (!cache.containsKey(dimLoc)) {
                return;
            }
            ServerTickEvent.DailyTickEvent dailyTickEvent2 = (ServerTickEvent.DailyTickEvent)cache.get(dimLoc);
            LoggerBase.logDebug(null, "010200", "Firing daily tick event for dimension: " + dimLoc);
            consumers.forEach(consumer -> this.tryEvent((Consumer)consumer, (Object)dailyTickEvent2));
        });
    }

    public void onServerLevelTick(class_1937 level) {
        if (level == null) {
            return;
        }
        ManagedChunkEvents.onWorldTickStart(level);
    }

    public void onWakeUpAllPlayers(class_3218 level) {
        GeneralConfig config = GeneralConfig.getInstance();
        int totalSleeps = config.getTotalSleeps((class_1937)level) + 1;
        WakeUpAllPlayersEvent event = new WakeUpAllPlayersEvent(level, totalSleeps);
        GeneralConfig.fireEvent(WakeUpAllPlayersEvent.class, event);
        this.ON_WAKE_UP_ALL_PLAYERS.forEach(consumer -> this.tryEvent((Consumer)consumer, (Object)event));
        ServerTickEvent.DailyTickEvent dailyTickEvent = new ServerTickEvent.DailyTickEvent(config.getTotalTickCount(), config.getTotalTickCountWithSleep((class_1937)level), (class_1937)level, true);
        GeneralConfig.fireEvent(ServerTickEvent.DailyTickEvent.class, dailyTickEvent);
        this.DAILY_TICK_EVENTS.get((Object)EMPTY_LOC).forEach(consumer -> this.tryEvent((Consumer)consumer, (Object)dailyTickEvent));
        class_2960 levelId = level.method_27983().method_29177();
        this.DAILY_TICK_EVENTS.get((Object)levelId).forEach(consumer -> this.tryEvent((Consumer)consumer, (Object)dailyTickEvent));
    }

    public void onClientInput(ClientInputMessage message) {
        GeneralConfig config = GeneralConfig.getInstance();
        class_3222 p = config.getServer().method_3760().method_14602(message.playerId);
        ClientInputEvent event = new ClientInputEvent((class_1657)p, message);
        this.ON_CLIENT_INPUT.forEach(consumer -> this.tryEvent((Consumer)consumer, (Object)event));
    }

    public void onSimpleMessage(class_1657 player, SimpleStringMessage message, String messageId) {
        SimpleMessageEvent event = new SimpleMessageEvent(player, message, messageId);
        Collection consumers = this.ON_SIMPLE_MESSAGE.get((Object)messageId);
        List sortedConsumers = consumers.stream().sorted((a, b) -> this.PRIORITIES.get(b.hashCode()).compareTo((Enum)this.PRIORITIES.get(a.hashCode()))).toList();
        for (Consumer consumer : sortedConsumers) {
            this.tryEvent(consumer, event);
        }
    }

    private <T> void tryEvent(Consumer<T> consumer, T event) {
        String id = consumer.toString() + "::" + event.getClass().getName();
        if (MixinManager.isEnabled(consumer.toString())) {
            try {
                consumer.accept(event);
            }
            catch (Exception e) {
                MixinManager.recordError(id, e);
            }
        }
    }

    static {
        EMPTY_LOC = new class_2960("minecraft", "");
    }

    private class TickScheme {
        int offset;
        TickType frequency;

        <T> TickScheme(Consumer<T> func, TickType frequency) {
            this.frequency = frequency;
            this.offset = func.hashCode() % this.getFrequency();
        }

        int getFrequency() {
            switch (this.frequency) {
                case ON_SINGLE_TICK: {
                    return 1;
                }
                case ON_20_TICKS: {
                    return 20;
                }
                case ON_120_TICKS: {
                    return 120;
                }
                case ON_1200_TICKS: {
                    return 1200;
                }
                case ON_6000_TICKS: {
                    return 6000;
                }
                case ON_24000_TICKS: {
                    return 24000;
                }
            }
            return 1;
        }

        public TickType getTickType() {
            return this.frequency;
        }

        boolean shouldTrigger(long totalTicks) {
            return totalTicks % (long)this.getFrequency() == (long)this.offset;
        }
    }
}

