/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.model;

import com.google.gson.JsonElement;
import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.datastore.DataStore;
import com.holybuckets.foundation.datastore.LevelSaveData;
import com.holybuckets.foundation.datastructure.ConcurrentSet;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.event.custom.DatastoreSaveEvent;
import com.holybuckets.foundation.event.custom.ServerTickEvent;
import com.holybuckets.foundation.event.custom.TickType;
import com.holybuckets.foundation.model.ManagedChunk;
import com.holybuckets.foundation.model.ManagedChunkBlockUpdates;
import com.holybuckets.foundation.model.ManagedChunkUtility;
import com.holybuckets.foundation.util.MixinManager;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.event.ChunkLoadingEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2791;

public class ManagedChunkEvents {
    public static final String CLASS_ID = "0015";

    public static void init(EventRegistrar reg) {
        reg.registerOnServerStopped(ManagedChunkEvents::onServerStopped);
        reg.registerOnLevelLoad(ManagedChunkEvents::onWorldLoad);
        reg.registerOnLevelUnload(ManagedChunkEvents::onWorldUnload);
        reg.registerOnChunkLoad(ManagedChunkEvents::onChunkLoad);
        reg.registerOnChunkUnload(ManagedChunkEvents::onChunkUnload);
        TickType tickType = TickType.ON_1200_TICKS;
        reg.registerOnServerTick(tickType, ManagedChunkEvents::onServerTick1200);
    }

    private static void onServerStopped(ServerStoppedEvent event) {
        ManagedChunk.LOADED_CHUNKS.clear();
        ManagedChunk.INITIALIZED_CHUNKS.clear();
    }

    private static void onWorldLoad(LevelLoadingEvent.Load event) {
        class_1937 level = (class_1937)event.getLevel();
        if (ManagedChunk.LOADED_CHUNKS.get(level) == null) {
            ManagedChunk.LOADED_CHUNKS.put((class_1936)level, new ConcurrentHashMap());
            ManagedChunk.INITIALIZED_CHUNKS.put((class_1936)level, new ConcurrentSet());
        }
        if (level.method_8608()) {
            return;
        }
        DataStore ds = GeneralConfig.getInstance().getDataStore();
        LevelSaveData levelData = ds.getOrCreateLevelSaveData("hbs_foundation", level);
        JsonElement chunksIds = levelData.get("initializedChunkIds");
        if (chunksIds == null) {
            String[] ids = new String[]{};
            levelData.addProperty("initializedChunkIds", HBUtil.FileIO.arrayToJson(ids));
            chunksIds = levelData.get("initializedChunkIds");
        }
        Set<String> initChunks = ManagedChunk.INITIALIZED_CHUNKS.get(level);
        chunksIds.getAsJsonArray().forEach(chunkId -> initChunks.add(chunkId.getAsString()));
        Consumer<DatastoreSaveEvent> save = datastoreSaveEvent -> ManagedChunk.save(datastoreSaveEvent, level);
        EventRegistrar.getInstance().registerOnDataSave(save, EventPriority.Highest);
    }

    private static void onWorldUnload(LevelLoadingEvent.Unload event) {
        class_1937 level = (class_1937)event.getLevel();
        if (level.method_8608()) {
            return;
        }
        ManagedChunk.save(DatastoreSaveEvent.create(), level);
    }

    private static void onChunkLoad(ChunkLoadingEvent.Load event) {
        class_1936 level = event.getLevel();
        String chunkId = HBUtil.ChunkUtil.getId(event.getChunk());
        ManagedChunk loadedChunk = ManagedChunk.LOADED_CHUNKS.get(level).get(chunkId);
        if (loadedChunk == null) {
            loadedChunk = new ManagedChunk(level, event.getChunkPos());
        }
        loadedChunk.handleChunkLoaded(event);
    }

    private static void onChunkUnload(ChunkLoadingEvent.Unload event) {
        class_1936 level = event.getLevel();
        class_2791 chunk = event.getChunk();
        String id = HBUtil.ChunkUtil.getId(chunk);
        ManagedChunk c = ManagedChunk.LOADED_CHUNKS.get(level).remove(id);
        if (c == null) {
            return;
        }
        c.handleChunkUnloaded(event);
    }

    public static void onWorldTickStart(class_1937 level) {
        ManagedChunkBlockUpdates.onWorldTick(level);
    }

    public static void onServerTick1200(ServerTickEvent event) {
        try {
            if (MixinManager.isEnabled("ManagedChunkEvents::onServerTick1200")) {
                ManagedChunkUtility.INSTANCES.values().stream().filter(m -> !m.level.method_8608()).forEach(m -> m.cullLevelChunks(event));
            }
        }
        catch (Exception e) {
            MixinManager.recordError("ManagedChunkEvents::onServerTick1200", e);
        }
    }
}

