/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.networking;

import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.client.ClientEventRegistrar;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1657;

public class ClientInputMessage {
    public static final String LOCATION = "client_input";
    public final UUID playerId;
    public final InputType inputType;
    public final int code;
    public final Set<Integer> keyCodes;
    public final HBUtil.LevelUtil.LevelNameSpace side;
    public static final int MAX_KEYS = 5;

    ClientInputMessage(UUID playerId, InputType inputType, Set<Integer> keyCodes, HBUtil.LevelUtil.LevelNameSpace side) {
        this.playerId = playerId;
        this.inputType = inputType;
        this.keyCodes = new HashSet<Integer>(keyCodes);
        this.code = keyCodes.isEmpty() ? -1 : keyCodes.iterator().next();
        this.side = side;
    }

    ClientInputMessage(ClientInputMessage other, HBUtil.LevelUtil.LevelNameSpace side) {
        this.playerId = other.playerId;
        this.inputType = other.inputType;
        this.keyCodes = new HashSet<Integer>(other.keyCodes);
        this.code = other.code;
        this.side = side;
    }

    public static void createAndFire(InputType type, Set<Integer> keyCodes, class_1657 p) {
        Set<Integer> limitedKeys = keyCodes.stream().limit(5L).collect(Collectors.toSet());
        ClientInputMessage clientMessage = new ClientInputMessage(p.method_5667(), type, limitedKeys, HBUtil.LevelUtil.LevelNameSpace.CLIENT);
        ClientEventRegistrar.getInstance().onClientInput(clientMessage);
        ClientInputMessage serverMessage = new ClientInputMessage(clientMessage, HBUtil.LevelUtil.LevelNameSpace.SERVER);
        HBUtil.NetworkUtil.clientSendToServer(serverMessage);
    }

    public static enum InputType {
        KEY,
        MOUSE;

    }
}

