/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.networking;

import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.networking.BlockStateUpdatesMessage;
import com.holybuckets.foundation.networking.ClientInputMessage;
import com.holybuckets.foundation.networking.SimpleStringMessage;
import com.holybuckets.foundation.networking.StructureInfoMessage;
import com.holybuckets.foundation.structure.StructureInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2680;

public class Codecs {
    public static final class_2540 encodeClientInput(ClientInputMessage object, class_2540 buf) {
        buf.method_10797(object.playerId);
        buf.method_10814(ClientInputMessage.InputType.valueOf(object.inputType.name()).name());
        ArrayList<Integer> arr = new ArrayList<Integer>(object.keyCodes);
        for (int i = 0; i < 5; ++i) {
            buf.writeInt(arr.size() <= i ? -1 : (Integer)arr.get(i));
        }
        buf.method_10814(object.side.name());
        return buf;
    }

    public static final ClientInputMessage decodeClientInput(class_2540 buf) {
        UUID playerId = buf.method_10790();
        ClientInputMessage.InputType inputType = ClientInputMessage.InputType.valueOf(buf.method_19772());
        HashSet<Integer> keyCodes = new HashSet<Integer>();
        for (int i = 0; i < 5; ++i) {
            int code = buf.readInt();
            if (code == -1) continue;
            keyCodes.add(code);
        }
        HBUtil.LevelUtil.LevelNameSpace side = HBUtil.LevelUtil.LevelNameSpace.valueOf(buf.method_19772());
        return new ClientInputMessage(playerId, inputType, keyCodes, side);
    }

    public static final class_2540 encodeBlockStateUpdates(BlockStateUpdatesMessage object, class_2540 buf) {
        buf.method_10814(HBUtil.LevelUtil.toLevelId(object.world));
        buf.method_10814(HBUtil.BlockUtil.serializeBlockStatePairs(object.blockStates));
        return buf;
    }

    public static final BlockStateUpdatesMessage decodeBlockStateUpdates(class_2540 buf) {
        class_1937 world = HBUtil.LevelUtil.toLevel(HBUtil.LevelUtil.LevelNameSpace.CLIENT, buf.method_19772());
        Map<class_2680, List<class_2338>> blocks = HBUtil.BlockUtil.deserializeBlockStatePairs(buf.method_19772());
        return new BlockStateUpdatesMessage((class_1936)world, blocks);
    }

    public static final class_2540 encodeSimpleString(SimpleStringMessage object, class_2540 buf) {
        buf.method_10814(object.senderId == null ? "" : object.senderId.toString());
        buf.method_10788(object.messageId, 256);
        buf.method_10788(object.content, 4096);
        return buf;
    }

    public static final SimpleStringMessage decodeSimpleString(class_2540 buf) {
        String strUUID = buf.method_19772();
        UUID senderId = strUUID.isEmpty() ? null : UUID.fromString(strUUID);
        String messageId = buf.method_10800(256);
        String content = buf.method_10800(4096);
        return new SimpleStringMessage(senderId, messageId, content);
    }

    public static final class_2540 encodeStructureInfo(StructureInfoMessage object, class_2540 buf) {
        buf.writeBoolean(object.senderId != null);
        if (object.senderId != null) {
            buf.method_10797(object.senderId);
        }
        buf.writeInt(object.structures.size());
        for (StructureInfo structure : object.structures) {
            class_2487 tag = structure.serialize();
            buf.method_10794(tag);
        }
        return buf;
    }

    public static final StructureInfoMessage decodeStructureInfo(class_2540 buf) {
        UUID senderId = null;
        if (buf.readBoolean()) {
            senderId = buf.method_10790();
        }
        int count = buf.readInt();
        ArrayList<StructureInfo> structures = new ArrayList<StructureInfo>();
        for (int i = 0; i < count && i < 16; ++i) {
            class_2487 tag = buf.method_10798();
            if (tag == null) continue;
            structures.add(new StructureInfo(tag));
        }
        return new StructureInfoMessage(senderId, structures);
    }
}

