/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.networking;

import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.client.ClientEventRegistrar;
import com.holybuckets.foundation.event.EventRegistrar;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1657;

public class SimpleStringMessage {
    public static final String LOCATION = "simple_string";
    public static final int MAX_SIZE = 4096;
    @Nullable
    public final UUID senderId;
    public final String messageId;
    public final String content;

    public SimpleStringMessage(@Nullable UUID senderId, String messageId, String content) {
        this.senderId = senderId;
        String string = this.messageId = messageId != null ? messageId : "default";
        this.content = content != null && content.length() > 4096 ? content.substring(0, 4096) : (content != null ? content : "");
    }

    public SimpleStringMessage(String messageId, String content) {
        this(null, messageId, content);
    }

    public SimpleStringMessage(UUID senderId, String content) {
        this(senderId, "default", content);
    }

    public static SimpleStringMessage createAndFire(class_1657 p, String messageId, String content) {
        SimpleStringMessage message;
        SimpleStringMessage simpleStringMessage = message = p == null ? new SimpleStringMessage(messageId, content) : new SimpleStringMessage(p.method_5667(), messageId, content);
        if (GeneralConfig.getInstance().isIntegrated()) {
            EventRegistrar.getInstance().onSimpleMessage(p, message, message.messageId);
            ClientEventRegistrar.getInstance().onSimpleMessage(p, message, message.messageId);
            return message;
        }
        if (GeneralConfig.getInstance().isServerSide()) {
            HBUtil.NetworkUtil.serverSendToPlayer(p, message);
        } else {
            HBUtil.NetworkUtil.clientSendToServer(message);
        }
        return message;
    }

    public static SimpleStringMessage createAndFire(String messageId, String content) {
        return SimpleStringMessage.createAndFire(null, messageId, content);
    }

    public static class SimpleStringMessageHandler {
        public static String CLASS_ID = "016";

        public static void handle(class_1657 player, SimpleStringMessage message) {
            if (GeneralConfig.getInstance().isServerSide()) {
                EventRegistrar.getInstance().onSimpleMessage(player, message, message.messageId);
            } else {
                ClientEventRegistrar.getInstance().onSimpleMessage(player, message, message.messageId);
            }
        }
    }
}

