/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.player;

import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.LoggerBase;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.event.custom.ServerTickEvent;
import com.holybuckets.foundation.event.custom.TickType;
import com.holybuckets.foundation.exception.InvalidId;
import com.holybuckets.foundation.modelInterface.IManagedPlayer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.blay09.mods.balm.api.event.DigSpeedEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LivingDeathEvent;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.event.PlayerLogoutEvent;
import net.blay09.mods.balm.api.event.PlayerRespawnEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public class ManagedPlayer {
    public static final String CLASS_ID = "004";
    static final GeneralConfig GENERAL_CONFIG = GeneralConfig.getInstance();
    static final Map<Class<? extends IManagedPlayer>, Supplier<IManagedPlayer>> MANAGED_SUBCLASSES = new ConcurrentHashMap<Class<? extends IManagedPlayer>, Supplier<IManagedPlayer>>();
    public static final Map<String, ManagedPlayer> PLAYERS = new ConcurrentHashMap<String, ManagedPlayer>();
    static final LinkedHashSet<class_1657> PENDING_PLAYERS = new LinkedHashSet();
    public static ManagedPlayer CLIENT_PLAYER;
    private class_1657 player;
    private String id;
    private class_3222 serverPlayer;
    private long tickWritten;
    private long tickLoaded;
    private class_2487 holdNbt;
    private final HashMap<Class<? extends IManagedPlayer>, IManagedPlayer> managedPlayerData = new HashMap();

    public ManagedPlayer() {
    }

    public ManagedPlayer(class_1657 player) {
        this();
        this.player = player;
        this.tickLoaded = GENERAL_CONFIG.getTotalTickCount();
        if (player instanceof class_3222) {
            this.serverPlayer = (class_3222)player;
        }
        PENDING_PLAYERS.add(player);
    }

    public ManagedPlayer(class_1657 player, String id) {
        this();
        this.player = player;
        this.id = id;
        this.tickLoaded = GENERAL_CONFIG.getTotalTickCount();
        if (player instanceof class_3222) {
            this.serverPlayer = (class_3222)player;
        }
        PLAYERS.put(this.id, this);
    }

    public ManagedPlayer(class_2487 tag) {
        this();
        this.deserializeNBT(tag);
        if (tag == null || tag.method_33133()) {
            LoggerBase.logDebug(null, "004000", "Not NBT data found in ManagedPlayer( CompoundTag )" + tag.toString());
            return;
        }
        if (this.id == null) {
            LoggerBase.logDebug(null, "004001", "Failed to read playerId from NBT data " + tag);
        }
        PLAYERS.put(this.id, this);
    }

    public void setPlayer(class_1657 p) {
        this.player = p;
        this.serverPlayer = p instanceof class_3222 ? (class_3222)p : null;
        String id = HBUtil.PlayerUtil.getId(p);
        PLAYERS.put(id, this);
        for (IManagedPlayer data : this.managedPlayerData.values()) {
            data.setPlayer(p);
        }
    }

    public String getId() {
        if (this.id == null) {
            this.id = HBUtil.PlayerUtil.getId(this.player);
        }
        return this.id;
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    public class_3222 getServerPlayer() {
        return this.serverPlayer;
    }

    public IManagedPlayer getSubclass(Class<? extends IManagedPlayer> classObject) {
        return this.managedPlayerData.get(classObject);
    }

    public Boolean setSubclass(Class<? extends IManagedPlayer> classObject, IManagedPlayer data) {
        if (classObject == null || data == null) {
            return false;
        }
        this.managedPlayerData.put(classObject, data);
        return true;
    }

    private boolean initJoinedPlayer(class_1657 p) {
        if (this.player == null) {
            this.player = p;
        }
        if (this.id != null && this.player != null) {
            try {
                if (this.holdNbt != null) {
                    this.initSubclassesFromNbt(this.holdNbt);
                }
                this.holdNbt = null;
                this.onPlayerJoinComplete();
            }
            catch (InvalidId e) {
                String msg = String.format("Invalid id: initializing ManagedPlayer from NBT for player %s: %s", this.player.method_5477().getString(), e.getMessage());
                LoggerBase.logError(null, "004005", msg);
                return false;
            }
            return true;
        }
        return false;
    }

    private void onPlayerJoinComplete() {
        this.initSubclassesFromMemory();
        for (IManagedPlayer data : this.managedPlayerData.values()) {
            try {
                data.handlePlayerJoin(this.player);
            }
            catch (Exception e) {
                String msg = String.format("Error handling player join for player %s, class: %s", this.player.method_5476(), data.getClass());
                LoggerBase.logError(null, "004007", msg);
            }
        }
    }

    private void onPlayerLeave() {
        for (IManagedPlayer data : this.managedPlayerData.values()) {
            try {
                data.handlePlayerLeave(this.player);
            }
            catch (Exception e) {
                String msg = String.format("Error handling player leave for player %s, class: %s", this.player.method_5476(), data.getClass());
                LoggerBase.logError(null, "004006", msg);
            }
        }
    }

    private void onPlayerRespawn() {
        for (IManagedPlayer data : this.managedPlayerData.values()) {
            try {
                data.handlePlayerRespawn(this.player);
            }
            catch (Exception e) {
                String msg = String.format("Error handling player respawn for player %s, class: %s", this.player.method_5476(), data.getClass());
                LoggerBase.logError(null, "004009", msg);
            }
        }
    }

    private void handlePlayerDeath(class_1657 player) {
        for (IManagedPlayer data : this.managedPlayerData.values()) {
            try {
                data.handlePlayerDeath(player);
            }
            catch (Exception e) {
                String msg = String.format("Error handling player death for player %s, class: %s", player.method_5476(), data.getClass());
                LoggerBase.logError(null, "004011", msg);
            }
        }
    }

    public void handlePlayerAttack(class_1657 player, class_1297 target) {
        for (IManagedPlayer data : this.managedPlayerData.values()) {
            try {
                data.handlePlayerAttack(player, target);
            }
            catch (Exception e) {
                String msg = String.format("Error handling player attack for player %s, class: %s", player.method_5476(), data.getClass());
                LoggerBase.logError(null, "004012", msg);
            }
        }
    }

    public static ManagedPlayer getManagedPlayer(class_1657 player) {
        if (!GeneralConfig.getInstance().isServerSide()) {
            return CLIENT_PLAYER;
        }
        String id = HBUtil.PlayerUtil.getId(player);
        if (PLAYERS.containsKey(id)) {
            return PLAYERS.get(id);
        }
        return PLAYERS.getOrDefault(id, new ManagedPlayer(player));
    }

    @Nullable
    public static ManagedPlayer removeManagedPlayer(class_1657 player) {
        String id = HBUtil.PlayerUtil.getId(player);
        return PLAYERS.remove(id);
    }

    private void initSubclassesFromMemory() {
        boolean i = false;
        String playerId = this.getId();
        for (Map.Entry<Class<? extends IManagedPlayer>, Supplier<IManagedPlayer>> data : MANAGED_SUBCLASSES.entrySet()) {
            IManagedPlayer sub = data.getValue().get();
            if (sub == null) continue;
            if (this.managedPlayerData.containsKey(sub.getClass())) {
                sub = this.managedPlayerData.get(sub.getClass());
            }
            if (sub.isServerOnly() && !(this.player instanceof class_3222) || sub.isClientOnly() && this.player instanceof class_3222) continue;
            if (sub.getStaticInstance(this.player, playerId) != null) {
                sub = sub.getStaticInstance(this.player, playerId);
            }
            sub.setPlayer(this.player);
            this.setSubclass(sub.getClass(), sub);
        }
    }

    private void initSubclassesFromNbt(class_2487 tag) throws InvalidId {
        HashMap<String, String> errors = new HashMap<String, String>();
        for (Map.Entry<Class<? extends IManagedPlayer>, Supplier<IManagedPlayer>> data : MANAGED_SUBCLASSES.entrySet()) {
            IManagedPlayer sub = data.getValue().get();
            if (sub == null || sub.isServerOnly() && !(this.player instanceof class_3222) || sub.isClientOnly() && this.player instanceof class_3222) continue;
            try {
                class_2487 nbt = tag.method_10562(sub.getClass().getName());
                if (this.managedPlayerData.containsKey(sub.getClass())) {
                    this.managedPlayerData.get(sub.getClass()).deserializeNBT(nbt);
                    continue;
                }
                sub.setPlayer(this.player);
                sub.deserializeNBT(nbt);
                this.setSubclass(sub.getClass(), sub);
            }
            catch (Exception e) {
                errors.put(sub.getClass().getName(), e.getMessage());
            }
        }
        if (!errors.isEmpty()) {
            StringBuilder error = new StringBuilder();
            for (String key : errors.keySet()) {
                error.append(key).append(": ").append((String)errors.get(key)).append("\n");
            }
            throw new InvalidId(error.toString());
        }
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        if (this.player == null) {
            return tag;
        }
        try {
            if (this.getId() != null) {
                tag.method_10582("id", this.getId());
            }
            this.tickWritten = GENERAL_CONFIG.getTotalTickCount();
            tag.method_10544("tickWritten", this.tickWritten);
            for (IManagedPlayer data : this.managedPlayerData.values()) {
                if (data == null) continue;
                tag.method_10566(data.getClass().getName(), (class_2520)data.serializeNBT());
            }
        }
        catch (Exception e) {
            LoggerBase.logError(null, "004002", "Error serializing ManagedPlayer: " + e.getMessage());
        }
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        if (tag == null || tag.method_33133()) {
            this.holdNbt = new class_2487();
            return;
        }
        try {
            this.tickWritten = tag.method_10537("tickWritten");
            this.id = tag.method_10558("id");
            this.holdNbt = tag;
        }
        catch (Exception e) {
            LoggerBase.logError(null, "004003", "Error deserializing ManagedPlayer: " + e.getMessage());
        }
        PLAYERS.put(this.getId(), this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void save() {
        if (this.player == null || this.player.method_31481()) {
            return;
        }
        try {
            class_2487 tag = this.serializeNBT();
            if (tag.method_33133()) {
                return;
            }
            if (this.serverPlayer == null) return;
        }
        catch (Exception e) {
            LoggerBase.logError(null, "004004", "Error saving ManagedPlayer: " + e.getMessage());
        }
    }

    public static void registerManagedPlayerData(Class<? extends IManagedPlayer> classObject, Supplier<IManagedPlayer> data) {
        MANAGED_SUBCLASSES.put(classObject, data);
    }

    public static void onClientConnectedToServer(class_1657 player) {
        CLIENT_PLAYER = new ManagedPlayer(player, HBUtil.PlayerUtil.getId(player));
        CLIENT_PLAYER.initJoinedPlayer(player);
    }

    public static void onPlayerLogin(PlayerLoginEvent event) {
        class_3222 player = event.getPlayer();
        if (player == null) {
            return;
        }
        String id = HBUtil.PlayerUtil.getId((class_1657)player);
        ManagedPlayer mp = PLAYERS.get(id);
        if (mp == null) {
            mp = new ManagedPlayer((class_1657)player, id);
        }
        PLAYERS.put(id, mp);
        if (player instanceof class_3222) {
            PENDING_PLAYERS.add((class_1657)player);
        }
    }

    public static void onPlayerLogout(PlayerLogoutEvent event) {
        class_3222 player = event.getPlayer();
        String id = HBUtil.PlayerUtil.getId((class_1657)player);
        ManagedPlayer mp = PLAYERS.get(id);
        if (mp != null) {
            mp.onPlayerLeave();
        }
    }

    private static void onPlayerRespawn(PlayerRespawnEvent event) {
        PENDING_PLAYERS.remove(event.getOldPlayer());
        ManagedPlayer mp = ManagedPlayer.removeManagedPlayer((class_1657)event.getOldPlayer());
        if (mp == null) {
            LoggerBase.logError(null, "004008", "ManagedPlayer not found for respawn event");
            return;
        }
        class_3222 p = event.getNewPlayer();
        mp.setPlayer((class_1657)p);
        mp.onPlayerRespawn();
    }

    private static void onPlayerDeath(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)event.getEntity();
        String id = HBUtil.PlayerUtil.getId(player);
        ManagedPlayer mp = PLAYERS.get(id);
        if (mp != null) {
            mp.handlePlayerDeath(player);
        } else {
            LoggerBase.logError(null, "004010", "ManagedPlayer not found for death event");
        }
    }

    private void handlePlayerDigSpeed(class_1657 player, float originalSpeed, Float newSpeed) {
        for (IManagedPlayer data : this.managedPlayerData.values()) {
            try {
                data.handlePlayerDigSpeed(player, originalSpeed, newSpeed);
            }
            catch (Exception exception) {}
        }
    }

    private static void onDigSpeed(DigSpeedEvent event) {
        class_1657 player = event.getPlayer();
        if (player == null) {
            return;
        }
        String id = HBUtil.PlayerUtil.getId(player);
        ManagedPlayer mp = PLAYERS.get(id);
        if (mp != null) {
            mp.handlePlayerDigSpeed(player, event.getSpeed(), event.getSpeedOverride());
        }
    }

    private static void onPlayerAttack(PlayerAttackEvent playerAttackEvent) {
        class_1657 player = playerAttackEvent.getPlayer();
        class_1297 target = playerAttackEvent.getTarget();
        if (player == null || target == null) {
            return;
        }
        String id = HBUtil.PlayerUtil.getId(player);
        ManagedPlayer mp = PLAYERS.get(id);
        if (mp != null) {
            mp.handlePlayerAttack(player, target);
        }
    }

    public static void onServerTick(ServerTickEvent e) {
        if (PENDING_PLAYERS.isEmpty()) {
            return;
        }
        Iterator mp = PENDING_PLAYERS.iterator();
        while (mp.hasNext()) {
            class_1657 p = (class_1657)mp.next();
            if (p == null) {
                mp.remove();
                continue;
            }
            ManagedPlayer pending = PLAYERS.get(HBUtil.PlayerUtil.getId(p));
            if (pending == null || !pending.initJoinedPlayer(p)) continue;
            mp.remove();
        }
    }

    public static void onServerStopped(ServerStoppedEvent event) {
        for (ManagedPlayer managedPlayer : PLAYERS.values()) {
        }
        PLAYERS.clear();
        PENDING_PLAYERS.clear();
    }

    public static void init(EventRegistrar reg) {
        reg.registerOnPlayerAttack(ManagedPlayer::onPlayerAttack, EventPriority.High);
        reg.registerOnDigSpeedEvent(ManagedPlayer::onDigSpeed, EventPriority.High);
        reg.registerOnPlayerDeath(ManagedPlayer::onPlayerDeath, EventPriority.Highest);
        reg.registerOnPlayerRespawn(ManagedPlayer::onPlayerRespawn, EventPriority.Highest);
        reg.registerOnPlayerLogin(ManagedPlayer::onPlayerLogin, EventPriority.High);
        reg.registerOnPlayerLogout(ManagedPlayer::onPlayerLogout, EventPriority.Lowest);
        reg.registerOnServerStopped(ManagedPlayer::onServerStopped, EventPriority.Lowest);
        reg.registerOnServerTick(TickType.ON_SINGLE_TICK, ManagedPlayer::onServerTick, EventPriority.Lowest);
    }
}

