/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.sample;

import com.holybuckets.foundation.LoggerBase;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.modelInterface.IManagedPlayer;
import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.blay09.mods.balm.api.event.PlayerChangedDimensionEvent;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public class SamplePlayerData
implements IManagedPlayer {
    int blocksBroken = 0;
    int damageDealt = 0;
    private String id;
    class_1657 p;
    static Map<class_1657, SamplePlayerData> playerDataMap = new HashMap<class_1657, SamplePlayerData>();

    public SamplePlayerData(class_1657 p) {
        this.p = p;
    }

    @Override
    public boolean isServerOnly() {
        return true;
    }

    @Override
    public boolean isClientOnly() {
        return false;
    }

    @Override
    public boolean isInit(String subclass) {
        return false;
    }

    @Override
    public IManagedPlayer getStaticInstance(class_1657 player, String id) {
        if (!(player instanceof class_3222)) {
            return null;
        }
        return playerDataMap.get(player);
    }

    @Override
    public void handlePlayerJoin(class_1657 player) {
    }

    @Override
    public void handlePlayerLeave(class_1657 player) {
        if (player != null) {
            playerDataMap.remove(player);
        }
    }

    @Override
    public void handlePlayerRespawn(class_1657 player) {
        if (player != null) {
            playerDataMap.remove(player);
        }
        playerDataMap.put(player, this);
    }

    @Override
    public void handlePlayerDeath(class_1657 player) {
    }

    @Override
    public void handlePlayerAttack(class_1657 player, class_1297 target) {
    }

    @Override
    public void handlePlayerDigSpeed(class_1657 player, float originalSpeed, Float newSpeed) {
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("blocksBroken", this.blocksBroken);
        nbt.method_10569("damageDealt", this.damageDealt);
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.blocksBroken = nbt.method_10550("blocksBroken");
        this.damageDealt = nbt.method_10550("damageDealt");
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setPlayer(class_1657 player) {
        if (player != null) {
            this.p = player;
            playerDataMap.putIfAbsent(player, this);
        }
    }

    public static void init(EventRegistrar reg) {
        reg.registerOnPlayerAttack(SamplePlayerData::onPlayerAttack);
        reg.registerOnBreakBlock(SamplePlayerData::onPlayerBreakBlock);
        reg.registerOnPlayerChangedDimension(SamplePlayerData::onPlayerChangedDimension);
    }

    public static void onPlayerAttack(PlayerAttackEvent event) {
        class_1657 p = event.getPlayer();
        if (playerDataMap.containsKey(p)) {
            SamplePlayerData data = playerDataMap.get(p);
            ++data.damageDealt;
        }
    }

    public static void onPlayerBreakBlock(BreakBlockEvent event) {
        class_1657 p = event.getPlayer();
        if (p != null && playerDataMap.containsKey(p)) {
            SamplePlayerData data = playerDataMap.get(p);
            ++data.blocksBroken;
        }
    }

    public static void onPlayerChangedDimension(PlayerChangedDimensionEvent event) {
        LoggerBase.logInfo(null, "SamplePlayerData", "Player " + event.getPlayer().method_5477().getString() + " changed dimension to " + event.getToDim());
    }
}

