/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.structure;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.datastore.DataStore;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.event.custom.DatastoreSaveEvent;
import com.holybuckets.foundation.event.custom.ServerTickEvent;
import com.holybuckets.foundation.event.custom.TickType;
import com.holybuckets.foundation.modelInterface.IManagedPlayer;
import com.holybuckets.foundation.networking.SimpleStringMessage;
import com.holybuckets.foundation.networking.StructureInfoMessage;
import com.holybuckets.foundation.player.ManagedPlayer;
import com.holybuckets.foundation.structure.StructureInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.blay09.mods.balm.api.event.ChunkLoadingEvent;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3222;
import net.minecraft.class_3449;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class StructureManager {
    private class_1937 level;
    private class_2378<class_3195> structureRegistry;
    private Map<class_2338, StructureInfo> structures;
    private Map<class_2960, Set<class_2338>> structuresByType;
    private static Map<class_1937, StructureManager> managers = new HashMap<class_1937, StructureManager>();
    private Iterator<StructureInfo> syncIterator;
    public static String STRUCTURE_MSG_ID = "sync_structure_count";

    private StructureManager(class_1937 level) {
        this.level = level;
        this.structures = new HashMap<class_2338, StructureInfo>();
        this.structuresByType = new HashMap<class_2960, Set<class_2338>>();
        if (!level.method_8608()) {
            this.structureRegistry = level.method_30349().method_30530(class_7924.field_41246);
        }
    }

    public static class_2960 toLocation(String stringStruct) {
        return new class_2960(stringStruct);
    }

    public Map<class_2338, StructureInfo> getStructures() {
        return Maps.newHashMap(this.structures);
    }

    public List<class_2338> getStructurePosByType(class_2960 location) {
        if (!this.structuresByType.containsKey(location)) {
            return List.of();
        }
        return List.copyOf((Collection)this.structuresByType.get(location));
    }

    public List<class_2338> getStructurePosByType(class_3195 structure) {
        if (this.structureRegistry == null) {
            return List.of();
        }
        class_2960 location = this.structureRegistry.method_10221((Object)structure);
        if (location == null) {
            return List.of();
        }
        return this.getStructurePosByType(location);
    }

    public List<StructureInfo> getStructuresByType(class_2960 location) {
        if (!this.structuresByType.containsKey(location)) {
            return List.of();
        }
        return List.copyOf(this.structuresByType.get(location).stream().map(pos -> this.structures.get(pos)).toList());
    }

    public List<StructureInfo> getStructuresByType(class_3195 structure) {
        if (this.structureRegistry == null) {
            return List.of();
        }
        class_2960 location = this.structureRegistry.method_10221((Object)structure);
        if (location == null) {
            return List.of();
        }
        return this.getStructuresByType(location);
    }

    public List<StructureInfo> getNearestStructures(class_2338 center, double maxDistance) {
        double maxDistSq = maxDistance * maxDistance;
        return this.structures.values().stream().filter(info -> info.origin.method_10262((class_2382)center) <= maxDistSq).sorted(Comparator.comparingDouble(a -> a.origin.method_10262((class_2382)center))).toList();
    }

    public List<StructureInfo> getNearestStructures(class_2338 center, int limit) {
        if (limit < 1) {
            limit = this.structures.size();
        }
        return this.structures.values().stream().sorted(Comparator.comparingDouble(a -> a.origin.method_10262((class_2382)center))).limit(limit).toList();
    }

    public List<StructureInfo> getNearestWhitelistedStructuresServerOnly(Set<class_3195> whiteList, class_2338 center, int limit) {
        if (this.structureRegistry == null) {
            return List.of();
        }
        if (limit < 1) {
            limit = this.structures.size();
        }
        LinkedList<StructureInfo> allStructs = new LinkedList<StructureInfo>();
        for (class_3195 structure : whiteList) {
            List<StructureInfo> strs = this.getStructuresByType(structure);
            if (strs == null) continue;
            allStructs.addAll(strs);
        }
        return allStructs.stream().sorted(Comparator.comparingDouble(a -> a.origin.method_10262((class_2382)center))).limit(limit).toList();
    }

    public List<StructureInfo> getNearestWhitelistedStructures(Set<class_2960> whiteList, class_2338 center, int limit) {
        if (limit < 1) {
            limit = this.structures.size();
        }
        LinkedList<StructureInfo> allStructs = new LinkedList<StructureInfo>();
        for (class_2960 location : whiteList) {
            List<StructureInfo> strs = this.getStructuresByType(location);
            if (strs == null) continue;
            allStructs.addAll(strs);
        }
        return allStructs.stream().sorted(Comparator.comparingDouble(a -> a.origin.method_10262((class_2382)center))).limit(limit).toList();
    }

    public List<StructureInfo> getNearestBlackListedStructuresServerOnly(Set<class_3195> blackList, class_2338 center, int limit) {
        if (this.structureRegistry == null) {
            return List.of();
        }
        if (limit < 1) {
            limit = this.structures.size();
        }
        LinkedList<StructureInfo> allStructs = new LinkedList<StructureInfo>();
        for (StructureInfo info : this.structures.values()) {
            class_3195 structure = (class_3195)this.structureRegistry.method_10200(info.registryId);
            if (blackList.contains(structure)) continue;
            allStructs.add(info);
        }
        return allStructs.stream().sorted(Comparator.comparingDouble(a -> a.origin.method_10262((class_2382)center))).limit(limit).toList();
    }

    public List<StructureInfo> getNearestBlackListedStructures(Set<class_2960> blackList, class_2338 center, int limit) {
        if (limit < 1) {
            limit = this.structures.size();
        }
        LinkedList<StructureInfo> allStructs = new LinkedList<StructureInfo>();
        for (StructureInfo info : this.structures.values()) {
            class_2960 structureLocation = info.getStructureLocation();
            if (structureLocation == null || blackList.contains(structureLocation)) continue;
            allStructs.add(info);
        }
        return allStructs.stream().sorted(Comparator.comparingDouble(a -> a.origin.method_10262((class_2382)center))).limit(limit).toList();
    }

    private void syncServerStructuresToClient() {
        if (this.syncIterator == null) {
            this.syncIterator = this.structures.values().stream().toList().iterator();
        }
        ArrayList<StructureInfo> data = new ArrayList<StructureInfo>();
        for (int i = 0; i < 16; ++i) {
            if (!this.syncIterator.hasNext()) {
                this.syncIterator = null;
                break;
            }
            data.add(this.syncIterator.next());
        }
        for (class_3222 p : HBUtil.PlayerUtil.getAllPlayers()) {
            PlayerStructureData psData;
            IManagedPlayer pData = ManagedPlayer.getManagedPlayer((class_1657)p).getSubclass(PlayerStructureData.class);
            if (pData == null || !(pData instanceof PlayerStructureData) || (psData = (PlayerStructureData)pData).getCount(this.level) >= this.structures.size()) continue;
            StructureInfoMessage.createAndFire((class_1657)p, data);
        }
    }

    private void onChunkLoad(class_2791 chunk) {
        for (Map.Entry entry : chunk.method_12016().entrySet()) {
            class_5321 structureKey;
            class_6880 holder;
            class_2960 structureLocation;
            class_2338 structStartPos;
            class_3195 structure = (class_3195)entry.getKey();
            class_3449 start = (class_3449)entry.getValue();
            if (!start.method_16657() || this.structures.containsKey(structStartPos = start.method_14969().method_22874()) || this.structureRegistry == null || (structureLocation = this.structureRegistry.method_10221((Object)structure)) == null || (holder = (class_6880)this.structureRegistry.method_40264(structureKey = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)structureLocation)).orElse(null)) == null) continue;
            this.structures.put(structStartPos, StructureInfo.of((class_6880<class_3195>)holder, structStartPos, this.structureRegistry, structureLocation));
            this.structuresByType.computeIfAbsent(structureLocation, k -> new HashSet()).add(structStartPos);
        }
    }

    private void load(DataStore ds) {
        if (!GeneralConfig.getInstance().isServerSide()) {
            return;
        }
        JsonElement root = ds.getOrCreateLevelSaveData("hbs_foundation", this.level).get("structures");
        if (root == null || root.isJsonNull()) {
            return;
        }
        JsonObject rootObj = root.getAsJsonObject();
        for (String key : rootObj.keySet()) {
            JsonArray arr = rootObj.getAsJsonArray(key);
            int registryId = Integer.parseInt(key);
            for (JsonElement elem : arr) {
                class_2960 structureLocation = this.structureRegistry.method_10221((Object)((class_3195)this.structureRegistry.method_10200(registryId)));
                if (structureLocation == null) continue;
                StructureInfo info = StructureInfo.of(registryId, elem.getAsString(), this.structureRegistry, structureLocation);
                if (this.structures.containsKey(info.origin)) continue;
                this.structures.put(info.origin, info);
                this.structuresByType.computeIfAbsent(structureLocation, k -> new HashSet()).add(info.origin);
            }
        }
    }

    private void save(DataStore ds) {
        JsonObject root = new JsonObject();
        for (StructureInfo struct : this.structures.values()) {
            class_2487 tag = struct.serialize();
            String key = "" + tag.method_10550("registryId");
            if (!root.has(key)) {
                root.add(key, (JsonElement)new JsonArray());
            }
            root.getAsJsonArray(key).add(tag.method_10558("origin"));
        }
        ds.getOrCreateLevelSaveData("hbs_foundation", this.level).addProperty("structures", (JsonElement)root);
    }

    private static StructureManager init(class_1937 level) {
        if (!managers.containsKey(level)) {
            managers.put(level, new StructureManager(level));
        }
        return managers.get(level);
    }

    public static StructureManager get(class_1937 level) {
        if (GeneralConfig.getInstance().isIntegrated()) {
            level = HBUtil.LevelUtil.toLevel(HBUtil.LevelUtil.LevelNameSpace.SERVER, (class_5321<class_1937>)level.method_27983());
        }
        if (!managers.containsKey(level)) {
            StructureManager.init(level);
        }
        return managers.get(level);
    }

    public static void init(EventRegistrar reg) {
        reg.registerOnBeforeServerStarted(StructureManager::onServerStart);
        reg.registerOnLevelLoad(StructureManager::onLevelLoad);
        reg.registerOnChunkLoad(StructureManager::onChunkLoad);
        reg.registerOnServerTick(TickType.ON_20_TICKS, StructureManager::on20Ticks);
        reg.registerOnSimpleMessage(STRUCTURE_MSG_ID, e -> StructureManager.handleSyncStructureCountsFromClient(e.getPlayer(), e.getContent()));
        reg.registerOnDataSave(StructureManager::onDataSave);
        PlayerStructureData.init();
    }

    private static void handleSyncStructureCountsFromClient(class_1657 player, String content) {
        IManagedPlayer pData = ManagedPlayer.getManagedPlayer(player).getSubclass(PlayerStructureData.class);
        if (pData != null && pData instanceof PlayerStructureData) {
            PlayerStructureData psData = (PlayerStructureData)pData;
            Map<class_1937, Integer> deserialized = PlayerStructureData.deserialize(content);
            for (Map.Entry<class_1937, Integer> entry : deserialized.entrySet()) {
                psData.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private static void onServerStart(ServerStartingEvent event) {
        managers.clear();
    }

    private static void onLevelLoad(LevelLoadingEvent.Load event) {
        StructureManager manager = StructureManager.init((class_1937)event.getLevel());
        if (manager != null && !event.getLevel().method_8608()) {
            manager.load(GeneralConfig.getInstance().getDataStore());
        }
    }

    private static void onChunkLoad(ChunkLoadingEvent.Load event) {
        if (event.getLevel().method_8608()) {
            return;
        }
        StructureManager.get((class_1937)event.getLevel()).onChunkLoad(event.getChunk());
    }

    private static void on20Ticks(ServerTickEvent event) {
        for (StructureManager manager : managers.values()) {
            if (manager.structures.size() <= 0) continue;
            manager.syncServerStructuresToClient();
        }
    }

    private static void onDataSave(DatastoreSaveEvent event) {
        for (StructureManager manager : managers.values()) {
            manager.save(event.getDataStore());
        }
    }

    public static void clientInit() {
    }

    public static void fireSyncClientStructureCountsToServer(class_1657 player) {
        IManagedPlayer pData = ManagedPlayer.getManagedPlayer(player).getSubclass(PlayerStructureData.class);
        if (pData != null && pData instanceof PlayerStructureData) {
            PlayerStructureData psData = (PlayerStructureData)pData;
            String serializedCounts = psData.serialize();
            if (GeneralConfig.getInstance().isIntegrated()) {
                StructureManager.handleSyncStructureCountsFromClient(psData.p, serializedCounts);
            } else {
                SimpleStringMessage.createAndFire(player, STRUCTURE_MSG_ID, serializedCounts);
            }
        }
    }

    public static void handleStructureInfoFromServer(class_1657 player, StructureInfoMessage message) {
        if (GeneralConfig.getInstance().isIntegrated()) {
            return;
        }
        if (player == null) {
            return;
        }
        for (StructureInfo info : message.structures) {
            StructureManager sm = StructureManager.get(player.method_37908());
            class_2960 structureLocation = info.getStructureLocation();
            if (structureLocation == null || sm.structures.containsKey(info.origin)) continue;
            sm.structures.put(info.origin, info);
            sm.structuresByType.computeIfAbsent(structureLocation, k -> new HashSet()).add(info.origin);
            IManagedPlayer playerStructureData = ManagedPlayer.getManagedPlayer(player).getSubclass(PlayerStructureData.class);
            if (playerStructureData == null || !(playerStructureData instanceof PlayerStructureData)) continue;
            PlayerStructureData psData = (PlayerStructureData)playerStructureData;
            psData.increment(player.method_37908());
        }
    }

    public static void onConnectedToServer(class_1657 player) {
        if (GeneralConfig.getInstance().isServerSide()) {
            return;
        }
        managers.clear();
        IManagedPlayer pData = ManagedPlayer.getManagedPlayer(player).getSubclass(PlayerStructureData.class);
        if (pData != null && pData instanceof PlayerStructureData) {
            PlayerStructureData psData = (PlayerStructureData)pData;
            psData.clearAll();
        }
    }

    static class PlayerStructureData
    implements IManagedPlayer {
        Map<class_1937, Integer> syncedStructureCounts = new HashMap<class_1937, Integer>();
        class_1657 p;

        static void init() {
            ManagedPlayer.registerManagedPlayerData(PlayerStructureData.class, () -> new PlayerStructureData(null));
        }

        public PlayerStructureData(class_1657 player) {
            this.setPlayer(player);
        }

        @Override
        public boolean isInit(String subclass) {
            return true;
        }

        @Override
        public IManagedPlayer getStaticInstance(class_1657 player, String id) {
            return null;
        }

        @Override
        public void handlePlayerJoin(class_1657 player) {
            StructureManager.onConnectedToServer(player);
        }

        public int getCount(class_1937 level) {
            return this.syncedStructureCounts.getOrDefault(level, 0);
        }

        public void put(class_1937 level, int count) {
            this.syncedStructureCounts.computeIfAbsent(level, lvl -> 0);
            this.syncedStructureCounts.put(level, count);
        }

        public void increment(class_1937 level) {
            this.syncedStructureCounts.computeIfAbsent(level, lvl -> 0);
            this.syncedStructureCounts.put(level, this.syncedStructureCounts.get(level) + 1);
        }

        public void clear(class_1937 level) {
            this.syncedStructureCounts.put(level, 0);
        }

        public void clearAll() {
            this.syncedStructureCounts.clear();
        }

        public String serialize() {
            if (this.p.method_37908() == null) {
                return "{}";
            }
            if (!this.syncedStructureCounts.containsKey(this.p.method_37908())) {
                this.put(this.p.method_37908(), 0);
            }
            JsonObject structCounts = new JsonObject();
            for (Map.Entry<class_1937, Integer> entry : this.syncedStructureCounts.entrySet()) {
                structCounts.addProperty(HBUtil.LevelUtil.toLevelId((class_1936)entry.getKey()), (Number)entry.getValue());
            }
            return structCounts.toString();
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 tag = new class_2487();
            tag.method_10582("syncedStructuresCount", this.serialize());
            return tag;
        }

        @Override
        public void deserializeNBT(class_2487 nbt) {
            String json = nbt.method_10558("syncedStructuresCount");
            for (Map.Entry<class_1937, Integer> entry : PlayerStructureData.deserialize(json).entrySet()) {
                this.syncedStructureCounts.put(entry.getKey(), entry.getValue());
            }
        }

        public static Map<class_1937, Integer> deserialize(String json) {
            HashMap data = Maps.newHashMap();
            if (json == null || json.isEmpty()) {
                return data;
            }
            for (Map.Entry entry : JsonParser.parseString((String)json).getAsJsonObject().entrySet()) {
                class_1937 level = HBUtil.LevelUtil.toLevel(null, (String)entry.getKey());
                if (level == null) continue;
                int count = ((JsonElement)entry.getValue()).getAsInt();
                data.put(level, count);
            }
            return data;
        }

        @Override
        public void setId(String id) {
        }

        @Override
        public void setPlayer(class_1657 player) {
            this.p = player;
        }
    }
}

