/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9298;
import net.minecraft.class_9334;
import org.dfood.block.entity.ModBlockEntityTypes;

public class SuspiciousStewBlockEntity
extends class_2586 {
    protected final Map<class_2960, Integer> EffectMap = new HashMap<class_2960, Integer>();

    public SuspiciousStewBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public SuspiciousStewBlockEntity(class_2338 pos, class_2680 state) {
        this(ModBlockEntityTypes.SUSPICIOUS_STEW_BLOCK_ENTITY, pos, state);
    }

    private void readEffectsFromComponent(class_9298 component) {
        this.EffectMap.clear();
        if (component != null && component.comp_2416() != null) {
            for (class_9298.class_8751 stewEffect : component.comp_2416()) {
                class_6880 effectEntry = stewEffect.comp_1838();
                if (!effectEntry.method_40230().isPresent()) continue;
                class_2960 effectId = ((class_5321)effectEntry.method_40230().get()).method_29177();
                int duration = stewEffect.comp_1839();
                this.EffectMap.put(effectId, duration);
            }
        }
    }

    public void readCustomDataFromItem(class_9298 component) {
        this.readEffectsFromComponent(component);
        this.method_5431();
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.EffectMap.clear();
        nbt.method_10554("Effects").ifPresent(effectsList -> {
            for (int i = 0; i < effectsList.size(); ++i) {
                effectsList.method_10602(i).ifPresent(effectTag -> {
                    class_2960 effectId;
                    Optional effectIdOpt = effectTag.method_10558("EffectId");
                    Optional durationOpt = effectTag.method_10550("EffectDuration");
                    if (effectIdOpt.isPresent() && durationOpt.isPresent() && (effectId = class_2960.method_12829((String)((String)effectIdOpt.get()))) != null) {
                        this.EffectMap.put(effectId, (Integer)durationOpt.get());
                    }
                });
            }
        });
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        if (!this.EffectMap.isEmpty()) {
            class_2499 effectsList = new class_2499();
            for (Map.Entry<class_2960, Integer> entry : this.EffectMap.entrySet()) {
                class_2487 effectTag = new class_2487();
                effectTag.method_10582("EffectId", entry.getKey().toString());
                effectTag.method_10569("EffectDuration", entry.getValue().intValue());
                effectsList.add((Object)effectTag);
            }
            nbt.method_10566("Effects", (class_2520)effectsList);
        }
    }

    public class_9298 createStewEffectsComponent() {
        if (this.EffectMap.isEmpty()) {
            return class_9298.field_49362;
        }
        List<class_9298.class_8751> effects = this.EffectMap.entrySet().stream().map(entry -> {
            class_6880<class_1291> effectEntry = this.getRegistryEntry((class_2960)entry.getKey());
            return new class_9298.class_8751(effectEntry, ((Integer)entry.getValue()).intValue());
        }).toList();
        return new class_9298(effects);
    }

    private class_6880<class_1291> getRegistryEntry(class_2960 effectId) {
        return class_7923.field_41174.method_47983((Object)((class_1291)class_7923.field_41174.method_63535(effectId)));
    }

    public class_1799 getStewStack() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8766);
        class_9298 component = this.createStewEffectsComponent();
        if (component != class_9298.field_49362) {
            stack.method_57379(class_9334.field_49652, (Object)component);
        }
        return stack;
    }

    public Map<class_2960, Integer> getEffectMap() {
        return new HashMap<class_2960, Integer>(this.EffectMap);
    }

    public void addEffect(class_2960 effectId, int duration) {
        this.EffectMap.put(effectId, duration);
        this.method_5431();
    }

    public void clearEffects() {
        this.EffectMap.clear();
        this.method_5431();
    }
}

