/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3898;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import net.minecraft.class_5573;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import net.minecraft.class_7927;
import noppes.npcs.CustomEntities;
import noppes.npcs.CustomNpcs;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.data.SpawnData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.ChunkMapMixin;
import noppes.npcs.mixin.PersistentEntitySectionManagerMixin;
import noppes.npcs.mixin.ServerLevelMixin;

public class NPCSpawning {
    public static void findChunksForSpawning(class_3218 level) {
        class_3193 chunkHolder;
        class_2818 levelchunk;
        if (SpawnController.instance.data.isEmpty() || level.method_8510() % 400L != 0L) {
            return;
        }
        class_5573 sectionManager = ((PersistentEntitySectionManagerMixin)((ServerLevelMixin)level).entityManager()).sectionStorage();
        class_3898 chunkManager = level.method_14178().field_17254;
        ArrayList list = new ArrayList(((ChunkMapMixin)chunkManager).visibleChunkMap().values());
        Collections.shuffle(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && (levelchunk = (chunkHolder = (class_3193)iterator.next()).method_16144()) != null) {
            class_1923 pos = levelchunk.method_12004();
            class_1959 biome = (class_1959)level.method_23753(pos.method_8323()).comp_349();
            if (!SpawnController.instance.hasSpawnList(level.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome))) continue;
            class_238 bb = new class_238((double)pos.method_8326(), 0.0, (double)pos.method_8328(), (double)pos.method_8327(), (double)level.method_31600(), (double)pos.method_8329());
            ArrayList entities = Lists.newArrayList();
            sectionManager.method_31773((class_5575)class_1299.field_6097, bb.method_1014(4.0), e -> {
                entities.add(e);
                return class_7927.class_7928.field_41283;
            });
            if (!entities.isEmpty()) continue;
            sectionManager.method_31773(CustomEntities.entityCustomNpc, bb, e -> {
                entities.add(e);
                return class_7927.class_7928.field_41283;
            });
            if (entities.size() >= CustomNpcs.NpcNaturalSpawningChunkLimit) continue;
            NPCSpawning.spawnChunk(level, levelchunk);
        }
    }

    private static void spawnChunk(class_3218 level, class_2818 chunk) {
        class_2338 chunkposition = NPCSpawning.getChunk((class_1937)level, chunk);
        int j1 = chunkposition.method_10263();
        int k1 = chunkposition.method_10264();
        int l1 = chunkposition.method_10260();
        for (int i = 0; i < 3; ++i) {
            int x = j1;
            int y = k1;
            int z = l1;
            int b1 = 6;
            class_2338 pos = new class_2338(x += level.field_9229.method_43048(b1) - level.field_9229.method_43048(b1), y, z += level.field_9229.method_43048(b1) - level.field_9229.method_43048(b1));
            class_2960 name = level.method_30349().method_30530(class_7924.field_41236).method_10221((Object)((class_1959)level.method_23753(pos).comp_349()));
            SpawnData data = SpawnController.instance.getRandomSpawnData(name);
            if (data == null || data.data.isEmpty() || !NPCSpawning.canCreatureTypeSpawnAtLocation(data, (class_4538)level, pos)) continue;
            NPCSpawning.spawnData(data, (class_5425)level, pos);
        }
    }

    public static int countNPCs(class_3218 level) {
        int count = 0;
        Iterable list = level.method_27909();
        for (class_1297 entity : list) {
            if (!(entity instanceof EntityNPCInterface)) continue;
            ++count;
        }
        return count;
    }

    private static class_2338 getChunk(class_1937 level, class_2818 chunk) {
        class_1923 chunkpos = chunk.method_12004();
        int i = chunkpos.method_8326() + level.field_9229.method_43048(16);
        int j = chunkpos.method_8328() + level.field_9229.method_43048(16);
        int k = chunk.method_12005(class_2902.class_2903.field_13202, i, j) + 1;
        int l = level.field_9229.method_43048(k + 1);
        return new class_2338(i, l, j);
    }

    public static void performLevelGenSpawning(class_5425 level, class_1959 biome, int x, int z, class_5819 rand) {
        if (biome.method_30966().method_31002() >= 1.0f || biome.method_30966().method_31002() < 0.0f || !SpawnController.instance.hasSpawnList(level.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome))) {
            return;
        }
        int tries = 0;
        block0: while (rand.method_43057() < biome.method_30966().method_31002() && ++tries <= 20) {
            SpawnData data = SpawnController.instance.getRandomSpawnData(level.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome));
            int size = 16;
            int j1 = x + rand.method_43048(size);
            int k1 = z + rand.method_43048(size);
            int l1 = j1;
            int i2 = k1;
            for (int k2 = 0; k2 < 4; ++k2) {
                class_2338 pos = NPCSpawning.getTopNonCollidingPos((class_4538)level, CustomEntities.entityCustomNpc, j1, k1);
                if (!NPCSpawning.canCreatureTypeSpawnAtLocation(data, (class_4538)level, pos)) {
                    j1 += rand.method_43048(5) - rand.method_43048(5);
                    k1 += rand.method_43048(5) - rand.method_43048(5);
                    while (j1 < x || j1 >= x + size || k1 < z || k1 >= z + size) {
                        j1 = l1 + rand.method_43048(5) - rand.method_43048(5);
                        k1 = i2 + rand.method_43048(5) - rand.method_43048(5);
                    }
                    continue;
                }
                if (NPCSpawning.spawnData(data, level, pos)) continue block0;
            }
        }
    }

    private static boolean spawnData(SpawnData data, class_5425 level, class_2338 pos) {
        class_1308 entityliving;
        try {
            class_2487 nbt = data.getCompound(1);
            if (nbt == null) {
                return false;
            }
            class_1297 entity = class_1299.method_5892((class_2487)nbt, (class_1937)level.method_8410()).orElse(null);
            if (entity == null || !(entity instanceof class_1308)) {
                return false;
            }
            entityliving = (class_1308)entity;
            if (entity instanceof EntityCustomNpc) {
                EntityCustomNpc npc = (EntityCustomNpc)entity;
                npc.stats.spawnCycle = 4;
                npc.stats.respawnTime = 0;
                npc.ais.returnToStart = false;
                npc.ais.setStartPos(pos);
            }
            entity.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, level.method_8409().method_43057() * 360.0f, 0.0f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        if (!entityliving.method_5979((class_1936)level, class_3730.field_16459) || !entityliving.method_5957((class_4538)level)) {
            return false;
        }
        level.method_8503().method_20493(() -> level.method_8649((class_1297)entityliving));
        return true;
    }

    public static float getLightLevel(class_4538 level, class_2338 pos) {
        int blockLight = level.method_8314(class_1944.field_9282, pos);
        int skyLight = level.method_8314(class_1944.field_9284, pos);
        int skyDarken = level.method_8594();
        float skyLightValue = (11.0f - (float)skyDarken) * 15.0f / 11.0f;
        return Math.max((float)blockLight, (float)skyLight / 15.0f * skyLightValue);
    }

    public static boolean canCreatureTypeSpawnAtLocation(SpawnData data, class_4538 level, class_2338 pos) {
        if (!level.method_8621().method_11952(pos) || !level.method_18026(CustomEntities.entityCustomNpc.method_58629((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()))) {
            return false;
        }
        if (data.type == 1 && NPCSpawning.getLightLevel(level, pos) > 8.0f || data.type == 2 && NPCSpawning.getLightLevel(level, pos) <= 8.0f) {
            return false;
        }
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        if (data.liquid) {
            return state.method_51176() && level.method_8320(pos.method_10074()).method_51176() && !level.method_8320(pos.method_10084()).method_26212((class_1922)level, pos.method_10084());
        }
        class_2338 blockpos1 = pos.method_10074();
        class_2680 state1 = level.method_8320(blockpos1);
        class_2248 block1 = state1.method_26204();
        boolean flag = block1 != class_2246.field_9987 && block1 != class_2246.field_10499;
        class_2338 down = blockpos1.method_10074();
        return (flag |= level.method_8320(down).method_26170((class_1922)level, down, CustomEntities.entityCustomNpc)) && !state.method_26219() && !state.method_51176() && !level.method_8320(pos.method_10084()).method_26219();
    }

    private static class_2338 getTopNonCollidingPos(class_4538 p_208498_0_, class_1299<?> p_208498_1_, int p_208498_2_, int p_208498_3_) {
        class_2338 blockpos;
        int i = p_208498_0_.method_8624(class_2902.class_2903.field_13203, p_208498_2_, p_208498_3_);
        class_2338.class_2339 blockpos$mutable = new class_2338.class_2339(p_208498_2_, i, p_208498_3_);
        if (p_208498_0_.method_8597().comp_643()) {
            do {
                blockpos$mutable.method_10098(class_2350.field_11033);
            } while (!p_208498_0_.method_8320((class_2338)blockpos$mutable).method_26215());
            do {
                blockpos$mutable.method_10098(class_2350.field_11033);
            } while (p_208498_0_.method_8320((class_2338)blockpos$mutable).method_26215() && blockpos$mutable.method_10264() > 0);
        }
        if (p_208498_0_.method_8320(blockpos = blockpos$mutable.method_10074()).method_26171(class_10.field_50)) {
            return blockpos;
        }
        return blockpos$mutable.method_10062();
    }
}

