/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_7923;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.VisibilityController;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemSoulstoneEmpty;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiCloneOpen;
import noppes.npcs.packets.client.PacketGuiOpen;
import noppes.npcs.quests.QuestKill;
import org.jetbrains.annotations.Nullable;

public class ServerEventsHandler
implements UseEntityCallback,
ServerLivingEntityEvents.AfterDeath {
    public static class_1646 Merchant;

    public class_1269 interact(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        class_1799 item = player.method_6047();
        boolean isCancelled = false;
        if (item.method_7960() || hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        boolean isClientSide = player.method_37908().field_9236;
        boolean npcInteracted = entity instanceof EntityNPCInterface;
        if (!isClientSide && CustomNpcs.OpsOnly && !player.method_5682().method_3760().method_14569(player.method_7334())) {
            return class_1269.field_5811;
        }
        if (!isClientSide && item.method_7909() == CustomItems.soulstoneEmpty && entity instanceof class_1309) {
            ((ItemSoulstoneEmpty)item.method_7909()).store((class_1309)entity, item, player);
        }
        if (item.method_7909() == CustomItems.wand && npcInteracted && !isClientSide) {
            if (!CustomNpcsPermissions.hasPermission((class_3222)player, CustomNpcsPermissions.NPC_GUI)) {
                return class_1269.field_5811;
            }
            isCancelled = true;
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.MainMenuDisplay, (EntityNPCInterface)entity);
        } else if (item.method_7909() == CustomItems.cloner && !isClientSide && !(entity instanceof class_1657)) {
            class_2487 compound = new class_2487();
            if (!entity.method_5786(compound)) {
                return class_1269.field_5811;
            }
            PlayerData data = PlayerData.get(player);
            ServerCloneController.Instance.cleanTags(compound);
            Packets.send((class_3222)player, new PacketGuiCloneOpen(compound));
            data.cloned = compound;
            isCancelled = true;
        } else if (item.method_7909() == CustomItems.scripter && !isClientSide && npcInteracted) {
            if (!CustomNpcsPermissions.hasPermission((class_3222)player, CustomNpcsPermissions.NPC_GUI)) {
                return class_1269.field_5811;
            }
            NoppesUtilServer.setEditingNpc(player, (EntityNPCInterface)entity);
            isCancelled = true;
            Packets.send((class_3222)player, new PacketGuiOpen(EnumGuiType.Script, class_2338.field_10980));
        } else if (item.method_7909() == CustomItems.mount && !isClientSide) {
            if (!CustomNpcsPermissions.hasPermission((class_3222)player, CustomNpcsPermissions.TOOL_MOUNTER)) {
                return class_1269.field_5811;
            }
            PlayerData data = PlayerData.get(player);
            isCancelled = true;
            data.mounted = entity;
            Packets.send((class_3222)player, new PacketGuiOpen(EnumGuiType.MobSpawnerMounter, class_2338.field_10980));
        }
        return isCancelled ? class_1269.field_5814 : class_1269.field_5811;
    }

    public void afterDeath(class_1309 entity, class_1282 damageSource) {
        if (entity.method_37908().field_9236) {
            return;
        }
        class_1297 source = NoppesUtilServer.GetDamageSourcee(damageSource);
        if (source != null) {
            if (source instanceof EntityNPCInterface && entity != null) {
                EntityNPCInterface npc = (EntityNPCInterface)source;
                Line line = npc.advanced.getKillLine();
                if (line != null) {
                    npc.saySurrounding(Line.formatTarget(line, entity));
                }
                EventHooks.onNPCKills(npc, entity);
            }
            class_1657 player = null;
            if (source instanceof class_1657) {
                player = (class_1657)source;
            } else if (source instanceof EntityNPCInterface && ((EntityNPCInterface)source).getOwner() instanceof class_1657) {
                player = (class_1657)((EntityNPCInterface)source).getOwner();
            }
            if (player != null) {
                this.doQuest(player, entity, true);
                if (entity instanceof EntityNPCInterface) {
                    this.doFactionPoints(player, (EntityNPCInterface)entity);
                }
            }
        }
        if (entity instanceof class_1657) {
            PlayerData data = PlayerData.get((class_1657)entity);
            data.save(false);
        }
    }

    private void doFactionPoints(class_1657 player, EntityNPCInterface npc) {
        npc.advanced.factions.addPoints(player);
    }

    private void doQuest(class_1657 player, class_1309 entity, boolean all) {
        PlayerData pdata = PlayerData.get(player);
        PlayerQuestData playerdata = pdata.questData;
        String entityName = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
        if (entity instanceof class_1657) {
            entityName = "Player";
        }
        for (QuestData data : playerdata.activeQuests.values()) {
            if (data.quest.type != 2 && data.quest.type != 4) continue;
            if (data.quest.type == 4 && all) {
                List list = player.method_37908().method_18467(class_1657.class, entity.method_5829().method_1009(10.0, 10.0, 10.0));
                for (class_1657 pl : list) {
                    if (pl == player) continue;
                    this.doQuest(pl, entity, false);
                }
            }
            String name = entityName;
            QuestKill quest = (QuestKill)data.quest.questInterface;
            if (quest.targets.containsKey(entity.method_5477().getString())) {
                name = entity.method_5477().getString();
            } else if (!quest.targets.containsKey(name)) continue;
            HashMap<String, Integer> killed = quest.getKilled(data);
            if (killed.containsKey(name) && killed.get(name) >= quest.targets.get(name)) continue;
            int amount = 0;
            if (killed.containsKey(name)) {
                amount = killed.get(name);
            }
            killed.put(name, amount + 1);
            quest.setKilled(data, killed);
            pdata.updateClient = true;
        }
        playerdata.checkQuestCompletion(player, 2);
        playerdata.checkQuestCompletion(player, 4);
    }

    public static boolean allowCommandMessage(ParseResults<class_2168> parseRes) {
        String command = parseRes.getReader().getString();
        if (command.startsWith("give ")) {
            try {
                CommandContext context = parseRes.getContext().build(parseRes.getReader().getString());
                Collection players = class_2186.method_9312((CommandContext)context, (String)"targets");
                for (class_3222 player : players) {
                    player.method_5682().execute((Runnable)ListenableFutureTask.create(Executors.callable(() -> {
                        PlayerQuestData playerdata = PlayerData.get((class_1657)player).questData;
                        playerdata.checkQuestCompletion((class_1657)player, 0);
                    })));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (command.startsWith("time ")) {
            try {
                CustomNpcs.Server.method_20493(() -> {
                    List players = CustomNpcs.Server.method_3760().method_14571();
                    for (class_3222 playerMP : players) {
                        VisibilityController.instance.onUpdate(playerMP);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }
}

