/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_266;
import net.minecraft.class_2751;
import net.minecraft.class_2757;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_9013;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import net.minecraft.server.MinecraftServer;
import noppes.npcs.CustomItems;
import noppes.npcs.NBTTags;
import noppes.npcs.NPCSpawning;
import noppes.npcs.controllers.MassBlockController;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.VisibilityController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.entity.data.DataScenes;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketSync;

public class ServerTickHandler
implements ServerTickEvents.StartTick,
ServerPlayConnectionEvents.Join {
    public int ticks = 0;

    public void onStartTick(MinecraftServer server) {
        NBTTags.server = server;
        if (this.ticks++ >= 20) {
            SchematicController.Instance.updateBuilding(server);
            MassBlockController.Update();
            this.ticks = 0;
            for (DataScenes.SceneState state : DataScenes.StartedScenes.values()) {
                if (state.paused) continue;
                ++state.ticks;
            }
            for (DataScenes.SceneContainer entry : DataScenes.ScenesToRun) {
                entry.update();
            }
            DataScenes.ScenesToRun = new ArrayList<DataScenes.SceneContainer>();
        }
        for (class_3218 level : server.method_3738()) {
            NPCSpawning.findChunksForSpawning(level);
        }
        for (class_1657 player : server.method_3760().method_14571()) {
            PlayerData data = PlayerData.get(player);
            if (player.method_5770().method_8532() % 24000L == 1L || player.method_5770().method_8532() % 240000L == 12001L) {
                VisibilityController.instance.onUpdate((class_3222)player);
            }
            if (data.updateClient) {
                Packets.send((class_3222)player, new PacketSync(8, data.getSyncNBT(), true));
                VisibilityController.instance.onUpdate((class_3222)player);
                data.updateClient = false;
            }
            if (data.prevHeldItem != player.method_6047() && (data.prevHeldItem.method_7909() == CustomItems.wand || player.method_6047().method_7909() == CustomItems.wand)) {
                VisibilityController.instance.onUpdate((class_3222)player);
            }
            data.prevHeldItem = player.method_6047();
        }
    }

    public void onPlayReady(class_3244 handler, PacketSender sender, MinecraftServer server) {
        final class_3222 player = handler.field_14140;
        for (class_3218 level : server.method_3738()) {
            class_2995 board = level.method_14170();
            for (String objective : Availability.scores) {
                class_266 so = board.method_1170(objective);
                if (so == null) continue;
                if (board.method_12936(so) == 0) {
                    player.field_13987.method_14364((class_2596)new class_2751(so, 0));
                }
                class_9014 sco = board.method_1180((class_9015)player, so);
                class_9013 info = board.method_55430((class_9015)player, so);
                player.field_13987.method_14364((class_2596)new class_2757(player.method_5820(), so.method_1113(), sco.method_55409(), Optional.ofNullable(sco.method_55419()), Optional.ofNullable(info.method_55400())));
            }
        }
        player.field_7498.method_7596(new class_1712(){

            public void method_7635(class_1703 container, int slotInd, class_1799 stack) {
                if (player.method_37908().field_9236) {
                    return;
                }
                PlayerQuestData playerdata = PlayerData.get((class_1657)player).questData;
                playerdata.checkQuestCompletion((class_1657)player, 0);
            }

            public void method_7633(class_1703 container, int varToUpdate, int newValue) {
            }
        });
        PlayerData data = PlayerData.get((class_1657)handler.field_14140);
        String serverName = "local";
        if (server.method_3816()) {
            serverName = "server";
        } else if (server.method_3860()) {
            serverName = "lan";
        }
        SyncController.syncPlayer(handler.field_14140);
    }
}

