/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.ability.AbstractAbility;
import noppes.npcs.entity.EntityNPCInterface;

public class CombatHandler {
    private Map<class_1309, Float> aggressors = new HashMap<class_1309, Float>();
    private EntityNPCInterface npc;
    private long startTime = 0L;
    private int combatResetTimer = 0;

    public CombatHandler(EntityNPCInterface npc) {
        this.npc = npc;
    }

    public void update() {
        if (this.npc.isKilled()) {
            if (this.npc.isAttacking()) {
                this.reset();
            }
            return;
        }
        if (this.npc.method_5968() != null && !this.npc.isAttacking()) {
            this.start();
        }
        if (!this.shouldCombatContinue()) {
            if (this.combatResetTimer++ > 40) {
                this.reset();
            }
            return;
        }
        this.combatResetTimer = 0;
    }

    private boolean shouldCombatContinue() {
        if (this.npc.method_5968() == null) {
            return false;
        }
        return this.isValidTarget(this.npc.method_5968());
    }

    public void damage(class_1282 source, float damageAmount) {
        this.combatResetTimer = 0;
        class_1297 e = NoppesUtilServer.GetDamageSourcee(source);
        if (e instanceof class_1309) {
            class_1309 el = (class_1309)e;
            Float f = this.aggressors.get(el);
            if (f == null) {
                f = Float.valueOf(0.0f);
            }
            this.aggressors.put(el, Float.valueOf(f.floatValue() + damageAmount));
        }
    }

    public void start() {
        this.combatResetTimer = 0;
        this.startTime = this.npc.method_37908().method_8401().method_188();
        this.npc.method_5841().method_12778(EntityNPCInterface.Attacking, (Object)true);
        for (AbstractAbility ab : this.npc.abilities.abilities) {
            ab.startCombat();
        }
    }

    public void reset() {
        this.combatResetTimer = 0;
        this.aggressors.clear();
        this.npc.method_5841().method_12778(EntityNPCInterface.Attacking, (Object)false);
        this.npc.method_5980(null);
    }

    public boolean checkTarget() {
        if (this.aggressors.isEmpty() || this.npc.field_6012 % 10 != 0) {
            return false;
        }
        class_1309 target = this.npc.method_5968();
        Float current = Float.valueOf(0.0f);
        if (this.isValidTarget(target)) {
            current = this.aggressors.get(target);
            if (current == null) {
                current = Float.valueOf(0.0f);
            }
        } else {
            target = null;
        }
        for (Map.Entry<class_1309, Float> entry : this.aggressors.entrySet()) {
            if (!(entry.getValue().floatValue() > current.floatValue()) || !this.isValidTarget(entry.getKey())) continue;
            current = entry.getValue();
            target = entry.getKey();
        }
        return target == null;
    }

    public boolean isValidTarget(class_1309 target) {
        if (target == null || !target.method_5805()) {
            return false;
        }
        if (target instanceof class_1657 && ((class_1657)target).method_31549().field_7480) {
            return false;
        }
        return this.npc.isInRange((class_1297)target, this.npc.stats.aggroRange);
    }
}

