/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import noppes.npcs.api.IDamageSource;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IEntityLiving;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.IProjectile;
import noppes.npcs.api.entity.data.ILine;
import noppes.npcs.api.event.CustomNPCsEvent;
import noppes.npcs.api.item.IItemStack;

public class NpcEvent
extends CustomNPCsEvent {
    public final ICustomNpc npc;

    public NpcEvent(ICustomNpc npc) {
        this.npc = npc;
    }

    public static class TimerEvent
    extends NpcEvent {
        public final int id;

        public TimerEvent(ICustomNpc npc, int id) {
            super(npc);
            this.id = id;
        }
    }

    public static class CollideEvent
    extends NpcEvent {
        public final IEntity entity;

        public CollideEvent(ICustomNpc npc, class_1297 entity) {
            super(npc);
            this.entity = NpcAPI.Instance().getIEntity(entity);
        }
    }

    public static class DamagedEvent
    extends NpcEvent {
        public final IDamageSource damageSource;
        public final IEntity source;
        public float damage;
        public boolean clearTarget = false;

        public DamagedEvent(ICustomNpc npc, class_1297 source, float damage, class_1282 damagesource) {
            super(npc);
            this.source = NpcAPI.Instance().getIEntity(source);
            this.damage = damage;
            this.damageSource = NpcAPI.Instance().getIDamageSource(damagesource);
        }
    }

    public static class RangedLaunchedEvent
    extends NpcEvent {
        public final IEntityLiving target;
        public float damage;
        public List<IProjectile> projectiles = new ArrayList<IProjectile>();

        public RangedLaunchedEvent(ICustomNpc npc, class_1309 target, float damage) {
            super(npc);
            this.target = (IEntityLiving)NpcAPI.Instance().getIEntity((class_1297)target);
            this.damage = damage;
        }
    }

    public static class MeleeAttackEvent
    extends NpcEvent {
        public final IEntityLiving target;
        public float damage;

        public MeleeAttackEvent(ICustomNpc npc, class_1309 target, float damage) {
            super(npc);
            this.target = (IEntityLiving)NpcAPI.Instance().getIEntity((class_1297)target);
            this.damage = damage;
        }
    }

    public static class KilledEntityEvent
    extends NpcEvent {
        public final IEntityLiving entity;

        public KilledEntityEvent(ICustomNpc npc, class_1309 entity) {
            super(npc);
            this.entity = (IEntityLiving)NpcAPI.Instance().getIEntity((class_1297)entity);
        }
    }

    public static class DiedEvent
    extends NpcEvent {
        public final IDamageSource damageSource;
        public final String type;
        public final IEntity source;
        public IItemStack[] droppedItems;
        public int expDropped;
        public ILine line;

        public DiedEvent(ICustomNpc npc, class_1282 damagesource, class_1297 entity) {
            super(npc);
            this.damageSource = NpcAPI.Instance().getIDamageSource(damagesource);
            this.type = damagesource.method_5525();
            this.source = NpcAPI.Instance().getIEntity(entity);
        }
    }

    public static class InteractEvent
    extends NpcEvent {
        public final IPlayer player;

        public InteractEvent(ICustomNpc npc, class_1657 player) {
            super(npc);
            this.player = (IPlayer)NpcAPI.Instance().getIEntity((class_1297)player);
        }
    }

    public static class TargetLostEvent
    extends NpcEvent {
        public final IEntityLiving entity;

        public TargetLostEvent(ICustomNpc npc, class_1309 entity) {
            super(npc);
            this.entity = (IEntityLiving)NpcAPI.Instance().getIEntity((class_1297)entity);
        }
    }

    public static class TargetEvent
    extends NpcEvent {
        public IEntityLiving entity;

        public TargetEvent(ICustomNpc npc, class_1309 entity) {
            super(npc);
            this.entity = (IEntityLiving)NpcAPI.Instance().getIEntity((class_1297)entity);
        }
    }

    public static class UpdateEvent
    extends NpcEvent {
        public UpdateEvent(ICustomNpc npc) {
            super(npc);
        }
    }

    public static class InitEvent
    extends NpcEvent {
        public InitEvent(ICustomNpc npc) {
            super(npc);
        }
    }
}

