/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.PotionEffectType;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IEntityLiving;
import noppes.npcs.api.entity.data.IMark;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.EntityWrapper;
import noppes.npcs.controllers.data.MarkData;

public class EntityLivingBaseWrapper<T extends class_1309>
extends EntityWrapper<T>
implements IEntityLiving {
    public EntityLivingBaseWrapper(T entity) {
        super(entity);
    }

    @Override
    public float getHealth() {
        return ((class_1309)this.entity).method_6032();
    }

    @Override
    public void setHealth(float health) {
        ((class_1309)this.entity).method_6033(health);
    }

    @Override
    public float getMaxHealth() {
        return ((class_1309)this.entity).method_6063();
    }

    @Override
    public void setMaxHealth(float health) {
        if (health < 0.0f) {
            return;
        }
        ((class_1309)this.entity).method_5996(class_5134.field_23716).method_6192((double)health);
    }

    @Override
    public boolean isAttacking() {
        return ((class_1309)this.entity).method_6065() != null;
    }

    @Override
    public void setAttackTarget(IEntityLiving living) {
        if (living == null) {
            ((class_1309)this.entity).method_6015(null);
        } else {
            ((class_1309)this.entity).method_6015(living.getMCEntity());
        }
    }

    @Override
    public IEntityLiving getAttackTarget() {
        return (IEntityLiving)NpcAPI.Instance().getIEntity((class_1297)((class_1309)this.entity).method_6065());
    }

    @Override
    public IEntityLiving getLastAttacked() {
        return (IEntityLiving)NpcAPI.Instance().getIEntity((class_1297)((class_1309)this.entity).method_6052());
    }

    @Override
    public int getLastAttackedTime() {
        return ((class_1309)this.entity).method_6083();
    }

    @Override
    public boolean canSeeEntity(IEntity entity) {
        return ((class_1309)this.entity).method_6057(entity.getMCEntity());
    }

    @Override
    public void swingMainhand() {
        ((class_1309)this.entity).method_6104(class_1268.field_5808);
    }

    @Override
    public void swingOffhand() {
        ((class_1309)this.entity).method_6104(class_1268.field_5810);
    }

    @Override
    public void addPotionEffect(int effect, int duration, int strength, boolean hideParticles) {
        class_1291 p = (class_1291)class_7923.field_41174.method_10200(effect);
        if (p == null) {
            return;
        }
        if (strength < 0) {
            strength = 0;
        } else if (strength > 255) {
            strength = 255;
        }
        if (duration < 0) {
            duration = 0;
        } else if (duration > 1000000) {
            duration = 1000000;
        }
        if (!p.method_5561()) {
            duration *= 20;
        }
        if (duration == 0) {
            ((class_1309)this.entity).method_6016((class_6880)PotionEffectType.getHolder(effect).get());
        } else {
            ((class_1309)this.entity).method_6092(new class_1293((class_6880)PotionEffectType.getHolder(effect).get(), duration, strength, false, hideParticles));
        }
    }

    @Override
    public void clearPotionEffects() {
        ((class_1309)this.entity).method_6012();
    }

    @Override
    public int getPotionEffect(int effect) {
        class_1293 pf = ((class_1309)this.entity).method_6112(class_6880.method_40223((Object)((class_1291)class_7923.field_41174.method_10200(effect))));
        if (pf == null) {
            return -1;
        }
        return pf.method_5578();
    }

    @Override
    public IItemStack getMainhandItem() {
        return NpcAPI.Instance().getIItemStack(((class_1309)this.entity).method_6047());
    }

    @Override
    public void setMainhandItem(IItemStack item) {
        ((class_1309)this.entity).method_6122(class_1268.field_5808, item == null ? class_1799.field_8037 : item.getMCItemStack());
    }

    @Override
    public IItemStack getOffhandItem() {
        return NpcAPI.Instance().getIItemStack(((class_1309)this.entity).method_6079());
    }

    @Override
    public void setOffhandItem(IItemStack item) {
        ((class_1309)this.entity).method_6122(class_1268.field_5810, item == null ? class_1799.field_8037 : item.getMCItemStack());
    }

    @Override
    public IItemStack getArmor(int slot) {
        if (slot < 0 || slot > 3) {
            throw new CustomNPCsException("Wrong slot id:" + slot, new Object[0]);
        }
        return NpcAPI.Instance().getIItemStack(((class_1309)this.entity).method_6118(this.getSlot(slot)));
    }

    @Override
    public void setArmor(int slot, IItemStack item) {
        if (slot < 0 || slot > 3) {
            throw new CustomNPCsException("Wrong slot id:" + slot, new Object[0]);
        }
        ((class_1309)this.entity).method_5673(this.getSlot(slot), item == null ? class_1799.field_8037 : item.getMCItemStack());
    }

    private class_1304 getSlot(int slot) {
        if (slot == 3) {
            return class_1304.field_6169;
        }
        if (slot == 2) {
            return class_1304.field_6174;
        }
        if (slot == 1) {
            return class_1304.field_6172;
        }
        if (slot == 0) {
            return class_1304.field_6166;
        }
        return null;
    }

    @Override
    public float getRotation() {
        return ((class_1309)this.entity).field_6283;
    }

    @Override
    public void setRotation(float rotation) {
        ((class_1309)this.entity).field_6283 = rotation;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 5 ? true : super.typeOf(type);
    }

    @Override
    public boolean isChild() {
        return ((class_1309)this.entity).method_6109();
    }

    @Override
    public IMark addMark(int type) {
        MarkData data = MarkData.get((class_1309)this.entity);
        return data.addMark(type);
    }

    @Override
    public void removeMark(IMark mark) {
        MarkData data = MarkData.get((class_1309)this.entity);
        data.marks.remove(mark);
        data.syncClients();
    }

    @Override
    public IMark[] getMarks() {
        MarkData data = MarkData.get((class_1309)this.entity);
        return data.marks.toArray(new IMark[data.marks.size()]);
    }

    @Override
    public float getMoveForward() {
        return ((class_1309)this.entity).field_6250;
    }

    @Override
    public void setMoveForward(float move) {
        ((class_1309)this.entity).field_6250 = move;
    }

    @Override
    public float getMoveStrafing() {
        return ((class_1309)this.entity).field_6212;
    }

    @Override
    public void setMoveStrafing(float move) {
        ((class_1309)this.entity).field_6212 = move;
    }

    @Override
    public float getMoveVertical() {
        return ((class_1309)this.entity).field_6227;
    }

    @Override
    public void setMoveVertical(float move) {
        ((class_1309)this.entity).field_6227 = move;
    }
}

