/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_9279;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import noppes.npcs.EventHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.event.Event;
import noppes.npcs.api.item.IItemScripted;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.items.ItemDataComponents;

public class ItemScriptedWrapper
extends ItemStackWrapper
implements IItemScripted,
IScriptHandler {
    public List<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
    public String scriptLanguage = "ECMAScript";
    public boolean enabled = false;
    public long lastInited = -1L;
    public boolean updateClient = false;
    public boolean durabilityShow = true;
    public float durabilityValue = 1.0f;
    public int durabilityColor = -1;
    public int itemColor = -1;
    public int stackSize = 64;
    public boolean loaded = false;
    public class_2960 texture = null;

    public ItemScriptedWrapper(class_1799 item) {
        super(item);
        this.loadScriptData();
    }

    @Override
    public boolean hasTexture(int damage) {
        return this.texture != null;
    }

    @Override
    public String getTexture(int damage) {
        return this.getTexture();
    }

    @Override
    public String getTexture() {
        if (this.texture == null) {
            return null;
        }
        return this.texture.toString();
    }

    @Override
    public void setTexture(int damage, String texture) {
        this.setTexture(texture);
    }

    @Override
    public void setTexture(String texture) {
        this.texture = texture == null ? null : class_2960.method_12829((String)texture);
    }

    public class_2487 getScriptNBT(class_2487 compound) {
        compound.method_10566("Scripts", (class_2520)NBTTags.NBTScript(this.scripts));
        compound.method_10582("ScriptLanguage", this.scriptLanguage);
        compound.method_10556("ScriptEnabled", this.enabled);
        if (this.texture != null) {
            compound.method_10582("ScriptTexture", this.texture.toString());
        }
        return compound;
    }

    @Override
    public class_2487 getMCNbt() {
        class_2487 compound = super.getMCNbt();
        this.getScriptNBT(compound);
        compound.method_10556("DurabilityShow", this.durabilityShow);
        compound.method_10548("DurabilityValue", this.durabilityValue);
        compound.method_10569("DurabilityColor", this.durabilityColor);
        compound.method_10569("ItemColor", this.itemColor);
        compound.method_10569("MaxStackSize", this.stackSize);
        if (this.item.method_57353() instanceof class_9335) {
            compound.method_10566("ItemTags", (class_2520)class_9326.field_49589.encodeStart((DynamicOps)class_2509.field_11560, (Object)((class_9335)this.item.method_57353()).method_57940()).getOrThrow());
        }
        return compound;
    }

    public void setScriptNBT(class_2487 compound) {
        if (!compound.method_10545("Scripts")) {
            return;
        }
        this.scripts = NBTTags.GetScript(compound.method_10554("Scripts", 10), this);
        this.scriptLanguage = compound.method_10558("ScriptLanguage");
        this.enabled = compound.method_10577("ScriptEnabled");
        if (compound.method_10545("ScriptTexture")) {
            this.texture = class_2960.method_12829((String)compound.method_10558("ScriptTexture"));
        }
    }

    @Override
    public void setMCNbt(class_2487 compound) {
        super.setMCNbt(compound);
        this.setScriptNBT(compound);
        this.durabilityShow = compound.method_10577("DurabilityShow");
        this.durabilityValue = compound.method_10583("DurabilityValue");
        if (compound.method_10545("DurabilityColor")) {
            this.durabilityColor = compound.method_10550("DurabilityColor");
        }
        this.itemColor = compound.method_10550("ItemColor");
        this.stackSize = compound.method_10550("MaxStackSize");
        if (compound.method_10545("ItemTags")) {
            this.item.method_57366((class_9326)class_9326.field_49589.parse((DynamicOps)class_2509.field_11560, (Object)compound.method_10562("ItemTags")).getOrThrow());
        }
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void runScript(EnumScriptType type, Event event) {
        if (!this.loaded) {
            this.loadScriptData();
            this.loaded = true;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (ScriptController.Instance.lastLoaded > this.lastInited) {
            this.lastInited = ScriptController.Instance.lastLoaded;
            if (type != EnumScriptType.INIT) {
                EventHooks.onScriptItemInit(this);
            }
        }
        for (ScriptContainer script : this.scripts) {
            script.run(type, event);
        }
    }

    private boolean isEnabled() {
        return this.enabled && ScriptController.HasStart;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bo) {
        this.enabled = bo;
    }

    @Override
    public String getLanguage() {
        return this.scriptLanguage;
    }

    @Override
    public void setLanguage(String lang) {
        this.scriptLanguage = lang;
    }

    @Override
    public List<ScriptContainer> getScripts() {
        return this.scripts;
    }

    @Override
    public String noticeString() {
        return "ScriptedItem";
    }

    @Override
    public Map<Long, String> getConsoleText() {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        int tab = 0;
        for (ScriptContainer script : this.getScripts()) {
            ++tab;
            for (Map.Entry<Long, String> entry : script.console.entrySet()) {
                map.put(entry.getKey(), " tab " + tab + ":\n" + entry.getValue());
            }
        }
        return map;
    }

    @Override
    public void clearConsole() {
        for (ScriptContainer script : this.getScripts()) {
            script.console.clear();
        }
    }

    @Override
    public int getMaxStackSize() {
        return (Integer)this.item.method_57824(class_9334.field_50071);
    }

    @Override
    public void setMaxStackSize(int size) {
        if (size < 1 || size > 64) {
            throw new CustomNPCsException("Stacksize has to be between 1 and 64", new Object[0]);
        }
        this.item.method_57379(class_9334.field_50071, (Object)size);
    }

    @Override
    public double getDurabilityValue() {
        return this.durabilityValue;
    }

    @Override
    public void setDurabilityValue(float value) {
        if (value != this.durabilityValue) {
            this.updateClient = true;
        }
        this.durabilityValue = value;
    }

    @Override
    public boolean getDurabilityShow() {
        return this.durabilityShow;
    }

    @Override
    public void setDurabilityShow(boolean bo) {
        if (bo != this.durabilityShow) {
            this.updateClient = true;
        }
        this.durabilityShow = bo;
    }

    @Override
    public int getDurabilityColor() {
        return this.durabilityColor;
    }

    @Override
    public void setDurabilityColor(int color) {
        if (color != this.durabilityColor) {
            this.updateClient = true;
        }
        this.durabilityColor = color;
    }

    @Override
    public int getColor() {
        return this.itemColor;
    }

    @Override
    public void setColor(int color) {
        if (color != this.itemColor) {
            this.updateClient = true;
        }
        this.itemColor = color;
    }

    public void saveScriptData() {
        this.item.method_57379(ItemDataComponents.SCRIPTED_DATA, (Object)class_9279.method_57456((class_2487)this.getScriptNBT(new class_2487())));
    }

    public void loadScriptData() {
        if (!this.item.method_57826(ItemDataComponents.SCRIPTED_DATA)) {
            return;
        }
        this.setScriptNBT(((class_9279)this.item.method_57824(ItemDataComponents.SCRIPTED_DATA)).method_57463());
    }
}

