/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1840;
import net.minecraft.class_1843;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_5134;
import net.minecraft.class_5151;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9279;
import net.minecraft.class_9285;
import net.minecraft.class_9290;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import noppes.npcs.ItemStackEmptyWrapper;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IMob;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemArmorWrapper;
import noppes.npcs.api.wrapper.ItemBlockWrapper;
import noppes.npcs.api.wrapper.ItemBookWrapper;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.items.ItemDataComponents;
import noppes.npcs.items.ItemScripted;

public class ItemStackWrapper
implements IItemStack {
    private Map<String, Object> tempData = new HashMap<String, Object>();
    private static Map<Integer, ItemStackWrapper> dataMap = new HashMap<Integer, ItemStackWrapper>();
    private static final class_1304[] VALID_EQUIPMENT_SLOTS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    public class_1799 item;
    private class_2487 storedData = new class_2487();
    public static ItemStackWrapper AIR = new ItemStackEmptyWrapper();
    private final IData tempdata = new IData(){

        @Override
        public void put(String key, Object value) {
            ItemStackWrapper.this.tempData.put(key, value);
        }

        @Override
        public Object get(String key) {
            return ItemStackWrapper.this.tempData.get(key);
        }

        @Override
        public void remove(String key) {
            ItemStackWrapper.this.tempData.remove(key);
        }

        @Override
        public boolean has(String key) {
            return ItemStackWrapper.this.tempData.containsKey(key);
        }

        @Override
        public void clear() {
            ItemStackWrapper.this.tempData.clear();
        }

        @Override
        public String[] getKeys() {
            return ItemStackWrapper.this.tempData.keySet().toArray(new String[ItemStackWrapper.this.tempData.size()]);
        }
    };
    private final IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            boolean changed = false;
            if (value instanceof Number) {
                ItemStackWrapper.this.storedData.method_10549(key, ((Number)value).doubleValue());
                changed = true;
            } else if (value instanceof String) {
                ItemStackWrapper.this.storedData.method_10582(key, (String)value);
                changed = true;
            }
            if (changed) {
                ItemStackWrapper.this.item.method_57379(ItemDataComponents.STORED_DATA, (Object)class_9279.method_57456((class_2487)ItemStackWrapper.this.storedData));
            }
        }

        @Override
        public Object get(String key) {
            if (!ItemStackWrapper.this.storedData.method_10545(key)) {
                return null;
            }
            class_2520 base = ItemStackWrapper.this.storedData.method_10580(key);
            if (base instanceof class_2514) {
                return ((class_2514)base).method_10697();
            }
            return base.method_10714();
        }

        @Override
        public void remove(String key) {
            ItemStackWrapper.this.storedData.method_10551(key);
        }

        @Override
        public boolean has(String key) {
            return ItemStackWrapper.this.storedData.method_10545(key);
        }

        @Override
        public void clear() {
            ItemStackWrapper.this.storedData = new class_2487();
        }

        @Override
        public String[] getKeys() {
            return ItemStackWrapper.this.storedData.method_10541().toArray(new String[ItemStackWrapper.this.storedData.method_10541().size()]);
        }
    };
    private static final class_2960 key = new class_2960("customnpcs", "itemscripteddata");

    public ItemStackWrapper(class_1799 item) {
        this.item = item;
        if (item == null || !item.method_57826(ItemDataComponents.STORED_DATA)) {
            return;
        }
        this.storedData = ((class_9279)item.method_57824(ItemDataComponents.STORED_DATA)).method_57463();
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public int getStackSize() {
        return this.item.method_7947();
    }

    @Override
    public void setStackSize(int size) {
        if (size > this.getMaxStackSize()) {
            throw new CustomNPCsException("Can't set the stacksize bigger than MaxStacksize", new Object[0]);
        }
        this.item.method_7939(size);
    }

    @Override
    public void setAttribute(String name, double value) {
        this.setAttribute(name, value, -1);
    }

    @Override
    public void setAttribute(String name, double value, int slot) {
        if (slot < -1 || slot > 5) {
            throw new CustomNPCsException("Slot has to be between -1 and 5, given was: " + slot, new Object[0]);
        }
        class_9285 modifiers = (class_9285)this.item.method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
        List nbttaglist = modifiers.comp_2393();
        ArrayList<class_9285.class_9287> newList = new ArrayList<class_9285.class_9287>();
        for (class_9285.class_9287 entry : nbttaglist) {
            if (entry.comp_2396().comp_2447().toString().equals(name)) continue;
            newList.add(entry);
        }
        if (value != 0.0) {
            class_1322 modifier = new class_1322(class_2960.method_12829((String)name), value, class_1322.class_1323.field_6328);
            class_9274 group = slot >= 0 ? class_9274.method_59524((class_1304)class_1304.values()[slot]) : class_9274.field_49216;
            newList.add(new class_9285.class_9287(class_6880.method_40223((Object)((class_1320)class_7923.field_41190.method_10223(class_2960.method_12829((String)name)))), modifier, group));
        }
        this.item.method_57379(class_9334.field_49636, (Object)new class_9285(newList, modifiers.comp_2394()));
    }

    @Override
    public double getAttribute(String name) {
        class_9285 modifiers = (class_9285)this.item.method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
        for (class_9285.class_9287 entry : modifiers.comp_2393()) {
            if (!entry.comp_2396().comp_2447().toString().equals(name)) continue;
            return entry.comp_2396().comp_2449();
        }
        return 0.0;
    }

    @Override
    public boolean hasAttribute(String name) {
        class_9285 modifiers = (class_9285)this.item.method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
        for (class_9285.class_9287 entry : modifiers.comp_2393()) {
            if (!entry.comp_2396().comp_2447().toString().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addEnchantment(String id, int strenght) {
        class_1887 ench = (class_1887)NBTTags.access.method_45926().method_30530(class_7924.field_41265).method_10223(class_2960.method_12829((String)id));
        if (ench == null) {
            throw new CustomNPCsException("Unknown enchant id:" + id, new Object[0]);
        }
        this.item.method_7978(class_6880.method_40223((Object)ench), strenght);
    }

    @Override
    public boolean isEnchanted() {
        return this.item.method_7942();
    }

    @Override
    public boolean hasEnchant(String id) {
        class_1887 ench = (class_1887)NBTTags.access.method_45926().method_30530(class_7924.field_41265).method_10223(class_2960.method_12829((String)id));
        if (ench == null) {
            throw new CustomNPCsException("Unknown enchant id:" + id, new Object[0]);
        }
        if (!this.isEnchanted()) {
            return false;
        }
        class_9304 enchantments = (class_9304)this.item.method_57825(class_9334.field_49633, (Object)class_9304.field_49385);
        return enchantments.method_57536(class_6880.method_40223((Object)ench)) > 0;
    }

    @Override
    public boolean removeEnchant(String id) {
        class_1887 ench = (class_1887)NBTTags.access.method_45926().method_30530(class_7924.field_41265).method_10223(class_2960.method_12829((String)id));
        if (ench == null) {
            throw new CustomNPCsException("Unknown enchant id:" + id, new Object[0]);
        }
        if (!this.isEnchanted()) {
            return false;
        }
        class_9304 enchantments = class_1890.method_57532((class_1799)this.item);
        class_9304.class_9305 newList = new class_9304.class_9305(class_9304.field_49385);
        for (Object2IntMap.Entry entry : enchantments.method_57539()) {
            if (((class_5321)((class_6880)entry.getKey()).method_40230().get()).toString().equalsIgnoreCase(id)) continue;
            newList.method_57547(class_6880.method_40223((Object)((class_1887)((class_6880)entry.getKey()).comp_349())), entry.getIntValue());
        }
        if (enchantments.method_57541() == newList.method_57545().size()) {
            return false;
        }
        this.item.method_57379(class_9334.field_49633, (Object)newList.method_57549());
        return true;
    }

    @Override
    public boolean isBlock() {
        class_2248 block = class_2248.method_9503((class_1792)this.item.method_7909());
        return block != null && block != class_2246.field_10124;
    }

    @Override
    public boolean hasCustomName() {
        return this.item.method_57826(class_9334.field_49631);
    }

    @Override
    public void setCustomName(String name) {
        this.item.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)name));
    }

    @Override
    public String getDisplayName() {
        return this.item.method_7964().getString();
    }

    @Override
    public String getItemName() {
        return this.item.method_7909().method_7864(this.item).getString();
    }

    @Override
    public String getName() {
        return class_7923.field_41178.method_10221((Object)this.item.method_7909()).toString();
    }

    @Override
    public INbt getNbt() {
        if (this.item.method_57353() == class_9323.field_49584) {
            return NpcAPI.Instance().getINbt(new class_2487());
        }
        class_9335 data = (class_9335)this.item.method_57353();
        return NpcAPI.Instance().getINbt((class_2487)class_9326.field_49589.encodeStart((DynamicOps)class_2509.field_11560, (Object)data.method_57940()).getOrThrow());
    }

    @Override
    public boolean hasNbt() {
        return !this.item.method_57353().method_57837();
    }

    @Override
    public class_1799 getMCItemStack() {
        return this.item;
    }

    public static class_1799 MCItem(IItemStack item) {
        if (item == null) {
            return class_1799.field_8037;
        }
        return item.getMCItemStack();
    }

    @Override
    public void damageItem(int damage, IMob living) {
        if (living != null) {
            this.item.method_7970(damage, living == null ? null : (class_1309)living.getMCEntity(), class_1304.field_6173);
        } else if (this.item.method_7963()) {
            if (this.item.method_7919() <= damage) {
                this.item.method_7934(1);
                this.item.method_7974(0);
            } else {
                this.item.method_7974(this.item.method_7919() - damage);
            }
        }
    }

    @Override
    public boolean isBook() {
        return false;
    }

    @Override
    public int getFoodLevel() {
        if (this.item.method_57826(class_9334.field_50075)) {
            return ((class_4174)this.item.method_57824(class_9334.field_50075)).comp_2491();
        }
        return 0;
    }

    @Override
    public IItemStack copy() {
        return ItemStackWrapper.createNew(this.item.method_7972());
    }

    @Override
    public int getMaxStackSize() {
        return this.item.method_7914();
    }

    @Override
    public boolean isDamageable() {
        return this.item.method_7963();
    }

    @Override
    public int getDamage() {
        return this.item.method_7919();
    }

    @Override
    public void setDamage(int value) {
        this.item.method_7974(value);
    }

    @Deprecated
    public int getItemDamage() {
        return this.item.method_7919();
    }

    @Deprecated
    public void setItemDamage(int value) {
        this.item.method_7974(value);
    }

    @Override
    public int getMaxDamage() {
        return this.item.method_7936();
    }

    @Override
    public INbt getItemNbt() {
        class_2487 compound = this.item.method_7960() ? new class_2487() : (class_2487)this.item.method_57358(NBTTags.getProvider());
        return NpcAPI.Instance().getINbt(compound);
    }

    @Override
    public double getAttackDamage() {
        class_9285 modifiers = (class_9285)this.item.method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
        double damage = 0.0;
        for (class_9285.class_9287 entry : modifiers.comp_2393()) {
            if (!((class_1320)entry.comp_2395().comp_349()).equals(class_5134.field_23721)) continue;
            damage = entry.comp_2396().comp_2449();
        }
        return damage;
    }

    @Override
    public boolean isEmpty() {
        return this.item.method_7960();
    }

    @Override
    public int getType() {
        if (this.item.method_7909() instanceof class_1829) {
            return 4;
        }
        return 0;
    }

    @Override
    public boolean isWearable() {
        return this.item.method_7909() instanceof class_5151;
    }

    private static ItemStackWrapper createNew(class_1799 item) {
        if (item == null || item.method_7960()) {
            return AIR;
        }
        if (item.method_7909() instanceof ItemScripted) {
            return new ItemScriptedWrapper(item);
        }
        if (item.method_7909() == class_1802.field_8360 || item.method_7909() == class_1802.field_8674 || item.method_7909() instanceof class_1840 || item.method_7909() instanceof class_1843) {
            return new ItemBookWrapper(item);
        }
        if (item.method_7909() instanceof class_1738) {
            return new ItemArmorWrapper(item);
        }
        class_2248 block = class_2248.method_9503((class_1792)item.method_7909());
        if (block != class_2246.field_10124) {
            return new ItemBlockWrapper(item);
        }
        return new ItemStackWrapper(item);
    }

    @Override
    public String[] getLore() {
        if (!this.item.method_57826(class_9334.field_49632)) {
            return new String[0];
        }
        List lore = ((class_9290)this.item.method_57824(class_9334.field_49632)).comp_2400();
        if (lore.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> loreStr = new ArrayList<String>();
        for (class_2561 line : lore) {
            loreStr.add(line.getString());
        }
        return loreStr.toArray(new String[lore.size()]);
    }

    @Override
    public void setLore(String[] lore) {
        if (lore == null || lore.length == 0) {
            this.item.method_57381(class_9334.field_49632);
            return;
        }
        class_9290 itemLore = new class_9290(new ArrayList());
        for (String s : lore) {
            try {
                class_5250 comp = class_2561.class_2562.method_10877((String)s, (class_7225.class_7874)NBTTags.getProvider());
                if (comp == null) continue;
                itemLore = itemLore.method_57499((class_2561)comp);
            }
            catch (JsonParseException jsonparseexception) {
                itemLore = itemLore.method_57499((class_2561)class_2561.method_43471((String)s));
            }
        }
        this.item.method_57379(class_9334.field_49632, (Object)itemLore);
    }

    public class_2487 serializeNBT() {
        return this.getMCNbt();
    }

    public void deserializeNBT(class_2487 nbt) {
        this.setMCNbt(nbt);
    }

    public class_2487 getMCNbt() {
        class_2487 compound = new class_2487();
        if (!this.storedData.method_33133()) {
            compound.method_10566("StoredData", (class_2520)this.storedData);
        }
        return compound;
    }

    public void setMCNbt(class_2487 compound) {
        this.storedData = compound == null || !compound.method_10545("StoredData") ? new class_2487() : compound.method_10562("StoredData");
    }

    @Override
    public void removeNbt() {
        this.item.method_57365(class_9323.field_49584);
    }

    @Override
    public boolean compare(IItemStack item, boolean ignoreNBT) {
        if (item == null) {
            item = AIR;
        }
        return NoppesUtilPlayer.compareItems(this.getMCItemStack(), item.getMCItemStack(), false, ignoreNBT);
    }
}

