/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_8566;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.api.handler.IRecipeHandler;
import noppes.npcs.api.handler.data.IRecipe;
import noppes.npcs.controllers.data.RecipeCarpentry;
import noppes.npcs.controllers.data.RecipesDefault;

public class RecipeController
implements IRecipeHandler {
    public HashMap<class_2960, RecipeCarpentry> globalRecipes = new HashMap();
    public HashMap<class_2960, RecipeCarpentry> anvilRecipes = new HashMap();
    public static RecipeController instance;
    public static final int version = 1;
    public int nextId = 1;
    public static HashMap<Integer, RecipeCarpentry> syncRecipes;

    public RecipeController() {
        instance = this;
    }

    public void load(class_7225.class_7874 provider) {
        this.loadCategories(provider);
        this.reloadGlobalRecipes();
        EventHooks.onGlobalRecipesLoaded(this);
    }

    public void reloadGlobalRecipes() {
    }

    private void loadCategories(class_7225.class_7874 provider) {
        File saveDir = CustomNpcs.getLevelSaveDirectory();
        try {
            File file = new File(saveDir, "recipes.dat");
            if (file.exists()) {
                this.loadCategories(provider, file);
            } else {
                this.globalRecipes.clear();
                this.anvilRecipes.clear();
                this.loadDefaultRecipes(provider, -1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                File file = new File(saveDir, "recipes.dat_old");
                if (file.exists()) {
                    this.loadCategories(provider, file);
                }
            }
            catch (Exception ee) {
                e.printStackTrace();
            }
        }
    }

    private void loadDefaultRecipes(class_7225.class_7874 provider, int i) {
        if (i == 1) {
            return;
        }
        RecipesDefault.loadDefaultRecipes(i);
        this.saveCategories(provider);
    }

    private void loadCategories(class_7225.class_7874 provider, File file) throws Exception {
    }

    private void saveCategories(class_7225.class_7874 provider) {
        try {
            File saveDir = CustomNpcs.getLevelSaveDirectory();
            class_2499 list = new class_2499();
            for (RecipeCarpentry recipe : this.globalRecipes.values()) {
                if (!recipe.savesRecipe) continue;
                list.add((Object)recipe.writeNBT(provider));
            }
            for (RecipeCarpentry recipe : this.anvilRecipes.values()) {
                if (!recipe.savesRecipe) continue;
                list.add((Object)recipe.writeNBT(provider));
            }
            class_2487 nbttagcompound = new class_2487();
            nbttagcompound.method_10566("Data", (class_2520)list);
            nbttagcompound.method_10569("LastId", this.nextId);
            nbttagcompound.method_10569("Version", 1);
            File file = new File(saveDir, "recipes.dat_new");
            File file1 = new File(saveDir, "recipes.dat_old");
            File file2 = new File(saveDir, "recipes.dat");
            class_2507.method_10634((class_2487)nbttagcompound, (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RecipeCarpentry findMatchingRecipe(class_8566 inventoryCrafting) {
        for (RecipeCarpentry recipe : this.anvilRecipes.values()) {
            if (!recipe.isValid() || !recipe.method_17728(inventoryCrafting.method_59961(), null)) continue;
            return recipe;
        }
        return null;
    }

    public RecipeCarpentry getRecipe(int id) {
        if (this.globalRecipes.containsKey(id)) {
            return this.globalRecipes.get(id);
        }
        if (this.anvilRecipes.containsKey(id)) {
            return this.anvilRecipes.get(id);
        }
        return null;
    }

    public RecipeCarpentry saveRecipe(RecipeCarpentry recipe) {
        return null;
    }

    private int getUniqueId() {
        ++this.nextId;
        return this.nextId;
    }

    private boolean containsRecipeName(String name) {
        return false;
    }

    @Override
    public RecipeCarpentry delete(int id) {
        RecipeCarpentry recipe = this.getRecipe(id);
        if (recipe == null) {
            return null;
        }
        return recipe;
    }

    @Override
    public List<IRecipe> getGlobalList() {
        return new ArrayList<IRecipe>(this.globalRecipes.values());
    }

    @Override
    public List<IRecipe> getCarpentryList() {
        return new ArrayList<IRecipe>(this.anvilRecipes.values());
    }

    @Override
    public IRecipe addRecipe(String name, boolean global, class_1799 result, Object ... objects) {
        return null;
    }

    @Override
    public IRecipe addRecipe(String name, boolean global, class_1799 result, int width, int height, class_1799 ... objects) {
        class_2371 list = class_2371.method_10211();
        for (class_1799 item : objects) {
            if (item.method_7960()) continue;
            list.add((Object)class_1856.method_8101((class_1799[])new class_1799[]{item}));
        }
        return null;
    }

    static {
        syncRecipes = new HashMap();
    }
}

