/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.handler.ICloneHandler;
import noppes.npcs.packets.server.SPacketToolMobSpawner;
import noppes.npcs.shared.common.util.LogWriter;
import noppes.npcs.util.NBTJsonUtil;

public class ServerCloneController
implements ICloneHandler {
    public long lastLoaded = System.currentTimeMillis();
    public static ServerCloneController Instance;

    public ServerCloneController() {
        this.loadClones();
    }

    private void loadClones() {
        try {
            File dir = new File(this.getDir(), "..");
            File file = new File(dir, "clonednpcs.dat");
            if (file.exists()) {
                Map<Integer, Map<String, class_2487>> clones = this.loadOldClones(file);
                file.delete();
                file = new File(dir, "clonednpcs.dat_old");
                if (file.exists()) {
                    file.delete();
                }
                for (int tab : clones.keySet()) {
                    Map<String, class_2487> map = clones.get(tab);
                    for (String name : map.keySet()) {
                        this.saveClone(tab, name, map.get(name));
                    }
                }
            }
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
    }

    public File getDir() {
        File dir = new File(CustomNpcs.getLevelSaveDirectory(), "clones");
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }

    private Map<Integer, Map<String, class_2487>> loadOldClones(File file) throws Exception {
        HashMap<Integer, Map<String, class_2487>> clones = new HashMap<Integer, Map<String, class_2487>>();
        class_2487 nbttagcompound1 = class_2507.method_10629((InputStream)new FileInputStream(file), (class_2505)class_2505.method_53898());
        class_2499 list = nbttagcompound1.method_10554("Data", 10);
        if (list == null) {
            return clones;
        }
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, class_2487> tab;
            class_2487 compound = list.method_10602(i);
            if (!compound.method_10545("ClonedTab")) {
                compound.method_10569("ClonedTab", 1);
            }
            if ((tab = (HashMap<String, class_2487>)clones.get(compound.method_10550("ClonedTab"))) == null) {
                tab = new HashMap<String, class_2487>();
                clones.put(compound.method_10550("ClonedTab"), tab);
            }
            String name = compound.method_10558("ClonedName");
            int number = 1;
            while (tab.containsKey(name)) {
                name = String.format("%s%s", compound.method_10558("ClonedName"), ++number);
            }
            compound.method_10551("ClonedName");
            compound.method_10551("ClonedTab");
            compound.method_10551("ClonedDate");
            this.cleanTags(compound);
            tab.put(name, compound);
        }
        return clones;
    }

    public class_2487 getCloneData(class_2168 player, String name, int tab) {
        File file = new File(new File(this.getDir(), "" + tab), name + ".json");
        if (!file.exists()) {
            if (player != null) {
                player.method_9213((class_2561)class_2561.method_43470((String)"Could not find clone file"));
            }
            return null;
        }
        try {
            return NBTJsonUtil.LoadFile(file);
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
            if (player != null) {
                player.method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            }
            return null;
        }
    }

    public void saveClone(int tab, String name, class_2487 compound) {
        try {
            File dir = new File(this.getDir(), "" + tab);
            if (!dir.exists()) {
                dir.mkdir();
            }
            String filename = name + ".json";
            File file = new File(dir, filename + "_new");
            File file2 = new File(dir, filename);
            NBTJsonUtil.SaveFile(file, compound);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            this.lastLoaded = System.currentTimeMillis();
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
    }

    public List<String> getClones(int tab) {
        ArrayList<String> list = new ArrayList<String>();
        File dir = new File(this.getDir(), "" + tab);
        if (!dir.exists() || !dir.isDirectory()) {
            return list;
        }
        for (String file : dir.list()) {
            if (!file.endsWith(".json")) continue;
            list.add(file.substring(0, file.length() - 5));
        }
        return list;
    }

    public boolean removeClone(String name, int tab) {
        File file = new File(new File(this.getDir(), "" + tab), name + ".json");
        if (!file.exists()) {
            return false;
        }
        file.delete();
        return true;
    }

    public String addClone(class_2487 nbttagcompound, String name, int tab) {
        this.cleanTags(nbttagcompound);
        this.saveClone(tab, name, nbttagcompound);
        return name;
    }

    public void cleanTags(class_2487 nbttagcompound) {
        class_2487 adv;
        if (nbttagcompound.method_10545("ItemGiverId")) {
            nbttagcompound.method_10569("ItemGiverId", 0);
        }
        if (nbttagcompound.method_10545("TransporterId")) {
            nbttagcompound.method_10569("TransporterId", -1);
        }
        nbttagcompound.method_10551("StartPosNew");
        nbttagcompound.method_10551("StartPos");
        nbttagcompound.method_10551("MovingPathNew");
        nbttagcompound.method_10551("Pos");
        nbttagcompound.method_10551("Riding");
        nbttagcompound.method_10551("UUID");
        nbttagcompound.method_10551("UUIDMost");
        nbttagcompound.method_10551("UUIDLeast");
        if (!nbttagcompound.method_10545("ModRev")) {
            nbttagcompound.method_10569("ModRev", 1);
        }
        if (nbttagcompound.method_10545("TransformRole")) {
            adv = nbttagcompound.method_10562("TransformRole");
            adv.method_10569("TransporterId", -1);
            nbttagcompound.method_10566("TransformRole", (class_2520)adv);
        }
        if (nbttagcompound.method_10545("TransformJob")) {
            adv = nbttagcompound.method_10562("TransformJob");
            adv.method_10569("ItemGiverId", 0);
            nbttagcompound.method_10566("TransformJob", (class_2520)adv);
        }
        if (nbttagcompound.method_10545("TransformAI")) {
            adv = nbttagcompound.method_10562("TransformAI");
            adv.method_10551("StartPosNew");
            adv.method_10551("StartPos");
            adv.method_10551("MovingPathNew");
            nbttagcompound.method_10566("TransformAI", (class_2520)adv);
        }
        if (nbttagcompound.method_10545("id")) {
            String id = nbttagcompound.method_10558("id");
            if (!CustomNpcs.FixUpdateFromPre_1_12) {
                id = id.replace("customnpcs.", "customnpcs:");
            }
            nbttagcompound.method_10582("id", id);
        }
    }

    @Override
    public IEntity spawn(double x, double y, double z, int tab, String name, IWorld level) {
        class_2487 compound = this.getCloneData(null, name, tab);
        if (compound == null) {
            throw new CustomNPCsException("Unknown clone tab:" + tab + " name:" + name, new Object[0]);
        }
        class_1297 entity = SPacketToolMobSpawner.spawnClone(compound, x, y, z, (class_1937)level.getMCLevel());
        if (entity == null) {
            return null;
        }
        return NpcAPI.Instance().getIEntity(entity);
    }

    @Override
    public IEntity get(int tab, String name, IWorld level) {
        class_2487 compound = this.getCloneData(null, name, tab);
        if (compound == null) {
            throw new CustomNPCsException("Unknown clone tab:" + tab + " name:" + name, new Object[0]);
        }
        Instance.cleanTags(compound);
        class_1297 entity = class_1299.method_5892((class_2487)compound, (class_1937)level.getMCLevel()).orElse(null);
        if (entity == null) {
            return null;
        }
        return NpcAPI.Instance().getIEntity(entity);
    }

    @Override
    public void set(int tab, String name, IEntity entity) {
        class_2487 compound = new class_2487();
        if (!entity.getMCEntity().method_5786(compound)) {
            throw new CustomNPCsException("Cannot save dead entities", new Object[0]);
        }
        this.cleanTags(compound);
        this.saveClone(tab, name, compound);
    }

    @Override
    public void remove(int tab, String name) {
        this.removeClone(name, tab);
    }

    public boolean hasClone(int tab, String name) {
        return this.getCloneData(null, name, tab) != null;
    }
}

