/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import noppes.npcs.NBTTags;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;
import noppes.npcs.roles.RoleInterface;

public class DataTransform {
    public class_2487 display;
    public class_2487 ai;
    public class_2487 advanced;
    public class_2487 inv;
    public class_2487 stats;
    public class_2487 role;
    public class_2487 job;
    public boolean hasDisplay;
    public boolean hasAi;
    public boolean hasAdvanced;
    public boolean hasInv;
    public boolean hasStats;
    public boolean hasRole;
    public boolean hasJob;
    public boolean isActive;
    private EntityNPCInterface npc;
    public boolean editingModus = false;

    public DataTransform(EntityNPCInterface npc) {
        this.npc = npc;
    }

    public class_2487 save(class_2487 compound) {
        compound.method_10556("TransformIsActive", this.isActive);
        this.writeOptions(compound);
        if (this.hasDisplay) {
            compound.method_10566("TransformDisplay", (class_2520)this.display);
        }
        if (this.hasAi) {
            compound.method_10566("TransformAI", (class_2520)this.ai);
        }
        if (this.hasAdvanced) {
            compound.method_10566("TransformAdvanced", (class_2520)this.advanced);
        }
        if (this.hasInv) {
            compound.method_10566("TransformInv", (class_2520)this.inv);
        }
        if (this.hasStats) {
            compound.method_10566("TransformStats", (class_2520)this.stats);
        }
        if (this.hasRole) {
            compound.method_10566("TransformRole", (class_2520)this.role);
        }
        if (this.hasJob) {
            compound.method_10566("TransformJob", (class_2520)this.job);
        }
        return compound;
    }

    public class_2487 writeOptions(class_2487 compound) {
        compound.method_10556("TransformHasDisplay", this.hasDisplay);
        compound.method_10556("TransformHasAI", this.hasAi);
        compound.method_10556("TransformHasAdvanced", this.hasAdvanced);
        compound.method_10556("TransformHasInv", this.hasInv);
        compound.method_10556("TransformHasStats", this.hasStats);
        compound.method_10556("TransformHasRole", this.hasRole);
        compound.method_10556("TransformHasJob", this.hasJob);
        compound.method_10556("TransformEditingModus", this.editingModus);
        return compound;
    }

    public void readToNBT(class_2487 compound) {
        this.isActive = compound.method_10577("TransformIsActive");
        this.readOptions(compound);
        this.display = this.hasDisplay ? compound.method_10562("TransformDisplay") : this.getDisplay();
        this.ai = this.hasAi ? compound.method_10562("TransformAI") : this.npc.ais.save(new class_2487());
        this.advanced = this.hasAdvanced ? compound.method_10562("TransformAdvanced") : this.getAdvanced();
        this.inv = this.hasInv ? compound.method_10562("TransformInv") : this.npc.inventory.save(new class_2487());
        this.stats = this.hasStats ? compound.method_10562("TransformStats") : this.npc.stats.save(new class_2487());
        this.job = this.hasJob ? compound.method_10562("TransformJob") : this.getJob();
        this.role = this.hasRole ? compound.method_10562("TransformRole") : this.getRole();
    }

    public class_2487 getJob() {
        class_2487 compound = new class_2487();
        compound.method_10569("NpcJob", this.npc.job.getType());
        this.npc.job.save(compound);
        return compound;
    }

    public class_2487 getRole() {
        class_2487 compound = new class_2487();
        compound.method_10569("Role", this.npc.role.getType());
        this.npc.role.save(compound);
        return compound;
    }

    public class_2487 getDisplay() {
        class_2487 compound = this.npc.display.save(new class_2487());
        if (this.npc instanceof EntityCustomNpc) {
            compound.method_10566("ModelData", (class_2520)((EntityCustomNpc)this.npc).modelData.save());
        }
        return compound;
    }

    public class_2487 getAdvanced() {
        JobInterface jopType = this.npc.job;
        RoleInterface roleType = this.npc.role;
        this.npc.job = JobInterface.NONE;
        this.npc.role = RoleInterface.NONE;
        class_2487 compound = this.npc.advanced.save(new class_2487());
        this.npc.job = jopType;
        this.npc.role = roleType;
        return compound;
    }

    public void readOptions(class_2487 compound) {
        boolean hadDisplay = this.hasDisplay;
        boolean hadAI = this.hasAi;
        boolean hadAdvanced = this.hasAdvanced;
        boolean hadInv = this.hasInv;
        boolean hadStats = this.hasStats;
        boolean hadRole = this.hasRole;
        boolean hadJob = this.hasJob;
        this.hasDisplay = compound.method_10577("TransformHasDisplay");
        this.hasAi = compound.method_10577("TransformHasAI");
        this.hasAdvanced = compound.method_10577("TransformHasAdvanced");
        this.hasInv = compound.method_10577("TransformHasInv");
        this.hasStats = compound.method_10577("TransformHasStats");
        this.hasRole = compound.method_10577("TransformHasRole");
        this.hasJob = compound.method_10577("TransformHasJob");
        this.editingModus = compound.method_10577("TransformEditingModus");
        if (this.hasDisplay && !hadDisplay) {
            this.display = this.getDisplay();
        }
        if (this.hasAi && !hadAI) {
            this.ai = this.npc.ais.save(new class_2487());
        }
        if (this.hasStats && !hadStats) {
            this.stats = this.npc.stats.save(new class_2487());
        }
        if (this.hasInv && !hadInv) {
            this.inv = this.npc.inventory.save(new class_2487());
        }
        if (this.hasAdvanced && !hadAdvanced) {
            this.advanced = this.getAdvanced();
        }
        if (this.hasJob && !hadJob) {
            this.job = this.getJob();
        }
        if (this.hasRole && !hadRole) {
            this.role = this.getRole();
        }
    }

    public boolean isValid() {
        return this.hasAdvanced || this.hasAi || this.hasDisplay || this.hasInv || this.hasStats || this.hasJob || this.hasRole;
    }

    public class_2487 processAdvanced(class_2487 compoundAdv, class_2487 compoundRole, class_2487 compoundJob) {
        if (this.hasAdvanced) {
            compoundAdv = this.advanced;
        }
        if (this.hasRole) {
            compoundRole = this.role;
        }
        if (this.hasJob) {
            compoundJob = this.job;
        }
        Set names = compoundRole.method_10541();
        for (String name : names) {
            compoundAdv.method_10566(name, compoundRole.method_10580(name));
        }
        names = compoundJob.method_10541();
        for (String name : names) {
            compoundAdv.method_10566(name, compoundJob.method_10580(name));
        }
        return compoundAdv;
    }

    public void transform(boolean isActive) {
        class_2487 compound;
        if (this.isActive == isActive) {
            return;
        }
        if (this.hasDisplay) {
            compound = this.getDisplay();
            this.npc.display.readToNBT(NBTTags.NBTMerge(compound, this.display));
            if (this.npc instanceof EntityCustomNpc) {
                ((EntityCustomNpc)this.npc).modelData.load(NBTTags.NBTMerge(compound.method_10562("ModelData"), this.display.method_10562("ModelData")));
            }
            this.display = compound;
        }
        if (this.hasStats) {
            compound = this.npc.stats.save(new class_2487());
            this.npc.stats.readToNBT(NBTTags.NBTMerge(compound, this.stats));
            this.stats = compound;
        }
        if (this.hasAdvanced || this.hasJob || this.hasRole) {
            class_2487 compoundAdv = this.getAdvanced();
            class_2487 compoundRole = this.getRole();
            class_2487 compoundJob = this.getJob();
            class_2487 compound2 = this.processAdvanced(compoundAdv, compoundRole, compoundJob);
            this.npc.advanced.readToNBT(compound2);
            if (this.npc.role.getType() != 0) {
                this.npc.role.load(NBTTags.NBTMerge(compoundRole, compound2));
            }
            if (this.npc.job.getType() != 0) {
                this.npc.job.load(NBTTags.NBTMerge(compoundJob, compound2));
            }
            if (this.hasAdvanced) {
                this.advanced = compoundAdv;
            }
            if (this.hasRole) {
                this.role = compoundRole;
            }
            if (this.hasJob) {
                this.job = compoundJob;
            }
        }
        if (this.hasAi) {
            compound = this.npc.ais.save(new class_2487());
            this.npc.ais.readToNBT(NBTTags.NBTMerge(compound, this.ai));
            this.ai = compound;
            this.npc.setCurrentAnimation(0);
        }
        if (this.hasInv) {
            compound = this.npc.inventory.save(new class_2487());
            this.npc.inventory.load(NBTTags.NBTMerge(compound, this.inv));
            this.inv = compound;
        }
        this.npc.updateAI = true;
        this.isActive = isActive;
        this.npc.updateClient = true;
    }
}

