/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import net.minecraft.class_1657;
import net.minecraft.class_2487;
import noppes.npcs.api.handler.data.IDialogOption;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.db.DatabaseColumn;

public class DialogOption
implements IDialogOption {
    @DatabaseColumn(name="id", type=DatabaseColumn.Type.INT)
    public int id = -1;
    @DatabaseColumn(name="dialog", type=DatabaseColumn.Type.INT)
    public int dialogId = -1;
    @DatabaseColumn(name="option", type=DatabaseColumn.Type.VARCHAR)
    public String option = "Talk";
    @DatabaseColumn(name="text", type=DatabaseColumn.Type.TEXT)
    public String title = "Talk";
    @DatabaseColumn(name="type", type=DatabaseColumn.Type.SMALLINT)
    public int optionType = 1;
    @DatabaseColumn(name="color", type=DatabaseColumn.Type.SMALLINT)
    public int optionColor = 0xE0E0E0;
    @DatabaseColumn(name="command", type=DatabaseColumn.Type.TEXT)
    public String command = "";
    @DatabaseColumn(name="order", type=DatabaseColumn.Type.SMALLINT)
    public int slot = -1;

    public void readNBT(class_2487 compound) {
        if (compound == null) {
            return;
        }
        this.title = compound.method_10558("Title");
        this.dialogId = compound.method_10550("Dialog");
        this.optionColor = compound.method_10550("DialogColor");
        this.optionType = compound.method_10550("OptionType");
        this.command = compound.method_10558("DialogCommand");
        if (this.optionColor == 0) {
            this.optionColor = 0xE0E0E0;
        }
    }

    public class_2487 writeNBT() {
        class_2487 compound = new class_2487();
        compound.method_10582("Title", this.title);
        compound.method_10569("OptionType", this.optionType);
        compound.method_10569("Dialog", this.dialogId);
        compound.method_10569("DialogColor", this.optionColor);
        compound.method_10582("DialogCommand", this.command);
        return compound;
    }

    public boolean hasDialog() {
        if (this.dialogId <= 0 || this.optionType != 1) {
            return false;
        }
        return DialogController.instance.hasDialog(this.dialogId);
    }

    public Dialog getDialog() {
        if (!this.hasDialog()) {
            return null;
        }
        return DialogController.instance.dialogs.get(this.dialogId);
    }

    public boolean isAvailable(class_1657 player) {
        if (this.optionType == 2) {
            return false;
        }
        if (this.optionType != 1) {
            return true;
        }
        Dialog dialog = this.getDialog();
        if (dialog == null) {
            return false;
        }
        return dialog.availability.isAvailable(player);
    }

    public boolean isValid() {
        if (this.optionType == 2) {
            return false;
        }
        return this.optionType != 1 || this.hasDialog();
    }

    public boolean canClose() {
        return this.optionType != 1 || !this.hasDialog();
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public int getType() {
        return this.optionType;
    }
}

